/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.eca46.process.SchedulerProcessorAbstract;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class SchedulerProcessor
extends SchedulerProcessorAbstract {
    private MScheduler schedulerProcessor = null;
    private StringBuffer summary = new StringBuffer();
    Properties schedulerContext = new Properties();
    private long startWork;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getSchedulerId() <= 0) {
            throw new AdempiereException("@AD_WorkflowProcessor_ID@ @NotFound@");
        }
        this.schedulerProcessor = new MScheduler(this.getCtx(), this.getSchedulerId(), this.get_TrxName());
    }

    protected String doIt() throws Exception {
        MOrgInfo schedorg;
        this.startWork = System.currentTimeMillis();
        this.summary = new StringBuffer(this.schedulerProcessor.toString()).append(" - ");
        this.schedulerContext.clear();
        MClient schedclient = MClient.get((Properties)this.getCtx(), (int)this.schedulerProcessor.getAD_Client_ID());
        Env.setContext((Properties)this.schedulerContext, (String)"#AD_Client_ID", (int)schedclient.getAD_Client_ID());
        Env.setContext((Properties)this.schedulerContext, (String)"#AD_Language", (String)schedclient.getAD_Language());
        Env.setContext((Properties)this.schedulerContext, (String)"#AD_Org_ID", (int)this.schedulerProcessor.getAD_Org_ID());
        if (this.schedulerProcessor.getAD_Org_ID() != 0 && (schedorg = MOrgInfo.get((Properties)this.getCtx(), (int)this.schedulerProcessor.getAD_Org_ID(), null)).getM_Warehouse_ID() > 0) {
            Env.setContext((Properties)this.schedulerContext, (String)"#M_Warehouse_ID", (int)schedorg.getM_Warehouse_ID());
        }
        Env.setContext((Properties)this.schedulerContext, (String)"#AD_User_ID", (int)this.getRunningUserId());
        Env.setContext((Properties)this.schedulerContext, (String)"#SalesRep_ID", (int)this.getRunningUserId());
        MUser scheduser = MUser.get((Properties)this.getCtx(), (int)this.getRunningUserId());
        MRole[] schedroles = scheduser.getRoles(this.schedulerProcessor.getAD_Org_ID());
        if (schedroles != null && schedroles.length > 0) {
            Env.setContext((Properties)this.schedulerContext, (String)"#AD_Role_ID", (int)schedroles[0].getAD_Role_ID());
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat dateFormat4Timestamp = new SimpleDateFormat("yyyy-MM-dd");
        Env.setContext((Properties)this.schedulerContext, (String)"#Date", (String)(dateFormat4Timestamp.format(ts) + " 00:00:00"));
        Trx.run(transactionName -> {
            try {
                MProcess process = new MProcess(this.schedulerContext, this.schedulerProcessor.getAD_Process_ID(), transactionName);
                this.summary.append(this.runProcess(process));
            }
            catch (Exception e) {
                this.summary.append(e.toString());
                throw new AdempiereException((Throwable)e);
            }
        });
        int no = this.schedulerProcessor.deleteLog();
        this.summary.append(" Logs deleted=").append(no);
        if (this.schedulerProcessor.get_TrxName() == null) {
            Trx.run(this::addSchedulerLog);
        } else {
            this.addSchedulerLog(this.schedulerProcessor.get_TrxName());
        }
        return TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork));
    }

    private void addSchedulerLog(String trxName) {
        MSchedulerLog schedulerLog = new MSchedulerLog(this.schedulerProcessor, this.summary.toString(), trxName);
        schedulerLog.setReference(TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork)));
        schedulerLog.saveEx();
    }

    private String runProcess(MProcess process) throws Exception {
        this.log.info(process.toString());
        boolean isReport = process.isReport() || process.getAD_ReportView_ID() > 0;
        ProcessBuilder builder = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(process.getAD_Process_ID())).withClientId(Integer.valueOf(this.schedulerProcessor.getAD_Client_ID())).withUserId(Integer.valueOf(this.getRunningUserId())).withTitle(process.getName()).withRecordId(Integer.valueOf(this.schedulerProcessor.getAD_Table_ID()), Integer.valueOf(this.schedulerProcessor.getRecord_ID()));
        this.fillParameter(builder);
        try {
            builder.execute();
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
        }
        ProcessInfo info = builder.getProcessInfo();
        if (info.isError()) {
            int supervisor = this.schedulerProcessor.getSupervisor_ID();
            if (supervisor > 0) {
                ProcessInfoUtil.setLogFromDB((ProcessInfo)info);
                Trx.run(transactionName -> {
                    DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
                    notifier.clearMessage().withApplicationType("UDP").withUserId(this.getRunningUserId()).addRecipient(supervisor).withText(info.getSummary() + " " + info.getLogInfo()).withDescription(process.getName()).withEntity(MPInstance.Table_ID, info.getAD_PInstance_ID());
                    notifier.addToQueue();
                });
            }
        } else {
            Integer[] userIds = this.schedulerProcessor.getRecipientByUserIds();
            StringBuffer errorsSending = new StringBuffer();
            if (userIds.length > 0) {
                ProcessInfoUtil.setLogFromDB((ProcessInfo)info);
                Arrays.asList(userIds).forEach(userId -> {
                    AtomicReference<File> report = new AtomicReference<File>();
                    if (isReport) {
                        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (ProcessInfo)info);
                        if (re != null) {
                            report.set(re.getPDF());
                        } else {
                            if (errorsSending.length() > 0) {
                                errorsSending.append(Env.NL);
                            }
                            errorsSending.append("@Error@ " + process.getAD_Process_ID() + " - " + process.getName());
                        }
                    }
                    Trx.run(transactionName -> {
                        DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
                        notifier.clearMessage().withApplicationType("UDP").withUserId(this.getRunningUserId()).addRecipient(userId.intValue()).addAttachment((File)report.get()).withText(info.getSummary() + " " + info.getLogInfo()).withDescription(process.getName()).withEntity((PO)this.schedulerProcessor);
                        if (isReport) {
                            notifier.withText(this.schedulerProcessor.getDescription()).withDescription(this.schedulerProcessor.getName());
                        }
                        notifier.addToQueue();
                    });
                });
                if (errorsSending.length() > 0) {
                    info.setSummary(Optional.ofNullable(info.getSummary()).orElse("") + Env.NL + errorsSending.toString());
                }
            }
        }
        return info.getSummary();
    }

    private int getRunningUserId() {
        int AD_User_ID = this.schedulerProcessor.getSupervisor_ID() > 0 ? this.schedulerProcessor.getSupervisor_ID() : (this.schedulerProcessor.getCreatedBy() > 0 ? this.schedulerProcessor.getCreatedBy() : (this.schedulerProcessor.getUpdatedBy() > 0 ? this.schedulerProcessor.getUpdatedBy() : 100));
        return AD_User_ID;
    }

    private void fillParameter(ProcessBuilder builder) {
        Arrays.asList(this.schedulerProcessor.getParameters(false)).forEach(schedulerParameter -> {
            String variable = schedulerParameter.getParameterDefault();
            this.log.fine(schedulerParameter.getColumnName() + " = " + variable);
            String value = variable;
            if (variable == null || variable != null && variable.length() == 0) {
                value = null;
            } else if (variable.indexOf(64) != -1 && variable.indexOf(64) != variable.lastIndexOf(64)) {
                int index = variable.indexOf(64);
                String columnName = variable.substring(index + 1);
                if ((index = columnName.indexOf(64)) != -1) {
                    String environment = Env.getContext((Properties)this.schedulerContext, (String)(columnName = columnName.substring(0, index)));
                    if (environment == null || environment.length() == 0) {
                        environment = Env.getContext((Properties)this.getCtx(), (String)columnName);
                    }
                    if (environment.length() == 0) {
                        this.log.warning(schedulerParameter.getColumnName() + " - not in environment =" + columnName + "(" + variable + ")");
                    } else {
                        value = environment;
                    }
                }
            }
            if (value != null) {
                Object parameterOfProcess = null;
                try {
                    if (DisplayType.isNumeric((int)schedulerParameter.getDisplayType()) || DisplayType.isID((int)schedulerParameter.getDisplayType())) {
                        BigDecimal decimalValue = null;
                        decimalValue = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        parameterOfProcess = decimalValue;
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + decimalValue + "=)");
                    } else if (20 == schedulerParameter.getDisplayType()) {
                        boolean booleanValue = false;
                        booleanValue = value instanceof Boolean ? ((Boolean)((Object)value)).booleanValue() : value.toString().replaceAll("'", "").equals("Y");
                        parameterOfProcess = booleanValue;
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + booleanValue + "=)");
                    } else if (DisplayType.isDate((int)schedulerParameter.getDisplayType())) {
                        Timestamp dateValue = null;
                        dateValue = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                        parameterOfProcess = dateValue;
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + dateValue + "=)");
                    } else {
                        parameterOfProcess = value.toString().replaceAll("'", "");
                        this.log.fine(schedulerParameter.getColumnName() + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                    }
                    if (parameterOfProcess != null) {
                        this.log.fine("ColumnName=" + schedulerParameter.getColumnName() + ", Value=" + parameterOfProcess);
                        builder.withParameter(schedulerParameter.getColumnName(), parameterOfProcess);
                    }
                }
                catch (Exception e) {
                    this.log.warning(schedulerParameter.getColumnName() + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                }
            }
        });
    }

    public String getServerInfo() {
        return "Last=" + this.summary.toString();
    }
}

