/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.process;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFProcess;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflowProcessor;
import org.compiere.wf.MWorkflowProcessorLog;
import org.spin.eca46.process.WorkflowProcessorAbstract;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class WorkflowProcessor
extends WorkflowProcessorAbstract {
    private MWorkflowProcessor workflowProcessor = null;
    private StringBuffer summary = new StringBuffer();
    private MClient client = null;
    private long startWork;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getWorkflowProcessorId() <= 0) {
            throw new AdempiereException("@AD_WorkflowProcessor_ID@ @NotFound@");
        }
        this.workflowProcessor = new MWorkflowProcessor(this.getCtx(), this.getWorkflowProcessorId(), this.get_TrxName());
        this.client = MClient.get((Properties)this.getCtx(), (int)this.workflowProcessor.getAD_Client_ID());
    }

    protected String doIt() throws Exception {
        this.startWork = System.currentTimeMillis();
        this.summary = new StringBuffer();
        this.wakeup();
        this.dynamicPriority();
        this.sendAlerts();
        int no = this.workflowProcessor.deleteLog();
        this.summary.append("Logs deleted=").append(no);
        if (this.workflowProcessor.get_TrxName() == null) {
            Trx.run(this::addWorkflowProcessorLog);
        } else {
            this.addWorkflowProcessorLog(this.workflowProcessor.get_TrxName());
        }
        return TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork));
    }

    private void addWorkflowProcessorLog(String trxName) {
        MWorkflowProcessorLog workflowProcessorLog = new MWorkflowProcessorLog(this.workflowProcessor, this.summary.toString(), trxName);
        workflowProcessorLog.setReference(TimeUtil.formatElapsed((Timestamp)new Timestamp(this.startWork)));
        workflowProcessorLog.saveEx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        String sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EndWaitTime > SysDate AND AD_Client_ID=? AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wfn.Action='Z' AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
        CPreparedStatement pstmt = null;
        int count = 0;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.workflowProcessor.getAD_Client_ID());
            pstmt.setInt(2, this.workflowProcessor.getAD_WorkflowProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MWFActivity activity = new MWFActivity(this.getCtx(), rs, null);
                activity.setWFState("CC");
                ++count;
            }
            rs.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "wakeup", (Throwable)e);
        }
        finally {
            DB.close((Statement)pstmt);
        }
        this.summary.append("Wakeup #").append(count).append(" - ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynamicPriority() {
        String sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EXISTS (SELECT * FROM AD_Workflow wf INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wf.AD_WorkflowProcessor_ID=? AND wfn.DynPriorityUnit IS NOT NULL AND wfn.DynPriorityChange IS NOT NULL)";
        CPreparedStatement pstmt = null;
        int count = 0;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.workflowProcessor.getAD_WorkflowProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MWFActivity activity = new MWFActivity(this.getCtx(), rs, null);
                if (activity.getDynPriorityStart() == 0) {
                    activity.setDynPriorityStart(activity.getPriority());
                }
                long ms = System.currentTimeMillis() - activity.getCreated().getTime();
                MWFNode node = activity.getNode();
                int prioDiff = node.calculateDynamicPriority((int)(ms / 1000L));
                activity.setPriority(activity.getDynPriorityStart() + prioDiff);
                activity.saveEx();
                ++count;
            }
            rs.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            DB.close((Statement)pstmt);
        }
        this.summary.append("DynPriority #").append(count).append(" - ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlerts() {
        boolean escalate;
        MWFActivity activity;
        ResultSet rs;
        Object sql;
        if (this.workflowProcessor.getAlertOverPriority() > 0) {
            sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND Priority >= ? AND (DateLastAlert IS NULL";
            if (this.workflowProcessor.getRemindDays() > 0) {
                sql = (String)sql + " OR (DateLastAlert+" + this.workflowProcessor.getRemindDays() + ") < SysDate";
            }
            sql = (String)sql + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
            int count = 0;
            int countEMails = 0;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.workflowProcessor.getAlertOverPriority());
                pstmt.setInt(2, this.workflowProcessor.getAD_WorkflowProcessor_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    activity = new MWFActivity(this.getCtx(), rs, null);
                    escalate = activity.getDateLastAlert() != null;
                    countEMails += this.sendEmail(activity, "ActivityOverPriority", escalate, true);
                    activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                    activity.saveEx();
                    ++count;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "(Priority) - " + (String)sql, (Throwable)e);
            }
            finally {
                DB.close((Statement)pstmt);
            }
            this.summary.append("OverPriority #").append(count);
            if (countEMails > 0) {
                this.summary.append(" (").append(countEMails).append(" EMail)");
            }
            this.summary.append(" - ");
        }
        sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND EndWaitTime > SysDate AND (DateLastAlert IS NULL";
        if (this.workflowProcessor.getRemindDays() > 0) {
            sql = (String)sql + " OR (DateLastAlert+" + this.workflowProcessor.getRemindDays() + ") < SysDate";
        }
        sql = (String)sql + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND wfn.Action<>'Z' AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
        CPreparedStatement pstmt = null;
        int count = 0;
        int countEMails = 0;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.workflowProcessor.getAD_WorkflowProcessor_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                activity = new MWFActivity(this.getCtx(), rs, null);
                escalate = activity.getDateLastAlert() != null;
                countEMails += this.sendEmail(activity, "ActivityEndWaitTime", escalate, false);
                activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                activity.saveEx();
                ++count;
            }
            rs.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "(EndWaitTime) - " + (String)sql, (Throwable)e);
        }
        finally {
            DB.close((Statement)pstmt);
        }
        this.summary.append("EndWaitTime #").append(count);
        if (countEMails > 0) {
            this.summary.append(" (").append(countEMails).append(" EMail)");
        }
        this.summary.append(" - ");
        if (this.workflowProcessor.getInactivityAlertDays() > 0) {
            sql = "SELECT * FROM AD_WF_Activity a WHERE Processed='N' AND WFState='OS' AND (Updated+" + this.workflowProcessor.getInactivityAlertDays() + ") < SysDate AND (DateLastAlert IS NULL";
            if (this.workflowProcessor.getRemindDays() > 0) {
                sql = (String)sql + " OR (DateLastAlert+" + this.workflowProcessor.getRemindDays() + ") < SysDate";
            }
            sql = (String)sql + ") AND EXISTS (SELECT * FROM AD_Workflow wf  INNER JOIN AD_WF_Node wfn ON (wf.AD_Workflow_ID=wfn.AD_Workflow_ID) WHERE a.AD_WF_Node_ID=wfn.AD_WF_Node_ID AND (wf.AD_WorkflowProcessor_ID IS NULL OR wf.AD_WorkflowProcessor_ID=?))";
            count = 0;
            countEMails = 0;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, this.workflowProcessor.getAD_WorkflowProcessor_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    activity = new MWFActivity(this.getCtx(), rs, null);
                    escalate = activity.getDateLastAlert() != null;
                    countEMails += this.sendEmail(activity, "ActivityInactivity", escalate, false);
                    activity.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
                    activity.saveEx();
                    ++count;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "(Inactivity): " + (String)sql, (Throwable)e);
            }
            finally {
                DB.close((Statement)pstmt);
            }
            this.summary.append("Inactivity #").append(count);
            if (countEMails > 0) {
                this.summary.append(" (").append(countEMails).append(" EMail)");
            }
            this.summary.append(" - ");
        }
    }

    private int sendEmail(MWFActivity activity, String AD_Message, boolean toProcess, boolean toSupervisor) {
        if (this.client == null || this.client.getAD_Client_ID() != activity.getAD_Client_ID()) {
            this.client = MClient.get((Properties)this.getCtx(), (int)activity.getAD_Client_ID());
        }
        MWFProcess process = new MWFProcess(this.getCtx(), activity.getAD_WF_Process_ID(), null);
        String subjectVar = activity.getNode().getName();
        AtomicReference<String> message = new AtomicReference<String>(activity.getTextMsg());
        if (message.get() == null || message.get().length() == 0) {
            message.set(process.getTextMsg());
        }
        AtomicReference<File> attachmentAsPDF = new AtomicReference<File>();
        PO po = activity.getPO();
        if (po instanceof DocAction) {
            message.set(((DocAction)po).getDocumentInfo() + "\n" + message.get());
            attachmentAsPDF.set(((DocAction)po).createPDF());
        }
        String subject = Msg.getMsg((String)this.client.getAD_Language(), (String)AD_Message, (Object[])new Object[]{subjectVar});
        ArrayList<Integer> list = new ArrayList<Integer>();
        int counter = 0;
        ++counter;
        list.add(activity.getAD_User_ID());
        if (toProcess && process.getAD_User_ID() != activity.getAD_User_ID()) {
            ++counter;
            list.add(process.getAD_User_ID());
        }
        MWFResponsible responsible = MWFResponsible.get((Properties)this.getCtx(), (int)activity.getAD_WF_Responsible_ID());
        counter += this.sendAlertToResponsible(responsible, list, process, subject, message.get(), (File)attachmentAsPDF.get(), po);
        if (toProcess && process.getAD_WF_Responsible_ID() != activity.getAD_WF_Responsible_ID()) {
            responsible = MWFResponsible.get((Properties)this.getCtx(), (int)process.getAD_WF_Responsible_ID());
            counter += this.sendAlertToResponsible(responsible, list, process, subject, message.get(), (File)attachmentAsPDF.get(), po);
        }
        if (toSupervisor && this.workflowProcessor.getSupervisor_ID() != 0 && !list.contains(this.workflowProcessor.getSupervisor_ID())) {
            ++counter;
            list.add(this.workflowProcessor.getSupervisor_ID());
        }
        Trx.run(transactionName -> {
            DefaultNotifier notifier = this.getDefaultNotifierInstance(transactionName);
            notifier.clearMessage().withApplicationType("UDP").withText(subject).addAttachment((File)attachmentAsPDF.get()).withDescription((String)message.get()).withEntity(po);
            list.forEach(userId -> notifier.addRecipient(userId.intValue()));
            notifier.addToQueue();
        });
        return counter;
    }

    private DefaultNotifier getDefaultNotifierInstance(String transactionName) {
        return (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(transactionName);
    }

    private int sendAlertToResponsible(MWFResponsible responsible, ArrayList<Integer> list, MWFProcess process, String subject, String message, File pdf, PO po) {
        int counter = 0;
        if (!responsible.isInvoker()) {
            if ("H".equals(responsible.getResponsibleType()) && responsible.getAD_User_ID() != 0 && !list.contains(responsible.getAD_User_ID())) {
                ++counter;
                list.add(responsible.getAD_User_ID());
            } else if ("O".equals(responsible.getResponsibleType())) {
                MOrgInfo org;
                PO document = process.getPO();
                if (document != null && (org = MOrgInfo.get((Properties)this.getCtx(), (int)document.getAD_Org_ID(), null)).getSupervisor_ID() != 0 && !list.contains(org.getSupervisor_ID())) {
                    ++counter;
                    list.add(org.getSupervisor_ID());
                }
            } else if ("R".equals(responsible.getResponsibleType()) && responsible.getAD_Role_ID() != 0) {
                MUserRoles[] userRoles = MUserRoles.getOfRole((Properties)this.getCtx(), (int)responsible.getAD_Role_ID());
                for (int i = 0; i < userRoles.length; ++i) {
                    int AD_User_ID;
                    MUserRoles roles = userRoles[i];
                    if (!roles.isActive() || list.contains(AD_User_ID = roles.getAD_User_ID())) continue;
                    ++counter;
                    list.add(AD_User_ID);
                }
            }
        }
        Trx.run(transactionName -> {
            DefaultNotifier notifier = this.getDefaultNotifierInstance(transactionName);
            notifier.clearMessage().withApplicationType("UDP").withText(subject).addAttachment(pdf).withDescription(message).withEntity(po);
            list.forEach(userId -> notifier.addRecipient(userId.intValue()));
            notifier.addToQueue();
        });
        return counter;
    }

    public String getServerInfo() {
        return "Last=" + this.summary.toString();
    }
}

