/*
 * Decompiled with CFR 0.152.
 */
package org.spin.eca46.util.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONObject;
import org.spin.eca46.util.support.IExternalProcessor;
import org.spin.eca46.util.support.IProcessorEntity;
import org.spin.model.MADAppRegistration;

public class DKron
implements IExternalProcessor {
    private String dKronHost = null;
    private String adempiereToken = null;
    private String adempiereHost = null;
    private String adempiereEndpoint = null;
    private int registrationId = 0;
    private final String ADEMPIERE_ENDPOINT = "adempiere_endpoint";

    private void validate() {
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById((Properties)Env.getCtx(), (int)this.getAppRegistrationId(), null);
        this.adempiereEndpoint = registration.getParameterValue("adempiere_endpoint");
        this.dKronHost = registration.getHost();
        if (registration.getPort() > 0) {
            this.dKronHost = this.dKronHost + ":" + registration.getPort();
        }
    }

    public String testConnection() {
        return "Ok";
    }

    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
        this.validate();
    }

    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public String exportProcessor(IProcessorEntity processor) {
        JSONObject jsonValue;
        Entity entity;
        if (Util.isEmpty((String)this.dKronHost)) {
            throw new AdempiereException("@Host@ @NotFound@");
        }
        if (Util.isEmpty((String)this.adempiereHost)) {
            throw new AdempiereException("ADempiere @Host@ @NotFound@");
        }
        if (Util.isEmpty((String)this.adempiereToken)) {
            throw new AdempiereException("@Token@ @NotFound@");
        }
        if (Util.isEmpty((String)this.adempiereEndpoint)) {
            throw new AdempiereException("@Endpoint@ @NotFound@");
        }
        Invocation.Builder invocationBuilder = this.getClient().target(this.dKronHost).path("v1").path("jobs").request(new String[]{"application/json"}).header("Accept", (Object)"application/json");
        Response response = invocationBuilder.post(entity = Entity.json((Object)(jsonValue = new JSONObject(this.getRequestDefinition(processor))).toString()));
        if (response.getStatus() != 201 || response.getStatus() != 200) {
            String output = (String)response.readEntity(String.class);
            return output;
        }
        return null;
    }

    private Map<String, Object> getRequestDefinition(IProcessorEntity processor) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", processor.getIdentifier());
        data.put("displayname", processor.getDisplayName());
        data.put("schedule", this.getSchedule(processor));
        data.put("timezone", processor.getTimeZone());
        data.put("disabled", !processor.isEnabled());
        data.put("retries", 0);
        data.put("concurrency", "forbid");
        data.put("executor", "http");
        HashMap<String, String> executorConfig = new HashMap<String, String>();
        executorConfig.put("method", "POST");
        executorConfig.put("url", this.getAdempiereService());
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add("\"Authorization: Bearer " + this.adempiereToken + "\"");
        headers.add("\"Content-Type: application/json\"");
        executorConfig.put("headers", ((Object)headers).toString());
        HashMap<String, Object> process = new HashMap<String, Object>();
        process.put("\"process_code\"", "\"" + processor.getProcessCode() + "\"");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("\"key\"", "\"" + processor.getProcessorParameterCode() + "\"");
        parameters.put("\"integer_value\"", processor.getProcessorParameterId());
        ArrayList<String> parameterList = new ArrayList<String>();
        parameterList.add(((Object)parameters).toString());
        process.put("\"parameters\"", ((Object)parameterList).toString());
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("\"process\"", ((Object)process).toString());
        executorConfig.put("body", ((Object)body).toString().replaceAll("=", ": "));
        executorConfig.put("timeout", "60000");
        executorConfig.put("expectCode", "200");
        executorConfig.put("expectBody", "");
        executorConfig.put("debug", "false");
        data.put("executor_config", executorConfig);
        return data;
    }

    private String getSchedule(IProcessorEntity processor) {
        Object schedule = null;
        if (processor.getFrequency() <= 0) {
            switch (processor.getFrequencyType()) {
                case "H": {
                    schedule = "@hourly";
                    break;
                }
                case "M": {
                    schedule = "@minutely";
                    break;
                }
                case "S": {
                    schedule = "@every 1s";
                    break;
                }
                case "Y": {
                    schedule = "@yearly";
                    break;
                }
                case "N": {
                    schedule = "@monthly";
                    break;
                }
                case "W": {
                    schedule = "@weekly";
                    break;
                }
                case "D": {
                    schedule = "@daily";
                    break;
                }
                case "B": {
                    schedule = "@every 48h";
                    break;
                }
                case "Q": {
                    schedule = "@every 48h";
                    break;
                }
                default: {
                    schedule = "@every " + processor.getFrequency() + "h";
                    break;
                }
            }
        } else {
            switch (processor.getFrequencyType()) {
                case "H": {
                    schedule = "@every " + processor.getFrequency() + "h";
                    break;
                }
                case "M": {
                    schedule = "@every " + processor.getFrequency() + "m";
                    break;
                }
                case "S": {
                    schedule = "@every " + processor.getFrequency() + "s";
                    break;
                }
                case "Y": {
                    schedule = "@every " + processor.getFrequency() + "h";
                    break;
                }
                case "N": {
                    schedule = "@every " + processor.getFrequency() * 24 * 30 + "h";
                    break;
                }
                case "W": {
                    schedule = "@every " + processor.getFrequency() * 24 * 7 + "h";
                    break;
                }
                case "D": {
                    schedule = "@every " + processor.getFrequency() * 24 + "h";
                    break;
                }
                case "B": {
                    schedule = "@every " + processor.getFrequency() * 24 * 60 + "h";
                    break;
                }
                case "Q": {
                    schedule = "@every " + processor.getFrequency() * 24 * 60 + "h";
                    break;
                }
                default: {
                    schedule = "@every " + processor.getFrequency() + "h";
                }
            }
        }
        return schedule;
    }

    public Client getClient() {
        return (Client)ClientBuilder.newClient((Configuration)new ClientConfig()).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
    }

    @Override
    public void setTokenAccess(String token) {
        this.adempiereToken = token;
    }

    @Override
    public void setHost(String host) {
        this.adempiereHost = host;
    }

    private String getAdempiereService() {
        return this.adempiereHost + this.adempiereEndpoint;
    }
}

