/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.core.domains.models.I_C_Project;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.asset.acct.FactUtil;
import org.compiere.asset.model.MAssetAcct;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AssetAddition
extends Doc {
    public Doc_AssetAddition(MAcctSchema[] as, ResultSet rs, String trxName) {
        super(as, MAssetAddition.class, rs, "GLD", trxName);
    }

    protected String loadDocumentDetails() {
        return null;
    }

    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    public ArrayList<Fact> createFacts(MAcctSchema acctSchema) {
        MAssetAddition assetAddition = this.getAssetAddition();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact((Doc)this, acctSchema, assetAddition.getPostingType());
        facts.add(fact);
        if ("IMP".equals(assetAddition.getA_SourceType()) || "Exp".equals(assetAddition.getA_CapvsExp())) {
            return facts;
        }
        BigDecimal assetValueAmt = assetAddition.getAssetValueAmt();
        FactLine[] fls = FactUtil.createSimpleOperation(fact, null, this.getA_Asset_Acct(), this.getP_Asset_Acct(acctSchema), acctSchema.getC_Currency_ID(), assetValueAmt, false);
        int invoiceBusinessPartnerId = this.getInvoicePartner_ID();
        int invoiceProjectId = this.getInvoiceProject_ID();
        if (invoiceBusinessPartnerId > 0) {
            fls[1].setC_BPartner_ID(invoiceBusinessPartnerId);
        }
        if (invoiceProjectId > 0) {
            fls[1].setC_Project_ID(invoiceProjectId);
        }
        return facts;
    }

    private MAssetAddition getAssetAddition() {
        return (MAssetAddition)this.getPO();
    }

    private MAccount getP_Asset_Acct(MAcctSchema acctSchema) {
        MAssetAddition assetAddition = this.getAssetAddition();
        MAccount account = null;
        if ("PRJ".equals(assetAddition.getA_SourceType())) {
            I_C_Project project = assetAddition.getC_Project();
            return this.getProjectAcct(project, acctSchema);
        }
        if ("MAN".equals(assetAddition.getA_SourceType()) && this.getC_Charge_ID() > 0) {
            account = MCharge.getAccount((int)this.getC_Charge_ID(), (MAcctSchema)acctSchema, null);
            return account;
        }
        if ("INV".equals(assetAddition.getA_SourceType()) && assetAddition.getC_InvoiceLine().getC_Project_ID() > 0) {
            I_C_Project prj = assetAddition.getC_InvoiceLine().getC_Project();
            return this.getProjectAcct(prj, acctSchema);
        }
        account = this.getP_Expense_Acct(assetAddition.getM_Product_ID(), acctSchema);
        return account;
    }

    public MAccount getP_Expense_Acct(int productId, MAcctSchema acctSchema) {
        ProductCost productCost = new ProductCost(this.getCtx(), productId, 0, this.getTrxName());
        return productCost.getAccount(2, acctSchema);
    }

    private MAccount getProjectAcct(I_C_Project project, MAcctSchema acctSchema) {
        String acctName = "PJ_WIP_Acct";
        String sql = "SELECT " + acctName + " FROM C_Project_Acct WHERE C_Project_ID=? AND C_AcctSchema_ID=?";
        int accountId = DB.getSQLValueEx((String)this.getTrxName(), (String)sql, (Object[])new Object[]{project.getC_Project_ID(), acctSchema.get_ID()});
        return MAccount.getValidCombination((Properties)this.getCtx(), (int)accountId, (String)this.getTrxName());
    }

    private MAccount getA_Asset_Acct() {
        MAssetAddition assetAddition = this.getAssetAddition();
        int accountId = MAssetAcct.forA_Asset_ID(this.getCtx(), assetAddition.getA_Asset_ID(), assetAddition.getPostingType(), assetAddition.getDateAcct(), this.getTrxName()).getA_Asset_Acct();
        return MAccount.getValidCombination((Properties)this.getCtx(), (int)accountId, (String)this.getTrxName());
    }

    public int getInvoicePartner_ID() {
        MAssetAddition assetAddition = this.getAssetAddition();
        if ("INV".equals(assetAddition.getA_SourceType()) && assetAddition.getC_Invoice_ID() > 0) {
            return assetAddition.getC_Invoice().getC_BPartner_ID();
        }
        return 0;
    }

    public int getInvoiceProject_ID() {
        MAssetAddition assetAddition = this.getAssetAddition();
        if ("INV".equals(assetAddition.getA_SourceType()) && assetAddition.getC_Invoice_ID() > 0) {
            return assetAddition.getC_InvoiceLine().getC_Project_ID();
        }
        return 0;
    }
}

