/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.asset.acct.FactUtil;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MDepreciationEntry;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.PO;
import org.compiere.util.Env;

public class Doc_DepreciationEntry
extends Doc {
    private String postingType = null;
    private int acctSchemaId = 0;

    public Doc_DepreciationEntry(MAcctSchema[] accountSchemas, ResultSet rs, String trxName) {
        super(accountSchemas, MDepreciationEntry.class, rs, null, trxName);
    }

    protected String loadDocumentDetails() {
        MDepreciationEntry entry = (MDepreciationEntry)this.getPO();
        this.postingType = entry.getPostingType();
        this.acctSchemaId = entry.getC_AcctSchema_ID();
        return null;
    }

    private DocLine createLine(MDepreciationExp depreciationExp) {
        if (!depreciationExp.isProcessed()) {
            return null;
        }
        DocLine docLine = new DocLine((PO)depreciationExp, (Doc)this);
        return docLine;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema acctSchema) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (acctSchema.getC_AcctSchema_ID() != this.acctSchemaId) {
            return facts;
        }
        Fact fact = new Fact((Doc)this, acctSchema, this.postingType);
        MDepreciationEntry entry = (MDepreciationEntry)this.getPO();
        Iterator<MDepreciationExp> it = entry.getLinesIterator(false);
        while (it.hasNext()) {
            FactLine[] factLines;
            MDepreciationExp depreciationExp = it.next();
            MAsset asset = MAsset.get(this.getCtx(), depreciationExp.getA_Asset_ID(), null);
            DocLine docLine = this.createLine(depreciationExp);
            BigDecimal expenseAmt = depreciationExp.getExpense();
            MAccount drAccounting = MAccount.getValidCombination((Properties)this.getCtx(), (int)depreciationExp.getDR_Account_ID(), (String)this.getTrxName());
            MAccount crAccounting = MAccount.getValidCombination((Properties)this.getCtx(), (int)depreciationExp.getCR_Account_ID(), (String)this.getTrxName());
            for (FactLine factLine : factLines = FactUtil.createSimpleOperation(fact, docLine, drAccounting, crAccounting, acctSchema.getC_Currency_ID(), expenseAmt, false)) {
                StringBuilder description = new StringBuilder(factLine.getDescription() != null ? factLine.getDescription() : "");
                description.append(" ").append(asset.getValue()).append(" ").append(asset.getName());
                factLine.setDescription(description.toString());
                factLine.setC_Project_ID(asset.getC_Project_ID());
                factLine.setC_Activity_ID(asset.getC_Activity_ID());
                factLine.setC_BPartner_ID(asset.getC_BPartner_ID());
                factLine.setLocationFromBPartner(asset.getC_BPartner_Location_ID(), true);
            }
        }
        facts.add(fact);
        return facts;
    }
}

