/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.controller;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.I_A_Asset_Addition;
import org.adempiere.model.GridTabWrapper;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.model.MConversionRateUtil;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProject;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CalloutAssetAddition
extends CalloutEngine {
    public String matchInv(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_MatchInv_ID = ((Number)value).intValue();
        if (M_MatchInv_ID > 0) {
            MAssetAddition.setM_MatchInv(SetGetUtil.wrap(gridTab), M_MatchInv_ID);
        }
        return this.amt(ctx, windowNo, gridTab, gridField, value);
    }

    public String project(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        int projectId = 0;
        if (value == null || !(value instanceof Number)) {
            return "";
        }
        projectId = ((Number)value).intValue();
        BigDecimal amt = Env.ZERO;
        if (projectId > 0) {
            MProject project = new MProject(ctx, projectId, null);
            amt = project.getProjectBalanceAmt();
            gridTab.setValue("C_Currency_ID", (Object)project.getC_Currency_ID());
        }
        gridTab.setValue("AssetSourceAmt", (Object)amt);
        return this.amt(ctx, windowNo, gridTab, gridField, value);
    }

    public String amt(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        String columnName = gridField.getColumnName();
        if ("A_Accumulated_Depr".equals(columnName)) {
            gridTab.setValue("A_Accumulated_Depr_F", value);
        } else {
            BigDecimal amtEntered = (BigDecimal)gridTab.getValue("AssetAmtEntered");
            gridTab.setValue("AssetSourceAmt", (Object)amtEntered);
            MConversionRateUtil.convertBase(SetGetUtil.wrap(gridTab), "DateAcct", "AssetSourceAmt", "AssetValueAmt", gridField.getColumnName());
        }
        return "";
    }

    public String dateDoc(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        gridTab.setValue("DateAcct", value);
        return "";
    }

    public String uselife(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        if ("DeltaUseLifeYears".equals(gridField.getColumnName())) {
            gridTab.setValue("DeltaUseLifeYears_F", value);
        }
        return "";
    }

    public String periodOffset(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        I_A_Asset_Addition assetAddition = (I_A_Asset_Addition)GridTabWrapper.create((Object)gridTab, I_A_Asset_Addition.class);
        if (!assetAddition.isA_Accumulated_Depr_Adjust()) {
            return "";
        }
        int periods = TimeUtil.getMonthsBetween((Timestamp)assetAddition.getDateDoc(), (Timestamp)assetAddition.getDateAcct());
        if (periods <= 0) {
            return "";
        }
        int uselifeMonths = assetAddition.getDeltaUseLifeYears() * 12;
        if (uselifeMonths == 0) {
            return "";
        }
        double monthlyExpenseSL = assetAddition.getAssetValueAmt().doubleValue() / (double)uselifeMonths * (double)periods;
        assetAddition.setA_Period_Start(periods + 1);
        assetAddition.setA_Accumulated_Depr(BigDecimal.valueOf(monthlyExpenseSL));
        assetAddition.setA_Accumulated_Depr_F(BigDecimal.valueOf(monthlyExpenseSL));
        return "";
    }
}

