/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Acct;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetGroupAcct;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAssetAcct
extends X_A_Asset_Acct {
    private static final long serialVersionUID = 4779953750434068382L;
    private static CCache<Integer, MAssetAcct> s_cache = new CCache("A_Asset_Acct", 5);
    private static CCache<MultiKey, MAssetAcct> s_cacheAsset = new CCache("A_Asset_Acct_Asset", 5);

    public MAssetAcct(Properties ctx, int X_A_Asset_Acct_ID, String trxName) {
        super(ctx, X_A_Asset_Acct_ID, trxName);
        if (X_A_Asset_Acct_ID == 0) {
            this.setA_Salvage_Value(Env.ZERO);
        }
    }

    public MAssetAcct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MAssetAcct get(Properties ctx, int A_Asset_Acct_ID) {
        MAssetAcct acct = (MAssetAcct)((Object)s_cache.get((Object)A_Asset_Acct_ID));
        if (acct != null) {
            return acct;
        }
        acct = new MAssetAcct(ctx, A_Asset_Acct_ID, null);
        if (acct.get_ID() > 0) {
            MAssetAcct.addToCache(acct, null);
        } else {
            acct = null;
        }
        return acct;
    }

    public static MAssetAcct forA_Asset_ID(Properties ctx, int A_Asset_ID, String postingType, Timestamp dateAcct, String trxName) {
        MultiKey key = new MultiKey((Object)A_Asset_ID, (Object)postingType, (Object)dateAcct);
        MAssetAcct acct = null;
        if (trxName == null) {
            // empty if block
        }
        if (acct != null) {
            return acct;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("A_Asset_ID=? AND PostingType=?");
        params.add(A_Asset_ID);
        params.add(postingType);
        if (dateAcct != null) {
            whereClause.append(" AND ValidFrom").append("<=?");
            params.add(dateAcct);
        }
        acct = (MAssetAcct)new Query(ctx, "A_Asset_Acct", whereClause.toString(), trxName).setParameters(params).setOrderBy("ValidFrom DESC NULLS LAST").first();
        if (trxName == null) {
            MAssetAcct.addToCache(acct, key);
        }
        return acct;
    }

    private static void addToCache(MAssetAcct acct, MultiKey keyAsset) {
        if (acct == null || acct.get_ID() <= 0) {
            return;
        }
        s_cache.put((Object)acct.get_ID(), (Object)acct);
        if (keyAsset != null) {
            s_cacheAsset.put((Object)keyAsset, (Object)acct);
        }
    }

    public MAssetAcct(MAsset asset, MAssetGroupAcct assetgrpacct) {
        this(assetgrpacct.getCtx(), 0, asset.get_TrxName());
        PO.copyValues((PO)assetgrpacct, (PO)this);
        this.setA_Asset_ID(asset.getA_Asset_ID());
        if (asset.getA_Depreciation_ID() > 0) {
            this.setA_Depreciation_ID(asset.getA_Depreciation_ID());
        }
        if (asset.getA_Depreciation_F_ID() > 0) {
            this.setA_Depreciation_F_ID(asset.getA_Depreciation_F_ID());
        }
        this.setA_Period_Start(1);
        this.setA_Period_End(asset.getUseLifeMonths());
        this.dump();
    }

    public BigDecimal getA_Depreciation_Variable_Perc(boolean fiscal) {
        return fiscal ? this.getA_Depreciation_Variable_Perc_F() : this.getA_Depreciation_Variable_Perc();
    }

    public MAcctSchema getC_AcctSchema() {
        return MAcctSchema.get((Properties)this.getCtx(), (int)this.getC_AcctSchema_ID());
    }

    public MAccount getP_Asset_Acct(int M_Product_ID) {
        MAcctSchema as = this.getC_AcctSchema();
        ProductCost pc = new ProductCost(this.getCtx(), M_Product_ID, 0, null);
        return pc.getAccount(3, as);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getValidFrom() == null && newRecord) {
            this.setValidFrom(TimeUtil.getDay((int)1970, (int)1, (int)1));
        }
        return true;
    }
}

