/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_A_Asset_Disposed;
import org.adempiere.core.domains.models.X_A_Asset_Disposed;
import org.adempiere.util.POCacheLocal;
import org.compiere.asset.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.asset.exceptions.AssetNotImplementedException;
import org.compiere.asset.exceptions.AssetNotSupportedException;
import org.compiere.asset.exceptions.AssetStatusChangedException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetChange;
import org.compiere.asset.model.MAssetProduct;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.MClient;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;

public class MAssetDisposed
extends X_A_Asset_Disposed
implements DocAction {
    private static final long serialVersionUID = 1763997880662445638L;
    private final POCacheLocal<MInvoiceLine> m_cacheInvoiceLine = POCacheLocal.newInstance((PO)this, MInvoiceLine.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MAssetDisposed(Properties ctx, int A_Asset_Disposed_ID, String trxName) {
        super(ctx, A_Asset_Disposed_ID, trxName);
        if (A_Asset_Disposed_ID == 0) {
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public static MAssetDisposed createAssetDisposed(MInvoiceLine invLine) {
        MAssetDisposed assetDisposed = new MAssetDisposed(invLine);
        assetDisposed.dump();
        return assetDisposed;
    }

    private MAssetDisposed(MInvoiceLine invLine) {
        this(invLine.getCtx(), 0, invLine.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: Project=" + invLine);
        }
        this.setAD_Org_ID(invLine.getAD_Org_ID());
        this.setPostingType("A");
        this.setDateDoc(invLine.getC_Invoice().getDateInvoiced());
        this.setDateAcct(invLine.getC_Invoice().getDateInvoiced());
        this.setA_Disposed_Date(invLine.getC_Invoice().getDateInvoiced());
        this.setA_Disposed_Method("T1");
        this.setA_Asset_ID(invLine.getA_Asset_ID());
        this.set_ValueNoCheck("C_Invoice_ID", invLine.getC_Invoice_ID());
        this.setM_InvoiceLine(invLine);
        this.saveEx(invLine.get_TrxName());
    }

    public MInvoiceLine getM_InvoiceLine(boolean requery) {
        return (MInvoiceLine)this.m_cacheInvoiceLine.get(requery);
    }

    private void setM_InvoiceLine(MInvoiceLine invLine) {
        this.set_Value("C_InvoiceLine_ID", invLine.get_ID());
        this.m_cacheInvoiceLine.set((PO)invLine);
    }

    public MAssetDisposed(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAsset getAsset() {
        return MAsset.get(this.getCtx(), this.getA_Asset_ID(), null);
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        return false;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"FAD", (int)this.getAD_Org_ID());
        MAssetDisposed.updateFromAsset((I_A_Asset_Disposed)this);
        this.saveEx(this.get_TrxName());
        if (this.is_Changed()) {
            throw new AssetStatusChangedException();
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        this.setDocAction("CO");
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String completeIt() {
        String method;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MAsset asset = this.getAsset();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset=" + asset);
        }
        if (!this.isDisposal()) {
            method = this.getA_Activation_Method();
            if (!method.equals("AA")) throw new AssetNotSupportedException("A_Activation_Method", method);
            asset.changeStatus("AC", this.getDateDoc());
        } else {
            method = this.getA_Disposed_Method();
            if ("PR".equals(method)) {
                asset.changeStatus("PR", this.getDateDoc());
            } else if ("S_".equals(method) || "T1".equals(method)) {
                asset.changeStatus("DI", null);
                this.setA_Disposal_Amt(this.getA_Asset_Cost());
                this.setA_Accumulated_Depr_Delta(this.getA_Accumulated_Depr());
                this.setExpense(this.getA_Disposal_Amt().subtract(this.getA_Accumulated_Depr_Delta()));
                this.createDisposal();
            } else {
                if (!"PD".equals(method)) throw new AssetNotSupportedException("A_Disposed_Method", method);
                this.createDisposal();
            }
        }
        MAssetProduct assetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), asset.getM_Product_ID(), asset.getM_AttributeSetInstance_ID(), this.get_TrxName());
        assetProduct.setA_QTY_Current(Env.ZERO);
        assetProduct.setAD_Org_ID(asset.getAD_Org_ID());
        assetProduct.saveEx();
        assetProduct.updateAsset(asset);
        asset.setA_QTY_Current(Env.ZERO);
        asset.setQty(Env.ZERO);
        asset.saveEx(this.get_TrxName());
        valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        throw new AssetNotImplementedException("");
    }

    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("");
    }

    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("");
    }

    public boolean reActivateIt() {
        throw new AssetNotImplementedException("");
    }

    public String getSummary() {
        return new StringBuffer().append(this.getDocumentNo()).append("/").append(this.getDateDoc()).toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID()).getAcctSchema().getC_Currency_ID();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        if (newRecord || this.is_ValueChanged("DateAcct")) {
            this.setC_Period_ID(MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID()).get_ID());
        }
        if (this.getA_Disposed_Date() == null) {
            this.setA_Disposed_Date(this.getDateAcct());
        }
        return true;
    }

    public static void updateFromAsset(I_A_Asset_Disposed bean) {
        int asset_id = bean.getA_Asset_ID();
        SetGetUtil.copyValues(SetGetUtil.wrap(bean), "A_Asset", asset_id, new String[]{"IsDisposed", "A_Asset_Status", "AD_Org_ID"});
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(Env.getCtx(), asset_id, bean.getPostingType(), null);
        if (wk != null) {
            bean.setA_Asset_Cost(wk.getA_Asset_Cost());
            bean.setA_Accumulated_Depr(wk.getA_Accumulated_Depr());
        } else {
            bean.setA_Asset_Cost(Env.ZERO);
            bean.setA_Accumulated_Depr(Env.ZERO);
        }
    }

    public File createPDF() {
        return null;
    }

    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public boolean isDisposal() {
        return !this.isDisposed();
    }

    public static void setA_Disposal_Amt(I_A_Asset_Disposed bean) {
        int precision = 2;
        BigDecimal A_Asset_Cost = bean.getA_Asset_Cost();
        BigDecimal A_Disposal_Amt = bean.getA_Disposal_Amt();
        BigDecimal coef = Env.ZERO;
        if (A_Asset_Cost.signum() != 0) {
            coef = A_Disposal_Amt.divide(A_Asset_Cost, 12, RoundingMode.HALF_UP);
        }
        BigDecimal A_Accumulated_Depr = bean.getA_Accumulated_Depr();
        BigDecimal A_Accumulated_Depr_Delta = A_Accumulated_Depr.multiply(coef).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal Expense = A_Disposal_Amt.subtract(A_Accumulated_Depr_Delta);
        bean.setA_Accumulated_Depr_Delta(A_Accumulated_Depr_Delta);
        bean.setExpense(Expense);
    }

    private void createDisposal() {
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        assetwk.adjustCost(this.getA_Disposal_Amt().negate(), assetwk.getA_QTY_Current().negate(), false);
        assetwk.adjustAccumulatedDepr(this.getA_Accumulated_Depr_Delta().negate(), this.getA_Accumulated_Depr_Delta().negate(), false);
        assetwk.saveEx();
        assetwk.buildDepreciation();
        List<MDepreciationExp> list = MDepreciationExp.getNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        for (MDepreciationExp ex : list) {
            ex.deleteEx(false);
        }
        MAssetChange.createDisposal(this, assetwk);
    }
}

