/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Product;
import org.compiere.asset.model.MAsset;
import org.compiere.model.Query;

public class MAssetProduct
extends X_A_Asset_Product {
    private static final long serialVersionUID = 1L;

    public static Optional<MAssetProduct> getAssetProduct(MAsset asset) {
        return Optional.ofNullable((MAssetProduct)new Query(asset.getCtx(), "A_Asset_Product", "A_Asset_ID=?", asset.get_TrxName()).setClient_ID().setParameters(new Object[]{asset.getA_Asset_ID()}).first());
    }

    public MAssetProduct(Properties ctx, int A_Asset_Product_ID, String trxName) {
        super(ctx, A_Asset_Product_ID, trxName);
    }

    public MAssetProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setProduct(int M_Product_ID, int M_ASI_ID) {
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_ASI_ID);
    }

    public static MAssetProduct getCreate(Properties ctx, int A_Asset_ID, int M_Product_ID, int M_ASI_ID, String trxName) {
        if (M_Product_ID <= 0) {
            return null;
        }
        String whereClause = "A_Asset_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?";
        MAssetProduct ap = (MAssetProduct)new Query(ctx, "A_Asset_Product", "A_Asset_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", trxName).setParameters(new Object[]{A_Asset_ID, M_Product_ID, M_ASI_ID}).firstOnly();
        if (ap != null) {
            return ap;
        }
        ap = new MAssetProduct(ctx, 0, trxName);
        ap.setA_Asset_ID(A_Asset_ID);
        ap.setProduct(M_Product_ID, M_ASI_ID);
        return ap;
    }

    public void addA_Qty_Current(BigDecimal qty) {
        this.setA_QTY_Current(this.getA_QTY_Current().add(qty));
    }

    public void updateAsset(MAsset asset) {
        asset.setM_Product_ID(this.getM_Product_ID());
        asset.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
    }
}

