/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Split;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetChange;
import org.compiere.asset.model.MAssetProduct;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;

public class MAssetSplit
extends X_A_Asset_Split
implements DocAction {
    private static final long serialVersionUID = 20180418L;
    private String processMsg = null;
    private boolean justPrepared = false;
    Optional<MDepreciationWorkfile> optionalDepreciationWorkfile = Optional.empty();
    Optional<MAsset> optionalFixedAssetToBeSplit = Optional.empty();

    public MAssetSplit(Properties ctx, int A_Asset_Split_ID, String trxName) {
        super(ctx, A_Asset_Split_ID, trxName);
    }

    public MAssetSplit(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            this.getAssetBalance().ifPresent(assetBalance -> {
                this.setA_Depreciation_Workfile_ID(assetBalance.getA_Depreciation_Workfile_ID());
                this.setA_Asset_Cost(assetBalance.getA_Asset_Cost());
                this.setA_Percent_Original(BigDecimal.valueOf(100L));
                this.setA_QTY_Current(assetBalance.getA_QTY_Current());
                if (this.getA_QTY_Split().signum() <= 0) {
                    this.setA_QTY_Split(assetBalance.getA_QTY_Current());
                }
            });
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    protected boolean beforeDelete() {
        return true;
    }

    public String getDocumentInfo() {
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return docType.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)docType.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.processMsg = "@PeriodClosed@";
            return "IN";
        }
        MDepreciationWorkfile assetBalance = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetBalance.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.createSplit();
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType docType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (docType.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (docType.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MAssetSplit[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    private List<MAsset> createSplit() {
        ArrayList<MAsset> assetsSplit = new ArrayList<MAsset>();
        if (!this.isProcessed()) {
            this.getAssetBalance().ifPresent(assetBalance -> {
                MAsset fixedAssetToBeSplit = this.getAssetToBeSplit();
                BigDecimal acquisitionCost = BigDecimal.ZERO;
                BigDecimal accumulatedCost = BigDecimal.ZERO;
                BigDecimal remainingCost = BigDecimal.ZERO;
                if ("QTY".equals(this.getA_Split_Type())) {
                    if (this.getA_QTY_Split().signum() <= 0) {
                        throw new AdempiereException("@A_QTY_Split@ @NotFound@");
                    }
                    acquisitionCost = assetBalance.getA_Asset_Cost().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                    accumulatedCost = assetBalance.getA_Accumulated_Depr().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                    remainingCost = assetBalance.getA_Asset_Remaining().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                    for (int sequence = 1; sequence < this.getA_QTY_Split().intValue() + 1; ++sequence) {
                        MAsset fixedAssetSplit = this.createAssetSplit(fixedAssetToBeSplit, (MDepreciationWorkfile)assetBalance, acquisitionCost, accumulatedCost, remainingCost, sequence);
                        assetsSplit.add(fixedAssetSplit);
                    }
                }
                if ("AMT".equals(this.getA_Split_Type())) {
                    BigDecimal percentage = this.getA_Amount_Split().divide(this.getA_Asset_Cost(), 7, RoundingMode.HALF_UP);
                    acquisitionCost = assetBalance.getA_Asset_Cost().subtract(this.getA_Amount_Split());
                    accumulatedCost = assetBalance.getA_Accumulated_Depr().multiply(percentage);
                    remainingCost = assetBalance.getA_Asset_Remaining().multiply(percentage);
                    MAsset fixedAssetSplitFirst = this.createAssetSplit(fixedAssetToBeSplit, (MDepreciationWorkfile)assetBalance, assetBalance.getActualCost().subtract(acquisitionCost), assetBalance.getA_Accumulated_Depr().subtract(accumulatedCost), assetBalance.getA_Asset_Remaining().subtract(remainingCost), 1);
                    assetsSplit.add(fixedAssetSplitFirst);
                    MAsset assetSplitSecond = this.createAssetSplit(fixedAssetToBeSplit, (MDepreciationWorkfile)assetBalance, acquisitionCost, accumulatedCost, remainingCost, 2);
                    assetsSplit.add(assetSplitSecond);
                }
                if ("PER".equals(this.getA_Split_Type())) {
                    BigDecimal percentage = this.getA_Percent_Split().divide(BigDecimal.valueOf(100L));
                    acquisitionCost = assetBalance.getA_Asset_Cost().multiply(percentage);
                    accumulatedCost = assetBalance.getA_Accumulated_Depr().multiply(percentage);
                    remainingCost = assetBalance.getA_Asset_Remaining().multiply(percentage);
                    MAsset assetSplitFirst = this.createAssetSplit(fixedAssetToBeSplit, (MDepreciationWorkfile)assetBalance, assetBalance.getActualCost().subtract(acquisitionCost), assetBalance.getA_Accumulated_Depr().subtract(accumulatedCost), assetBalance.getA_Asset_Remaining().subtract(remainingCost), 1);
                    assetsSplit.add(assetSplitFirst);
                    MAsset fixedAssetSplitSecond = this.createAssetSplit(fixedAssetToBeSplit, (MDepreciationWorkfile)assetBalance, acquisitionCost, accumulatedCost, remainingCost, 2);
                    assetsSplit.add(fixedAssetSplitSecond);
                }
                this.split(fixedAssetToBeSplit);
            });
        }
        if (assetsSplit.size() == 0) {
            throw new AdempiereException("@A_Asset_Split_ID@ @ProcessRunError@");
        }
        return assetsSplit;
    }

    private void split(MAsset asset) {
        asset.changeStatus("PR", this.getDateDoc());
        MAssetProduct assetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), asset.getM_Product_ID(), asset.getM_AttributeSetInstance_ID(), this.get_TrxName());
        assetProduct.setA_QTY_Current(BigDecimal.ZERO);
        assetProduct.setAD_Org_ID(asset.getAD_Org_ID());
        assetProduct.saveEx();
        assetProduct.updateAsset(asset);
        asset.setA_QTY_Current(BigDecimal.ZERO);
        asset.setQty(BigDecimal.ZERO);
        asset.saveEx();
        MDepreciationWorkfile assetBalance = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        assetBalance.setA_Asset_Cost(BigDecimal.ZERO);
        assetBalance.setA_Salvage_Value(BigDecimal.ZERO);
        assetBalance.setA_Accumulated_Depr(BigDecimal.ZERO);
        assetBalance.setA_Asset_Remaining(BigDecimal.ZERO);
        assetBalance.setA_Accumulated_Depr_F(BigDecimal.ZERO);
        assetBalance.setA_Asset_Remaining_F(BigDecimal.ZERO);
        assetBalance.setIsDepreciated(false);
        assetBalance.saveEx();
        MDepreciationExp.getNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName()).forEach(depreciation -> depreciation.deleteEx(false));
        MAssetChange.createSplit(this, assetBalance);
    }

    private MAsset createAssetSplit(MAsset assetSource, MDepreciationWorkfile assetBalanceSource, BigDecimal acquisitionCost, BigDecimal accumulatedCost, BigDecimal remainingCost, Integer sequence) {
        Object sufixValue = null;
        if (sequence < 10) {
            sufixValue = "00" + sequence.toString();
        } else if (sequence < 100) {
            sufixValue = "0" + sequence.toString();
        } else if (sequence < 1000) {
            sufixValue = sequence.toString();
        }
        MAsset assetTarget = new MAsset(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues((PO)assetSource, (PO)assetTarget);
        assetTarget.setValue(assetSource.getValue() + (String)sufixValue);
        assetTarget.setName(assetSource.getName() + "-" + assetSource.getInventoryNo());
        assetTarget.setInventoryNo(assetSource.getInventoryNo() + (String)sufixValue);
        assetTarget.setA_Asset_Split_ID(this.getA_Asset_Split_ID());
        assetTarget.setA_Parent_Asset_ID(assetSource.getA_Asset_ID());
        assetTarget.setA_Asset_Status(assetSource.getA_Asset_Status());
        assetTarget.saveEx();
        MAssetProduct.getAssetProduct(assetSource).ifPresent(assetProductSource -> {
            MAssetProduct assetProductTarget = new MAssetProduct(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)assetProductSource, (PO)assetProductTarget);
            assetProductSource.setA_Asset_ID(assetTarget.getA_Asset_ID());
            assetProductSource.setA_QTY_Current(BigDecimal.ONE);
            assetProductSource.saveEx();
        });
        MDepreciationWorkfile assetBalanceTarget = Optional.ofNullable(MDepreciationWorkfile.get(this.getCtx(), assetTarget.getA_Asset_ID(), this.getPostingType(), assetTarget.get_TrxName())).orElseGet(() -> new MDepreciationWorkfile(this.getCtx(), 0, this.get_TrxName()));
        PO.copyValues((PO)assetBalanceSource, (PO)assetBalanceTarget);
        assetBalanceTarget.setA_Asset_ID(assetTarget.getA_Asset_ID());
        assetBalanceTarget.setA_Asset_Cost(acquisitionCost);
        assetBalanceTarget.setA_Accumulated_Depr(accumulatedCost);
        assetBalanceTarget.setA_Accumulated_Depr_F(accumulatedCost);
        assetBalanceTarget.setA_Asset_Remaining(remainingCost);
        assetBalanceTarget.setA_Asset_Remaining_F(remainingCost);
        assetBalanceTarget.saveEx();
        this.createDepreciation(assetTarget, acquisitionCost);
        MAssetChange.createAddition(this, assetSource, assetTarget, assetBalanceTarget);
        return assetTarget;
    }

    private void createDepreciation(MAsset asset, BigDecimal acquisitionCost) {
        List<MDepreciationExp> depreciationList = MDepreciationExp.getEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        depreciationList.stream().filter(depreciation -> !depreciation.isProcessed()).forEach(depreciation -> {
            BigDecimal percentage;
            BigDecimal proportion;
            MDepreciationExp depreciationTarge = new MDepreciationExp(this.getCtx(), 0, this.get_TrxName());
            BigDecimal accumulated = BigDecimal.ZERO;
            BigDecimal accumulatedDelta = BigDecimal.ZERO;
            BigDecimal remaining = BigDecimal.ZERO;
            BigDecimal expense = BigDecimal.ZERO;
            BigDecimal accumulatedFiscal = BigDecimal.ZERO;
            BigDecimal accumulatedDeltaFiscal = BigDecimal.ZERO;
            BigDecimal remainingFiscal = BigDecimal.ZERO;
            BigDecimal expenseFiscal = BigDecimal.ZERO;
            if ("QTY".equals(this.getA_Split_Type())) {
                accumulated = depreciation.getA_Accumulated_Depr().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                accumulatedDelta = depreciation.getA_Accumulated_Depr_Delta().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                remaining = depreciation.getA_Asset_Remaining().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                expense = depreciation.getExpense().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                accumulatedFiscal = depreciation.getA_Accumulated_Depr_F().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                accumulatedDeltaFiscal = depreciation.getA_Accumulated_Depr_F_Delta().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                remainingFiscal = depreciation.getA_Asset_Remaining_F().divide(this.getA_QTY_Split(), 7, RoundingMode.HALF_UP);
                expenseFiscal = depreciation.getExpense_F().divide(this.getA_QTY_Split());
            }
            if ("AMT".equals(this.getA_Split_Type())) {
                proportion = acquisitionCost.divide(depreciation.getA_Asset_Cost(), 7, RoundingMode.HALF_UP);
                percentage = this.getA_Amount_Split().divide(this.getA_Asset_Cost());
                accumulated = depreciation.getA_Accumulated_Depr().multiply(proportion).multiply(percentage);
                accumulatedDelta = depreciation.getA_Accumulated_Depr_Delta().multiply(proportion).multiply(percentage);
                remaining = depreciation.getA_Asset_Remaining().multiply(proportion).multiply(percentage);
                expense = depreciation.getExpense().multiply(proportion).multiply(percentage);
                accumulatedFiscal = depreciation.getA_Accumulated_Depr_F().multiply(proportion).multiply(percentage);
                accumulatedDeltaFiscal = depreciation.getA_Accumulated_Depr_F_Delta().multiply(proportion).multiply(percentage);
                remainingFiscal = depreciation.getA_Asset_Remaining_F().multiply(proportion).multiply(percentage);
                expenseFiscal = depreciation.getExpense_F().multiply(proportion).multiply(percentage);
            }
            if ("PER".equals(this.getA_Split_Type())) {
                proportion = acquisitionCost.divide(depreciation.getA_Asset_Cost(), 7, RoundingMode.HALF_UP);
                percentage = this.getA_Percent_Split().divide(BigDecimal.valueOf(100L));
                accumulated = depreciation.getA_Accumulated_Depr().multiply(proportion).multiply(percentage);
                accumulatedDelta = depreciation.getA_Accumulated_Depr_Delta().multiply(proportion).multiply(percentage);
                remaining = depreciation.getA_Asset_Remaining().multiply(proportion).multiply(percentage);
                expense = depreciation.getExpense().multiply(proportion).multiply(percentage);
                accumulatedFiscal = depreciation.getA_Accumulated_Depr_F().multiply(proportion).multiply(percentage);
                accumulatedDeltaFiscal = depreciation.getA_Accumulated_Depr_F_Delta().multiply(proportion).multiply(percentage);
                remainingFiscal = depreciation.getA_Asset_Remaining_F().multiply(proportion).multiply(percentage);
                expenseFiscal = depreciation.getExpense_F().multiply(proportion).multiply(percentage);
            }
            PO.copyValues((PO)depreciation, (PO)depreciationTarge);
            String help = accumulated.subtract(expense) + "|" + accumulatedFiscal.subtract(expenseFiscal) + " + " + expense + "|" + expenseFiscal + " = " + accumulated + "|" + accumulatedFiscal;
            depreciationTarge.setHelp(help);
            depreciationTarge.setA_Asset_ID(asset.getA_Asset_ID());
            depreciationTarge.setA_Asset_Cost(acquisitionCost);
            depreciationTarge.setA_Accumulated_Depr(accumulated);
            depreciationTarge.setA_Accumulated_Depr_Delta(accumulatedDelta);
            depreciationTarge.setA_Asset_Remaining(remaining);
            depreciationTarge.setExpense(expense);
            depreciationTarge.setA_Accumulated_Depr_F(accumulatedFiscal);
            depreciationTarge.setA_Accumulated_Depr_F_Delta(accumulatedDeltaFiscal);
            depreciationTarge.setA_Asset_Remaining_F(remainingFiscal);
            depreciationTarge.setExpense_F(expenseFiscal);
            depreciationTarge.saveEx();
        });
    }

    private MAsset getAssetToBeSplit() {
        if (!this.optionalFixedAssetToBeSplit.isPresent()) {
            this.optionalFixedAssetToBeSplit = Optional.ofNullable(new MAsset(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName()));
        }
        return this.optionalFixedAssetToBeSplit.orElseThrow(() -> new AdempiereException("@A_Asset_ID@ @NotFound@"));
    }

    public Optional<MDepreciationWorkfile> getAssetBalance() {
        if (!this.optionalDepreciationWorkfile.isPresent()) {
            this.optionalDepreciationWorkfile = Optional.ofNullable(MDepreciationWorkfile.get(this.getCtx(), this.getAssetToBeSplit().getA_Asset_ID(), this.getPostingType(), this.get_TrxName()));
        }
        return this.optionalDepreciationWorkfile;
    }

    public List<MAsset> getAssetsSplit() {
        return new Query(this.getCtx(), "A_Asset", "A_Asset_Split_ID=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getA_Asset_Split_ID()}).list(MAsset.class);
    }
}

