/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_A_Depreciation_Entry;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.exceptions.AssetArrayException;
import org.compiere.asset.exceptions.AssetException;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class MDepreciationEntry
extends X_A_Depreciation_Entry
implements DocAction {
    private static final long serialVersionUID = 1L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MDepreciationEntry(Properties ctx, int A_Depreciation_Entry_ID, String trxName) {
        super(ctx, A_Depreciation_Entry_ID, trxName);
        if (A_Depreciation_Entry_ID == 0) {
            MAcctSchema acctSchema = MClient.get((Properties)this.getCtx()).getAcctSchema();
            this.setC_AcctSchema_ID(acctSchema.get_ID());
            this.setC_Currency_ID(acctSchema.getC_Currency_ID());
            this.setA_Entry_Type("DEP");
            this.setPostingType("A");
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
        }
    }

    public MDepreciationEntry(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setC_Period_ID();
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if (!this.isProcessed() && (newRecord || this.is_ValueChanged("DateAcct"))) {
            this.selectLines();
        }
        return true;
    }

    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        this.unselectLines();
        return true;
    }

    public void setC_Period_ID() {
        MPeriod period = MPeriod.get((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getAD_Org_ID());
        if (period == null) {
            throw new AdempiereException("@NotFound@ @C_Period_ID@");
        }
        this.setC_Period_ID(period.get_ID());
    }

    private void unselectLines() {
        String sql = "UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=NULL  WHERE A_Depreciation_Entry_ID=?";
        int id = this.get_ID();
        if (id <= 0) {
            id = this.get_IDOld();
        }
        int no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{id}, (String)this.get_TrxName());
        this.log.fine("Updated #" + no);
    }

    private void selectLines() {
        this.unselectLines();
        String sql = "UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=? WHERE A_Depreciation_Entry_ID IS NULL AND TRUNC(DateAcct,'MONTH') = ? AND AD_Client_ID=? AND AD_Org_ID=?";
        Timestamp dateAcct = TimeUtil.trunc((Timestamp)this.getDateAcct(), (String)"MM");
        int no = DB.executeUpdateEx((String)"UPDATE A_Depreciation_Exp SET A_Depreciation_Entry_ID=? WHERE A_Depreciation_Entry_ID IS NULL AND TRUNC(DateAcct,'MONTH') = ? AND AD_Client_ID=? AND AD_Org_ID=?", (Object[])new Object[]{this.get_ID(), dateAcct, this.getAD_Client_ID(), this.getAD_Org_ID()}, (String)this.get_TrxName());
        this.log.fine("Updated #" + no);
    }

    public Iterator<MDepreciationExp> getLinesIterator(boolean onlyNotProcessed) {
        String trxName = this.get_TrxName();
        ArrayList<Constable> params = new ArrayList<Constable>();
        Object whereClause = "A_Depreciation_Entry_ID=?";
        params.add(Integer.valueOf(this.get_ID()));
        if (onlyNotProcessed) {
            whereClause = (String)whereClause + " AND Processed=?";
            params.add(Boolean.valueOf(false));
        }
        String orderBy = "A_Asset_ID,PostingType,A_Period,A_Entry_Type";
        Iterator it = new Query(this.getCtx(), "A_Depreciation_Exp", (String)whereClause, trxName).setOrderBy(orderBy).setParameters(params).iterate();
        return it;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        return false;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (int)this.getC_DocType_ID(), (int)this.getAD_Org_ID());
        this.m_justPrepared = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setDocAction("CO");
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        final MPeriod period = MPeriod.get((Properties)this.getCtx(), (int)this.getC_Period_ID());
        ArrayList<Exception> errors = new ArrayList<Exception>();
        final Iterator<MDepreciationExp> it = this.getLinesIterator(true);
        while (it.hasNext()) {
            try {
                Trx.run((String)this.get_TrxName(), (TrxRunnable)new TrxRunnable(){

                    public void run(String trxName) {
                        MDepreciationExp depexp = (MDepreciationExp)((Object)it.next());
                        if (!period.isInPeriod(depexp.getDateAcct())) {
                            throw new AssetException("The date is not within this Period (" + depexp + ", Data=" + depexp.getDateAcct() + ", Period=" + period.getName() + ")");
                        }
                        depexp.process();
                    }
                });
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                errors.add(e);
            }
        }
        if (errors.size() > 0) {
            throw new AssetArrayException(errors);
        }
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        return false;
    }

    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        return false;
    }

    public boolean reverseAccrualIt() {
        return false;
    }

    public boolean reActivateIt() {
        return false;
    }

    public String getSummary() {
        return this.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public File createPDF() {
        return null;
    }

    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public static void deleteFacts(MDepreciationExp depexp) {
        String sql = "DELETE FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?";
        Object[] params = new Object[]{Table_ID, depexp.getA_Depreciation_Entry_ID(), depexp.get_ID()};
        DB.executeUpdateEx((String)"DELETE FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?", (Object[])params, (String)depexp.get_TrxName());
    }
}

