/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetDelivery;
import org.compiere.asset.process.AssetDeliveryAbstract;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MProductDownload;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class AssetDelivery
extends AssetDeliveryAbstract {
    private MClient client = null;
    private MMailText mailTemplate = null;
    private AtomicInteger count;
    private AtomicInteger errors;
    private AtomicInteger reminders;
    private AtomicInteger delivered;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getGuaranteeDate() == null) {
            this.setGuaranteeDate(new Timestamp(System.currentTimeMillis()));
        }
        this.client = MClient.get((Properties)this.getCtx());
        this.count = new AtomicInteger();
        this.errors = new AtomicInteger();
        this.reminders = new AtomicInteger();
        this.delivered = new AtomicInteger();
    }

    protected String doIt() throws Exception {
        this.log.info("");
        long start = System.currentTimeMillis();
        if (!this.isSelection()) {
            StringBuffer whereClause = new StringBuffer();
            ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
            if (this.getAssetId() != 0) {
                whereClause.append("A_Asset_ID = ?");
                parameters.add(Integer.valueOf(this.getAssetId()));
            }
            if (this.getAssetGroupId() != 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("A_Asset_Group_ID = ?");
                parameters.add(Integer.valueOf(this.getAssetGroupId()));
            }
            if (this.getProductId() != 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("M_Product_ID = ?");
                parameters.add(Integer.valueOf(this.getProductId()));
            }
            if (parameters.size() == 0) {
                throw new AdempiereException("@RestrictSelection@");
            }
            if (this.getMailTextId() == 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("GuaranteeDate >= ?");
                parameters.add(this.getGuaranteeDate());
            }
            new Query(this.getCtx(), "A_Asset", whereClause.toString(), this.get_TrxName()).setParameters(parameters).setOrderBy("Value").list().forEach(asset -> this.deliverAsset((MAsset)((Object)asset)));
        } else {
            this.getInstancesForSelection(this.get_TrxName()).forEach(asset -> this.deliverAsset((MAsset)((Object)asset)));
        }
        this.log.info("Count=" + this.count + ", Errors=" + this.errors + ", Reminder=" + this.reminders + " - " + (System.currentTimeMillis() - start) + "ms");
        return "@IsDelivered@=" + this.delivered + " - @Sent@=" + this.count + " - @Errors@=" + this.errors;
    }

    private void deliverAsset(MAsset asset) {
        if (this.getBPartnerId() != 0) {
            int businessPartnerId = -1;
            int userId = -1;
            boolean isReturned = this.getParameterAsBoolean("IsReturnedToOrganization");
            if (!isReturned) {
                businessPartnerId = this.getBPartnerId();
                userId = this.getUserId();
            }
            asset.setIsInPosession(isReturned);
            asset.setC_BPartner_ID(businessPartnerId);
            asset.setAD_User_ID(userId);
            asset.saveEx();
            MAssetDelivery assetDelivery = new MAssetDelivery(asset, this.getBPartnerId(), 0, this.getParameterAsTimestamp("MovementDate"));
            String description = this.getParameterAsString("Description");
            if (!Util.isEmpty((String)description)) {
                assetDelivery.setDescription(description);
            }
            assetDelivery.saveEx();
            this.delivered.getAndIncrement();
        }
        if (this.isSendEMail()) {
            this.notifyAsset(asset);
        }
    }

    private void notifyAsset(MAsset asset) {
        if (asset.getGuaranteeDate() != null && asset.getGuaranteeDate().before(this.getGuaranteeDate())) {
            if (this.getMailTextId() != 0) {
                this.sendNoGuaranteeMail(asset);
                this.reminders.getAndIncrement();
            }
        } else {
            String msg = this.sendDeliveryeMail(asset);
            this.addLog(asset.getA_Asset_ID(), null, null, msg);
            if (msg.startsWith("** ")) {
                this.errors.getAndIncrement();
            } else {
                this.count.getAndIncrement();
            }
        }
    }

    private String sendNoGuaranteeMail(MAsset asset) {
        if (asset.getAD_User_ID() == 0) {
            return Msg.parseTranslation((Properties)this.getCtx(), (String)"@A_Asset_ID@ @AD_User_ID@ @NotFound@");
        }
        MUser user = new MUser(this.getCtx(), asset.getAD_User_ID(), this.get_TrxName());
        if (this.mailTemplate == null || this.mailTemplate.getR_MailText_ID() != this.getMailTextId()) {
            this.mailTemplate = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        }
        if (Util.isEmpty((String)this.mailTemplate.getMailHeader())) {
            return Msg.parseTranslation((Properties)this.getCtx(), (String)"@Subject@ @NotFound@");
        }
        this.mailTemplate.setPO((PO)user);
        this.mailTemplate.setPO((PO)asset);
        String message = this.mailTemplate.getMailText(true);
        DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
        notifier.clearMessage().withApplicationType("UDP").withUserId(this.getAD_User_ID()).addRecipient(user.getAD_User_ID()).withText(message).withDescription(this.mailTemplate.getMailHeader()).withEntity(MAsset.Table_ID, asset.getA_Asset_ID());
        notifier.addToQueue();
        return user.getEMail();
    }

    private String sendDeliveryeMail(MAsset asset) {
        this.log.fine("A_Asset_ID=" + asset.getA_Asset_ID());
        long start = System.currentTimeMillis();
        if (asset.getAD_User_ID() == 0) {
            return Msg.parseTranslation((Properties)this.getCtx(), (String)"@A_Asset_ID@ @AD_User_ID@ @NotFound@");
        }
        MUser user = new MUser(this.getCtx(), asset.getAD_User_ID(), this.get_TrxName());
        if (asset.getProductR_MailText_ID() == 0) {
            return Msg.parseTranslation((Properties)this.getCtx(), (String)"@ProductR_MailText_ID@ @NotFound@");
        }
        if (this.mailTemplate == null || this.mailTemplate.getR_MailText_ID() != asset.getProductR_MailText_ID()) {
            this.mailTemplate = new MMailText(this.getCtx(), asset.getProductR_MailText_ID(), this.get_TrxName());
        }
        if (this.mailTemplate.getMailHeader() == null || this.mailTemplate.getMailHeader().length() == 0) {
            return Msg.parseTranslation((Properties)this.getCtx(), (String)"@Subject@ @NotFound@");
        }
        this.mailTemplate.setUser(user);
        this.mailTemplate.setPO((PO)asset);
        String message = this.mailTemplate.getMailText(true);
        DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
        notifier.clearMessage().withApplicationType("UDP").withUserId(this.getAD_User_ID()).addRecipient(user.getAD_User_ID()).withText(message).withDescription(this.mailTemplate.getMailHeader()).withEntity(MAsset.Table_ID, asset.getA_Asset_ID());
        if (this.isAttachAsset()) {
            MProductDownload[] pdls = asset.getProductDownloads();
            if (pdls != null) {
                for (MProductDownload download : pdls) {
                    File fileToDownload = download.getDownloadFile(this.client.getDocumentDir());
                    notifier.addAttachment(fileToDownload);
                }
            } else {
                this.log.warning("No DowloadURL for Asset=" + asset);
            }
        }
        notifier.addToQueue();
        this.log.fine(System.currentTimeMillis() - start + " ms");
        return user.getEMail() + " - " + asset.getProductVersionNo();
    }
}

