/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.asset.model.MDepreciationEntry;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class DepreciationExpModify
extends SvrProcess {
    private int p_A_Depreciation_Exp_ID = -1;
    private int p_DR_Account_ID = -1;
    private int p_CR_Account_ID = -1;
    private boolean p_IsTest = true;

    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsTest")) {
                this.p_IsTest = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("A_Depreciation_Exp_ID")) {
                this.p_A_Depreciation_Exp_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("DR_Account_ID")) {
                this.p_DR_Account_ID = para.getParameterAsInt();
                continue;
            }
            if (!name.equals("CR_Account_ID")) continue;
            this.p_CR_Account_ID = para.getParameterAsInt();
        }
    }

    protected String doIt() throws Exception {
        if (this.p_A_Depreciation_Exp_ID <= 0) {
            throw new FillMandatoryException(new String[]{"A_Depreciation_Exp_ID"});
        }
        MDepreciationExp exp = new MDepreciationExp(this.getCtx(), this.p_A_Depreciation_Exp_ID, this.get_TrxName());
        if (exp.get_ID() != this.p_A_Depreciation_Exp_ID) {
            throw new AdempiereException("@NotFound@ @A_Depreciation_Exp_ID@ = " + this.p_A_Depreciation_Exp_ID);
        }
        MDepreciationEntry.deleteFacts(exp);
        exp.setDR_Account_ID(this.p_DR_Account_ID);
        exp.setCR_Account_ID(this.p_CR_Account_ID);
        exp.saveEx();
        if (this.p_IsTest) {
            this.rollback();
        }
        return "Ok";
    }
}

