/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.asset.process.DepreciationWorkfileBuildAbstract;
import org.compiere.model.Query;
import org.compiere.util.Trx;

public class DepreciationWorkfileBuild
extends DepreciationWorkfileBuildAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        AtomicInteger recordsProcessed = new AtomicInteger(0);
        if (this.isAllAssets()) {
            int[] depreciationWorkfileIds = this.getDepreciationWorkfileIds();
            Arrays.stream(depreciationWorkfileIds).forEach(id -> Trx.run(trxName -> this.buildDepreciation(id, recordsProcessed, trxName)));
            return "@Processed@ #" + recordsProcessed.get() + " @of@ " + depreciationWorkfileIds.length;
        }
        Trx.run(trxName -> this.buildDepreciation(this.getRecord_ID(), recordsProcessed, trxName));
        return "@Processed@ # " + recordsProcessed.get() + " @of@ 1";
    }

    private int[] getDepreciationWorkfileIds() {
        return new Query(this.getCtx(), "A_Depreciation_Workfile", "IsDepreciated='Y'", this.get_TrxName()).getIDs();
    }

    private void buildDepreciation(Integer depreciationWorkfileId, AtomicInteger recordProcessed, String trxName) {
        MDepreciationWorkfile depreciationWorkfile = new MDepreciationWorkfile(this.getCtx(), depreciationWorkfileId, trxName);
        depreciationWorkfile.buildDepreciation();
        depreciationWorkfile.saveEx();
        recordProcessed.getAndUpdate(processed -> processed + 1);
    }
}

