/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.util.Properties;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.process.ProjectCreateAssetAbstract;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProject;

public class ProjectCreateAsset
extends ProjectCreateAssetAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getProjectId() == 0) {
            return "Missing Mandatory Field Value (Project)";
        }
        MProject project = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
        this.log.info("doIt - " + project);
        if (!"A".equals(project.getProjectCategory())) {
            return "Project is not asset type";
        }
        MProduct product = new MProduct(this.getCtx(), this.getProjectId(), this.get_TrxName());
        MProductCategory pc = MProductCategory.get((Properties)this.getCtx(), (int)product.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return "Product is not asset type";
        }
        MAssetAddition assetAdd = MAssetAddition.createAsset(project, product);
        assetAdd.setDateAcct(this.getDateTrx());
        assetAdd.setDateDoc(this.getDateTrx());
        assetAdd.setM_Product_ID(this.getProjectId());
        if (this.getUseLifeYears() > 0) {
            assetAdd.setDeltaUseLifeYears(this.getUseLifeYears());
            assetAdd.setDeltaUseLifeYears_F(this.getUseLifeYears());
        }
        assetAdd.saveEx();
        if (!assetAdd.processIt("CO")) {
            return "Error Process Asset Addition";
        }
        assetAdd.saveEx();
        return "Asset Created. @A_Asset_Addition_ID@ - " + assetAdd;
    }
}

