/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetAcct;
import org.compiere.asset.model.MAssetSplit;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class Doc_AssetSplit
extends Doc {
    public Doc_AssetSplit(MAcctSchema[] as, ResultSet rs, String trxName) {
        super(as, MAssetSplit.class, rs, "GLD", trxName);
    }

    protected String loadDocumentDetails() {
        return null;
    }

    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        MAssetSplit assetSplit = (MAssetSplit)this.getPO();
        MAsset fixedAssetSource = MAsset.get(this.getCtx(), assetSplit.getA_Asset_ID(), this.getTrxName());
        ArrayList<Fact> facts = new ArrayList<Fact>();
        MAccount disposalLossAccount = this.getAccount(assetSplit.getA_Asset_ID(), assetSplit.getPostingType(), assetSplit.getDateAcct(), "A_Disposal_Loss_Acct");
        MAccount assetAccount = this.getAccount(assetSplit.getA_Asset_ID(), assetSplit.getPostingType(), assetSplit.getDateAcct(), "A_Asset_Acct");
        MAccount accumDepreciationAccount = this.getAccount(assetSplit.getA_Asset_ID(), assetSplit.getPostingType(), assetSplit.getDateAcct(), "A_Accumdepreciation_Acct");
        MAccount depreciationAccount = this.getAccount(assetSplit.getA_Asset_ID(), assetSplit.getPostingType(), assetSplit.getDateAcct(), "A_Depreciation_Acct");
        if (disposalLossAccount == null || assetAccount == null || accumDepreciationAccount == null || depreciationAccount == null) {
            return new ArrayList<Fact>();
        }
        assetSplit.getAssetBalance().ifPresent(assetBalance -> {
            Fact fact = new Fact((Doc)this, as, assetSplit.getPostingType());
            facts.add(fact);
            StringBuilder description = new StringBuilder();
            description.append(" @A_Asset_Split_ID@ ").append(this.getDocumentNo()).append(" @A_Asset_ID@ ").append(fixedAssetSource.getValue()).append(" @InventotyNo@ ").append(fixedAssetSource.getInventoryNo());
            if (assetSplit.getA_Asset_Cost().signum() > 0) {
                FactLine costLost = fact.createLine(null, disposalLossAccount, as.getC_Currency_ID(), assetSplit.getA_Asset_Cost(), Env.ZERO);
                costLost.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                costLost.setA_Asset_ID(assetSplit.getA_Asset_ID());
                costLost.saveEx();
                FactLine cost = fact.createLine(null, assetAccount, as.getC_Currency_ID(), Env.ZERO, assetSplit.getA_Asset_Cost());
                cost.setA_Asset_ID(assetSplit.getA_Asset_ID());
                cost.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                cost.saveEx();
            }
            if (assetBalance.getA_Accumulated_Depr().signum() > 0) {
                FactLine depreciation = fact.createLine(null, accumDepreciationAccount, as.getC_Currency_ID(), assetBalance.getA_Accumulated_Depr(), Env.ZERO);
                depreciation.setA_Asset_ID(assetSplit.getA_Asset_ID());
                depreciation.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                depreciation.save();
                FactLine depreciationLoss = fact.createLine(null, depreciationAccount, as.getC_Currency_ID(), Env.ZERO, assetBalance.getA_Accumulated_Depr());
                depreciationLoss.setA_Asset_ID(assetSplit.getA_Asset_ID());
                depreciationLoss.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                depreciationLoss.saveEx();
            }
            assetSplit.getAssetsSplit().stream().forEach(asset -> {
                description.append(" @A_Asset_Split_ID@ ").append(this.getDocumentNo()).append(" @A_Asset_ID@ ").append(asset.getValue()).append(" @InventotyNo@ ").append(asset.getInventoryNo());
                Optional.ofNullable(MDepreciationWorkfile.get(this.getCtx(), asset.getA_Asset_ID(), assetSplit.getPostingType(), assetSplit.get_TrxName())).ifPresent(assetSplitBalance -> {
                    if (assetSplitBalance.getA_Asset_Cost().signum() > 0) {
                        FactLine splitCost = fact.createLine(null, assetAccount, as.getC_Currency_ID(), assetSplitBalance.getA_Asset_Cost(), Env.ZERO);
                        splitCost.setA_Asset_ID(asset.getA_Asset_ID());
                        splitCost.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                        splitCost.saveEx();
                        FactLine splitCostLost = fact.createLine(null, disposalLossAccount, as.getC_Currency_ID(), Env.ZERO, assetSplitBalance.getA_Asset_Cost());
                        splitCostLost.setA_Asset_ID(asset.getA_Asset_ID());
                        splitCostLost.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                        splitCostLost.saveEx();
                    }
                    if (assetSplitBalance.getA_Accumulated_Depr().signum() > 0) {
                        FactLine splitDepreciationLoss = fact.createLine(null, depreciationAccount, as.getC_Currency_ID(), assetSplitBalance.getA_Accumulated_Depr(), Env.ZERO);
                        splitDepreciationLoss.setA_Asset_ID(asset.getA_Asset_ID());
                        splitDepreciationLoss.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                        splitDepreciationLoss.saveEx();
                        FactLine splitDepreciation = fact.createLine(null, accumDepreciationAccount, as.getC_Currency_ID(), Env.ZERO, assetSplitBalance.getA_Accumulated_Depr());
                        splitDepreciation.setA_Asset_ID(asset.getA_Asset_ID());
                        splitDepreciation.setDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)description.toString()));
                        splitDepreciation.saveEx();
                    }
                });
            });
        });
        return facts;
    }

    private MAccount getAccount(int assetId, String postingType, Timestamp dateAcct, String accountName) {
        MAssetAcct assetAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), assetId, postingType, dateAcct, this.getTrxName());
        if (assetAcct != null) {
            int accountId = (Integer)assetAcct.get_Value(accountName);
            return MAccount.get((Properties)this.getCtx(), (int)accountId);
        }
        return null;
    }
}

