/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.exceptions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class ArhRuntimeException
extends AdempiereException {
    private static final long serialVersionUID = -100343773302909791L;
    private HashMap<String, Object> m_info = new HashMap();

    public ArhRuntimeException() {
    }

    public ArhRuntimeException(String message) {
        super(message);
    }

    public ArhRuntimeException(Properties ctx, String message) {
        this(message);
    }

    public ArhRuntimeException(Throwable cause) {
        super(cause);
    }

    public ArhRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getLocalizedMessage() {
        StringBuffer sb = new StringBuffer();
        Properties ctx = Env.getCtx();
        String msg = this.getMessage();
        if (msg != null && msg.length() > 0) {
            sb.append(Msg.parseTranslation((Properties)ctx, (String)msg));
        } else {
            msg = null;
        }
        if (this.m_info.size() > 0) {
            Iterator<String> it = this.m_info.keySet().iterator();
            int cnt = 0;
            while (it.hasNext()) {
                String name = it.next();
                Object value = this.m_info.get(name);
                if (cnt == 0) {
                    if (msg != null) {
                        sb.append(" (");
                    }
                } else {
                    sb.append(", ");
                }
                sb.append(Msg.parseTranslation((Properties)ctx, (String)name));
                String svalue = this.getStringValue(value);
                if (value != null && svalue.length() > 0) {
                    sb.append(" ").append(svalue);
                }
                ++cnt;
            }
            if (cnt > 0 && msg != null) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    public void saveError(CLogger log) {
        log.saveError("Error", this.getLocalizedMessage());
    }

    public ArhRuntimeException addInfo(String name, boolean value) {
        return this.addInfo(name, (Object)value);
    }

    public ArhRuntimeException addInfo(String name) {
        return this.addInfo(name, "");
    }

    public ArhRuntimeException addInfo(String name, Object value) {
        if (name == null) {
            return this;
        }
        this.m_info.put(name, value);
        return this;
    }

    public ArhRuntimeException addField(String fieldName, Object value) {
        this.addInfo("@" + fieldName + "@ =", value);
        return this;
    }

    public boolean hasInfo() {
        return !this.m_info.isEmpty();
    }

    private String getStringValue(Object value) {
        String svalue = null;
        if (value == null) {
            svalue = "-";
        } else if (value instanceof Boolean) {
            svalue = Msg.getMsg((Properties)Env.getCtx(), (String)((Boolean)value != false ? "Yes" : "No"));
        } else if (value instanceof Timestamp) {
            SimpleDateFormat df = DisplayType.getDateFormat();
            svalue = df.format((Timestamp)value);
        } else {
            svalue = value.toString();
        }
        return svalue;
    }

    public String toString() {
        return this.getLocalizedMessage();
    }
}

