/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset;
import org.compiere.asset.exceptions.AssetCheckDocumentException;
import org.compiere.asset.model.MAssetAcct;
import org.compiere.asset.model.MAssetChange;
import org.compiere.asset.model.MAssetDelivery;
import org.compiere.asset.model.MAssetGroup;
import org.compiere.asset.model.MAssetGroupAcct;
import org.compiere.asset.model.MAssetType;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.asset.model.MIFixedAsset;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductDownload;
import org.compiere.model.MProject;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MAsset
extends X_A_Asset {
    public static final int CHANGETYPE_setAssetGroup = Table_ID * 100 + 1;
    private static final long serialVersionUID = -7537696364072606170L;
    private MProduct m_product = null;
    private static CLogger s_log = CLogger.getCLogger(MAsset.class);
    private int m_UseLifeMonths_F = 0;
    private int m_A_Current_Period = 0;
    private Timestamp m_DateAcct = null;
    private int m_A_Depreciation_ID = 0;
    private int m_A_Depreciation_F_ID = 0;
    private BigDecimal m_A_Asset_Cost = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr_F = Env.ZERO;

    public static MAsset getFromShipment(Properties ctx, int M_InOutLine_ID, String trxName) {
        String whereClause = "M_InOutLine_ID=?";
        MAsset retValue = (MAsset)new Query(ctx, "A_Asset", "M_InOutLine_ID=?", trxName).setParameters(new Object[]{M_InOutLine_ID}).first();
        return retValue;
    }

    public static MAsset get(Properties ctx, int A_Asset_ID, String trxName) {
        return (MAsset)MTable.get((Properties)ctx, (String)"A_Asset").getPO(A_Asset_ID, trxName);
    }

    public static Collection<MAsset> forASI(Properties ctx, int M_Product_ID, int M_ASI_ID) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        Object whereClause = "M_AttributeSetInstance_ID=?";
        params.add(M_ASI_ID);
        if (M_Product_ID > 0) {
            whereClause = (String)whereClause + " AND M_Product_ID=?";
            params.add(M_Product_ID);
        }
        return new Query(ctx, "A_Asset", (String)whereClause, null).setParameters(params).list();
    }

    public MAsset(Properties ctx, int A_Asset_ID, String trxName) {
        super(ctx, A_Asset_ID, trxName);
        if (A_Asset_ID == 0) {
            this.setA_Asset_Status("NW");
        }
    }

    public MAsset(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected MAsset(MMatchInv match) {
        this(match.getCtx(), 0, match.get_TrxName());
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), match.getC_InvoiceLine_ID(), this.get_TrxName());
        MInOutLine inoutLine = new MInOutLine(this.getCtx(), match.getM_InOutLine_ID(), this.get_TrxName());
        this.setM_InOutLine_ID(inoutLine.getM_InOutLine_ID());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setA_Asset_CreateDate(inoutLine.getM_InOut().getMovementDate());
        if (invoiceLine.getC_Project_ID() > 0) {
            this.setC_Project_ID(invoiceLine.getC_Project_ID());
        }
        if (invoiceLine.getC_Activity_ID() > 0) {
            this.setC_Activity_ID(invoiceLine.getC_Activity_ID());
        }
        int A_Asset_Group_ID = invoiceLine.getA_Asset_Group_ID();
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)invoiceLine.getM_Product_ID(), (String)this.get_TrxName());
        if (A_Asset_Group_ID <= 0) {
            A_Asset_Group_ID = product.getA_Asset_Group_ID();
        }
        this.setA_Asset_Group_ID(A_Asset_Group_ID);
        this.setHelp(Msg.getMsg((String)MClient.get((Properties)this.getCtx()).getAD_Language(), (String)"CreatedFromInvoiceLine", (Object[])new Object[]{invoiceLine.getC_Invoice().getDocumentNo(), invoiceLine.getLine()}));
        Object name = "";
        if (inoutLine.getM_Product_ID() > 0) {
            name = (String)name + product.getName() + "-";
            this.setM_Product_ID(inoutLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(inoutLine.getM_AttributeSetInstance_ID());
        }
        name = (String)name + invoiceLine.getC_Invoice().getDocumentNo();
        this.setName((String)name);
        this.log.fine("name=" + (String)name);
        this.setDescription(invoiceLine.getDescription());
    }

    protected MAsset(MIFixedAsset importFixedAsset) {
        this(importFixedAsset.getCtx(), 0, importFixedAsset.get_TrxName());
        this.setAD_Org_ID(importFixedAsset.getAD_Org_ID());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        String inventoryNo = importFixedAsset.getInventoryNo();
        if (inventoryNo != null) {
            inventoryNo = inventoryNo.trim();
            this.setInventoryNo(inventoryNo);
            this.setValue(inventoryNo);
        }
        this.setA_Asset_CreateDate(importFixedAsset.getAssetServiceDate());
        MProduct product = importFixedAsset.getProduct();
        if (product != null) {
            this.setM_Product_ID(product.getM_Product_ID());
            this.setA_Asset_Group_ID(importFixedAsset.getA_Asset_Group_ID());
            MAttributeSetInstance asi = MAttributeSetInstance.create((Properties)this.getCtx(), (MProduct)product, (String)this.get_TrxName());
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        this.setDateAcct(importFixedAsset.getDateAcct());
        this.setName(importFixedAsset.getName());
        this.setDescription(importFixedAsset.getDescription());
    }

    protected MAsset(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setA_Asset_CreateDate(new Timestamp(System.currentTimeMillis()));
        this.setHelp(Msg.getMsg((String)MClient.get((Properties)this.getCtx()).getAD_Language(), (String)"CreatedFromProject", (Object[])new Object[]{project.getName()}));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setDescription(project.getDescription());
        this.setC_Project_ID(project.getC_Project_ID());
    }

    public MAsset(MInOut mInOut, MInOutLine sLine, int deliveryCount) {
        this(mInOut.getCtx(), 0, mInOut.get_TrxName());
        this.setIsOwned(false);
        this.setIsInPosession(false);
        this.setA_Asset_CreateDate(new Timestamp(System.currentTimeMillis()));
        this.setHelp(Msg.getMsg((String)MClient.get((Properties)this.getCtx()).getAD_Language(), (String)"CreatedFromShipment: ", (Object[])new Object[]{mInOut.getDocumentNo()}));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setDescription(sLine.getDescription());
    }

    public MAsset(MInventory inventory, MInventoryLine invoiceLine, BigDecimal quantity, BigDecimal costs) {
        super(invoiceLine.getCtx(), 0, invoiceLine.get_TrxName());
        this.setClientOrg((PO)invoiceLine);
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)invoiceLine.getM_Product_ID());
        MAssetGroup assetGroup = MAssetGroup.get(invoiceLine.getCtx(), invoiceLine.getM_Product().getM_Product_Category().getA_Asset_Group_ID());
        if (assetGroup == null) {
            assetGroup = MAssetGroup.get(invoiceLine.getCtx(), product.getA_Asset_Group_ID());
        }
        this.setAssetGroup(assetGroup);
        this.setName(product.getName());
        this.setHelp(invoiceLine.getDescription());
        this.setAssetServiceDate(inventory.getMovementDate());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setM_Product_ID(product.getM_Product_ID());
        this.setVersionNo(product.getVersionNo());
        if (invoiceLine.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), invoiceLine.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setASI(asi);
        }
        this.setQty(quantity);
        Optional.ofNullable(invoiceLine).ifPresent(il -> {
            if (il.getC_Activity_ID() > 0) {
                this.setC_Activity_ID(il.getC_Activity_ID());
            }
            if (il.getC_Project_ID() > 0) {
                this.setC_Project_ID(il.getC_Project_ID());
            }
        });
        Optional.ofNullable(inventory).ifPresent(i -> {
            if (i.getC_Activity_ID() > 0) {
                this.setC_Project_ID(i.getC_Activity_ID());
            }
            if (i.getC_Project_ID() > 0) {
                this.setC_Project_ID(i.getC_Project_ID());
            }
        });
        if (MAssetType.isFixedAsset(this)) {
            this.setA_Asset_Status("NW");
        } else {
            this.setA_Asset_Status("AC");
            this.setProcessed(true);
        }
        this.setA_Asset_Status("NW");
    }

    public void setAssetGroup(MAssetGroup assetGroup) {
        this.setA_Asset_Group_ID(assetGroup.getA_Asset_Group_ID());
    }

    public MAssetGroup getAssetGroup() {
        return MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
    }

    public void setASI(MAttributeSetInstance asi) {
        this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        this.setLot(asi.getLot());
        this.setSerNo(asi.getSerNo());
    }

    public MAssetDelivery[] getDeliveries() {
        String whereClause = "A_Asset_ID=?";
        List list = new Query(this.getCtx(), "A_Asset_Delivery", "A_Asset_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getA_Asset_ID()}).setOrderBy("Created DESC").list();
        MAssetDelivery[] retValue = new MAssetDelivery[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int getDeliveryCount() {
        String sql = "SELECT COUNT(*) FROM A_Asset_Delivery WHERE A_Asset_ID=?";
        return DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getA_Asset_ID());
    }

    public boolean isDownloadable() {
        if (!this.isActive()) {
            return false;
        }
        Timestamp guarantee = this.getGuaranteeDate();
        if (guarantee == null) {
            return false;
        }
        guarantee = TimeUtil.getDay((Timestamp)guarantee);
        Timestamp now = TimeUtil.getDay((long)System.currentTimeMillis());
        if (!now.after(guarantee)) {
            this.getProduct();
            return this.m_product != null && this.m_product.hasDownloads();
        }
        return false;
    }

    public String getProductVersionNo() {
        return this.getProduct().getVersionNo();
    }

    public int getProductR_MailText_ID() {
        return this.getProduct().getR_MailText_ID();
    }

    private MProduct getProduct() {
        if (this.m_product == null) {
            this.m_product = MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID());
        }
        return this.m_product;
    }

    public MProductDownload[] getProductDownloads() {
        if (this.m_product == null) {
            this.getProduct();
        }
        if (this.m_product != null) {
            return this.m_product.getProductDownloads(false);
        }
        return null;
    }

    public String[] getDownloadNames() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            for (int i = 0; i < retValue.length; ++i) {
                retValue[i] = dls[i].getName();
            }
            this.log.fine("#" + dls.length);
            return retValue;
        }
        return new String[0];
    }

    public String[] getDownloadURLs() {
        MProductDownload[] dls = this.getProductDownloads();
        if (dls != null && dls.length > 0) {
            String[] retValue = new String[dls.length];
            for (int i = 0; i < retValue.length; ++i) {
                String url = dls[i].getDownloadURL();
                int pos = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
                if (pos != -1) {
                    url = url.substring(pos + 1);
                }
                retValue[i] = url;
            }
            return retValue;
        }
        return new String[0];
    }

    protected boolean beforeSave(boolean newRecord) {
        Object invNo;
        if (this.getA_Parent_Asset_ID() <= 0) {
            this.setA_Parent_Asset_ID(this.getA_Asset_ID());
        }
        if ((invNo = this.getInventoryNo()) == null || ((String)invNo).trim().length() == 0 || ((String)invNo).equals("0")) {
            invNo = "" + this.get_ID();
            this.setInventoryNo((String)invNo);
        }
        if (invNo != null) {
            this.setInventoryNo(((String)invNo).trim());
        }
        this.log.fine("InventoryNo=" + this.getInventoryNo());
        if (this.getA_Asset_Group_ID() <= 0) {
            this.setA_Asset_Group_ID(MAssetGroup.getDefault_ID(SetGetUtil.wrap((Object)this)));
        }
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getM_Product_ID());
        MProductCategory productCategory = MProductCategory.get((Properties)this.getCtx(), (int)product.getM_Product_Category_ID());
        if (this.getA_Asset_Group_ID() != productCategory.getA_Asset_Group_ID()) {
            throw new AssetCheckDocumentException("Asset Group and Product's Asset Group are different");
        }
        System.err.println("getA_Asset_Group_ID()=" + this.getA_Asset_Group_ID());
        if (this.getA_Asset_Group_ID() > 0) {
            List<MAssetGroupAcct> assetGrpAcct = MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset_Group_ID(), this.get_TrxName());
            this.log.severe("assetGrpAcct.size()=" + assetGrpAcct.size());
            if (assetGrpAcct.size() == 0) {
                this.log.saveError("Create Asset Error: ", Msg.translate((Properties)this.getCtx(), (String)"No Asset Group Account"));
                return false;
            }
        }
        if (this.is_ValueChanged("C_BPartner_Location_ID") && this.getC_BPartner_Location_ID() > 0) {
            SetGetUtil.copyValues(SetGetUtil.wrap((Object)this), "C_BPartner_Location", this.getC_BPartner_Location_ID(), new String[]{"C_Location_ID"});
        }
        if (this.getM_Product_ID() > 0 && this.getM_AttributeSetInstance_ID() <= 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), 0, product.getM_AttributeSet_ID(), this.get_TrxName());
            asi.setSerNo(this.getSerNo());
            asi.setDescription();
            asi.saveEx();
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        this.updateStatus();
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        Object invNo = this.getInventoryNo();
        if (invNo == null || ((String)invNo).trim().length() == 0 || ((String)invNo).equals("0")) {
            invNo = "" + this.get_ID();
            this.setInventoryNo((String)invNo);
        }
        if (invNo != null) {
            this.setInventoryNo(((String)invNo).trim());
        }
        this.log.fine("InventoryNo=" + this.getInventoryNo());
        if (this.getA_Parent_Asset_ID() <= 0) {
            int A_Asset_ID = this.getA_Asset_ID();
            this.setA_Parent_Asset_ID(A_Asset_ID);
            DB.executeUpdateEx((String)("UPDATE A_Asset SET A_Parent_Asset_ID=A_Asset_ID WHERE A_Asset_ID=" + A_Asset_ID), (String)this.get_TrxName());
            this.log.fine("A_Parent_Asset_ID=" + this.getA_Parent_Asset_ID());
        }
        if (newRecord) {
            MAssetGroup assetgroup = new MAssetGroup(this.getCtx(), this.getA_Asset_Group_ID(), this.get_TrxName());
            String isDepreciated = assetgroup.isDepreciated() ? "Y" : "N";
            String isOwned = assetgroup.isOwned() ? "Y" : "N";
            this.setIsDepreciated(assetgroup.isDepreciated());
            this.setIsOwned(assetgroup.isOwned());
            DB.executeUpdateEx((String)("UPDATE A_Asset SET IsDepreciated='" + isDepreciated + "', isOwned ='" + isOwned + "' WHERE A_Asset_ID=" + this.getA_Asset_ID()), (String)this.get_TrxName());
            for (MAssetGroupAcct assetgrpacct : MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset_Group_ID())) {
                MAssetAcct assetacct = new MAssetAcct(this, assetgrpacct);
                assetacct.setAD_Org_ID(this.getAD_Org_ID());
                assetacct.saveEx();
                MDepreciationWorkfile assetwk = new MDepreciationWorkfile(this, assetacct.getPostingType(), assetgrpacct);
                assetwk.setAD_Org_ID(this.getAD_Org_ID());
                assetwk.setUseLifeYears(0);
                assetwk.setUseLifeMonths(0);
                assetwk.setUseLifeYears_F(0);
                assetwk.setUseLifeMonths_F(0);
                assetwk.saveEx();
                MAssetChange.createAndSave(this.getCtx(), "CRT", new PO[]{this, assetwk, assetacct}, null);
            }
        } else {
            MAssetChange.createAndSave(this.getCtx(), "UPD", new PO[]{this}, null);
        }
        if (!newRecord && this.is_ValueChanged("IsDepreciated")) {
            String sql = "UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?";
            DB.executeUpdateEx((String)"UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?", (Object[])new Object[]{this.isDepreciated(), this.getA_Asset_ID()}, (String)this.get_TrxName());
        }
        return true;
    }

    protected boolean beforeDelete() {
        String sql = "DELETE FROM A_Asset_Addition WHERE Processed=? AND A_Asset_ID=?";
        int no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{false, this.getA_Asset_ID()}, (String)this.get_TrxName());
        this.log.info("@A_Asset_Addition@ @Deleted@ #" + no);
        sql = "UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?";
        no = DB.executeUpdateEx((String)"UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?", (Object[])new Object[]{null, false, this.getA_Asset_ID()}, (String)this.get_TrxName());
        this.log.info("@C_InvoiceLine@ @Updated@ #" + no);
        return true;
    }

    public void updateStatus() {
        String status = this.getA_Asset_Status();
        this.setProcessed(!status.equals("NW"));
        this.setIsDisposed(status.equals("DI"));
        this.setIsFullyDepreciated(status.equals("DP"));
        if (this.isFullyDepreciated() || status.equals("DI")) {
            this.setIsDepreciated(false);
        }
        if (status.equals("AC") || this.getAssetActivationDate() == null) {
            this.setAssetActivationDate(this.getAssetServiceDate());
        }
    }

    public void changeStatus(String newStatus, Timestamp date) {
        String status = this.getA_Asset_Status();
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("Entering: " + status + "->" + newStatus + ", date=" + date);
        }
        if (date == null) {
            date = Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date");
        }
        if (newStatus.equals("AC")) {
            this.setAssetActivationDate(date);
        }
        if (newStatus.equals("PR")) {
            this.setAssetDisposalDate(date);
            List<MDepreciationWorkfile> workFiles = MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
            for (MDepreciationWorkfile assetwk : workFiles) {
                assetwk.truncDepreciation();
                assetwk.saveEx();
            }
        }
        if (newStatus.equals("DI")) {
            this.setAssetDisposalDate(date);
        }
        this.setA_Asset_Status(newStatus);
    }

    public int getUseLifeMonths_F() {
        return this.m_UseLifeMonths_F;
    }

    public void setUseLifeMonths_F(int UseLifeMonths_F) {
        this.m_UseLifeMonths_F = UseLifeMonths_F;
    }

    public int getA_Current_Period() {
        return this.m_A_Current_Period;
    }

    public void setA_Current_Period(int A_Current_Period) {
        this.m_A_Current_Period = A_Current_Period;
    }

    public Timestamp getDateAcct() {
        return this.m_DateAcct;
    }

    public void setDateAcct(Timestamp DateAcct) {
        this.m_DateAcct = DateAcct;
    }

    public int getA_Depreciation_ID() {
        return this.m_A_Depreciation_ID;
    }

    public void setA_Depreciation_ID(int A_Depreciation_ID) {
        this.m_A_Depreciation_ID = A_Depreciation_ID;
    }

    public int getA_Depreciation_F_ID() {
        return this.m_A_Depreciation_F_ID;
    }

    public void setA_Depreciation_F_ID(int A_Depreciation_F_ID) {
        this.m_A_Depreciation_F_ID = A_Depreciation_F_ID;
    }

    public BigDecimal getA_Asset_Cost() {
        return this.m_A_Asset_Cost;
    }

    public void setA_Asset_Cost(BigDecimal A_Asset_Cost) {
        this.m_A_Asset_Cost = A_Asset_Cost;
    }

    public BigDecimal getA_Accumulated_Depr() {
        return this.m_A_Accumulated_Depr;
    }

    public void setA_Accumulated_Depr(BigDecimal A_Accumulated_Depr) {
        this.m_A_Accumulated_Depr = A_Accumulated_Depr;
    }

    public BigDecimal getA_Accumulated_Depr_F() {
        return this.m_A_Accumulated_Depr_F;
    }

    public void setA_Accumulated_Depr_F(BigDecimal A_Accumulated_Depr_F) {
        this.m_A_Accumulated_Depr_F = A_Accumulated_Depr_F;
    }
}

