/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Class;
import org.compiere.asset.feature.UseLifeImpl;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAssetClass
extends X_A_Asset_Class {
    private static CCache<Integer, MAssetClass> s_cache = new CCache("A_Asset_Class", 20);

    public MAssetClass(Properties ctx, int A_Asset_Class_ID, String trxName) {
        super(ctx, A_Asset_Class_ID, trxName);
    }

    public MAssetClass(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MAssetClass get(Properties ctx, int id) {
        if (id <= 0) {
            return null;
        }
        MAssetClass assetClass = (MAssetClass)((Object)s_cache.get((Object)id));
        if (assetClass == null) {
            assetClass = new MAssetClass(ctx, id, null);
        }
        if (assetClass.get_ID() != id) {
            return null;
        }
        s_cache.put((Object)id, (Object)assetClass);
        return assetClass;
    }

    public static MAssetClass get(Properties ctx, String value) {
        String whereClause = "UPPER(Value)=UPPER(?) AND AD_Client_ID IN (0,?)";
        return (MAssetClass)new Query(ctx, "A_Asset_Class", "UPPER(Value)=UPPER(?) AND AD_Client_ID IN (0,?)", null).setParameters(new Object[]{value, Env.getAD_Client_ID((Properties)ctx)}).setOrderBy("AD_Client_ID DESC").firstOnly();
    }

    public void setDescription() {
        String name;
        StringBuffer description = new StringBuffer();
        String value = this.getValue();
        if (value != null) {
            description.append(value).append(" ");
        }
        if ((name = this.getName()) != null) {
            description.append(name);
        }
        super.setDescription(description.toString());
    }

    public void setLevels() {
        this.setMFX_Grupa(0);
        this.setMFX_SubGrupa(0);
        this.setMFX_Clasa(0);
        this.setMFX_SubClasa(0);
        String value = this.getValue();
        if (value == null || value.length() == 0) {
            return;
        }
        String[] arr = value.split("\\.");
        try {
            if (arr.length >= 1) {
                this.setMFX_Grupa(Integer.valueOf(arr[0]));
            }
            if (arr.length >= 2) {
                this.setMFX_SubGrupa(Integer.valueOf(arr[1]));
            }
            if (arr.length >= 3) {
                this.setMFX_Clasa(Integer.valueOf(arr[2]));
            }
            if (arr.length >= 4) {
                this.setMFX_SubClasa(Integer.valueOf(arr[3]));
            }
        }
        catch (NumberFormatException e) {
            this.log.warning("@Error@ @Value@=" + value);
        }
    }

    public int getA_Life_Period_Min(Timestamp serviceDate) {
        Calendar cal = TimeUtil.getCalendar((Timestamp)serviceDate);
        if (cal.get(1) >= 2004) {
            return this.getA_Life_Period_Min();
        }
        return this.getA_Life_Period_2004();
    }

    public String validate(boolean saveError, int A_Life_Period, Timestamp serviceDate) {
        this.log.fine("Entering");
        int A_Life_Period_Min = 0;
        int A_Life_Period_Max = 1000000;
        Calendar cal = TimeUtil.getCalendar((Timestamp)serviceDate);
        if (cal.get(1) >= 2004) {
            A_Life_Period_Min = this.getA_Life_Period_Min();
            A_Life_Period_Max = this.getA_Life_Period_Max();
        } else {
            A_Life_Period_Min = this.getA_Life_Period_2004();
            A_Life_Period_Max = this.getA_Life_Period_2004();
        }
        if (CLogMgt.isLevelFine()) {
            this.log.fine("serviceDate=" + serviceDate + ", A_Life_Period_Min=" + A_Life_Period_Min + ", A_Life_Period_Max=" + A_Life_Period_Max + ", A_Life_Period=" + A_Life_Period);
        }
        if (A_Life_Period < A_Life_Period_Min || A_Life_Period > A_Life_Period_Max) {
            String errmsg = "@UseLifeMonths@=" + A_Life_Period + " @NotBetween@ " + A_Life_Period_Min + " - " + A_Life_Period_Max;
            if (saveError) {
                this.log.saveError("Error", errmsg);
            }
            if (CLogMgt.isLevelFine()) {
                this.log.fine("Leaving: " + errmsg);
                Thread.dumpStack();
            }
            return errmsg;
        }
        this.log.fine("Leaving: OK!");
        return "";
    }

    public boolean validate(UseLifeImpl asset) {
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: UseLifeImpl=" + asset);
        }
        if (!asset.isFiscal()) {
            this.log.fine("Leaving: fiscal=false [RETURN TRUE]");
            return true;
        }
        this.log.fine("asset is fiscal");
        int A_Life_Period = asset.getUseLifeMonths();
        Timestamp serviceDate = asset.getAssetServiceDate();
        String errmsg = this.validate(true, A_Life_Period, serviceDate);
        boolean ok = errmsg == null || errmsg.length() == 0;
        this.log.fine("Leaving: ok=" + ok);
        return ok;
    }

    public boolean isDepreciated() {
        return this.getA_Life_Period_Min() != 0 || this.getA_Life_Period_Max() != 0;
    }

    public boolean beforeSave(boolean newRecord) {
        this.setDescription();
        if (this.is_ValueChanged("Value")) {
            this.setValue(this.getValue().trim());
            this.setLevels();
        }
        return true;
    }
}

