/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Reval;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAssetReval
extends X_A_Asset_Reval
implements DocAction {
    private static final long serialVersionUID = 1L;
    private boolean m_justPrepared = false;
    private String m_processMsg = null;

    public MAssetReval(Properties ctx, int X_A_Asset_Reval_ID, String trxName) {
        super(ctx, X_A_Asset_Reval_ID, trxName);
        if (X_A_Asset_Reval_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetReval(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean approveIt() {
        return false;
    }

    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)"GLJ", (int)this.getAD_Org_ID());
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        if (!assetwk.isDepreciated(this.getDateAcct())) {
            throw new AdempiereException("Asset is not depreciated at this moment");
        }
        if (assetwk.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && assetwk.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("Nothing has changed");
        }
        if (assetwk.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && !assetwk.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("It has changed the cost of Asset");
        }
        if (!assetwk.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && assetwk.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("It has changed the cumulative depreciation");
        }
        if (!this.isLastDepreciated(this.getDateAcct())) {
            throw new AdempiereException("It can only review the last month processed");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean isLastDepreciated(Timestamp date) {
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        Timestamp lastActionDate = assetwk.getLastActionDate();
        boolean isLastDepr = TimeUtil.getMonthLastDay((Timestamp)date).equals(lastActionDate);
        return isLastDepr;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        assetwk.setA_Asset_Cost(this.getA_Asset_Cost_Change());
        assetwk.setA_Accumulated_Depr(this.getA_Change_Acumulated_Depr());
        assetwk.saveEx();
        MAsset asset = MAsset.get(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
        asset.setA_Asset_RevalDate(this.getDateDoc());
        asset.saveEx();
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public File createPDF() {
        return null;
    }

    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public String getDocumentInfo() {
        return this.getDocumentNo() + "/" + this.getDateAcct();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo());
        return sb.toString();
    }

    public boolean invalidateIt() {
        return false;
    }

    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    public boolean reActivateIt() {
        return false;
    }

    public boolean rejectIt() {
        return false;
    }

    public boolean reverseAccrualIt() {
        return false;
    }

    public boolean reverseCorrectIt() {
        return false;
    }

    public boolean unlockIt() {
        return false;
    }

    public boolean voidIt() {
        return false;
    }

    public String getDocumentNo() {
        return null;
    }
}

