/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MDepreciationEntry;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class DepreciationExpCheck
extends SvrProcess {
    private boolean p_IsTest = true;
    private int p_A_Asset_ID = -1;
    private String p_WhereClause = null;

    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsTest")) {
                this.p_IsTest = para.getParameterAsBoolean();
                continue;
            }
            if (name.equals("A_Asset_ID")) {
                this.p_A_Asset_ID = para.getParameterAsInt();
                continue;
            }
            if (!name.equals("WhereClause")) continue;
            this.p_WhereClause = (String)para.getParameter();
        }
    }

    protected String doIt() throws Exception {
        for (int A_Asset_ID : this.getAsset_IDs()) {
            this.fixDepreciation(A_Asset_ID);
            if (!this.p_IsTest) continue;
            this.rollback();
        }
        return "Ok";
    }

    private int[] getAsset_IDs() {
        ArrayList<Integer> params = new ArrayList<Integer>();
        String whereClause = null;
        if (this.p_A_Asset_ID > 0) {
            whereClause = "A_Asset_ID=?";
            params.add(this.p_A_Asset_ID);
        } else {
            whereClause = this.p_WhereClause;
        }
        return new Query(this.getCtx(), "A_Asset", whereClause, this.get_TrxName()).setParameters(params).setOrderBy("A_Asset_ID").getIDs();
    }

    private void fixDepreciation(int A_Asset_ID) {
        int i;
        Timestamp tms;
        MAsset asset = MAsset.get(this.getCtx(), A_Asset_ID, this.get_TrxName());
        List<MDepreciationExp> depreciations = this.getDepreciation(asset);
        if (depreciations.get(0).getA_Period() == 0) {
            this.fixDepreciationExp(depreciations.get(0), TimeUtil.getMonthLastDay((Timestamp)asset.getAssetServiceDate()));
            tms = depreciations.get(0).getDateAcct();
            for (i = 1; i < depreciations.size(); ++i) {
                this.fixDepreciationExp(depreciations.get(i), TimeUtil.getMonthLastDay((Timestamp)TimeUtil.addMonths((Timestamp)tms, (int)1)));
                tms = depreciations.get(i).getDateAcct();
            }
        } else {
            this.fixDepreciationExp(depreciations.get(0), TimeUtil.getMonthLastDay((Timestamp)TimeUtil.addMonths((Timestamp)asset.getAssetServiceDate(), (int)1)));
            tms = depreciations.get(0).getDateAcct();
            for (i = 1; i < depreciations.size(); ++i) {
                this.fixDepreciationExp(depreciations.get(i), TimeUtil.getMonthLastDay((Timestamp)TimeUtil.addMonths((Timestamp)tms, (int)1)));
                tms = depreciations.get(i).getDateAcct();
            }
        }
        for (MDepreciationWorkfile wk : MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), A_Asset_ID, this.get_TrxName())) {
            wk.setA_Current_Period();
            wk.saveEx();
            this.addLog(wk + ": Period=" + wk.getA_Current_Period() + ", DateAcct=" + wk.getDateAcct());
        }
    }

    private void fixDepreciationExp(MDepreciationExp exp, Timestamp dateAcctNew) {
        if (!exp.getDateAcct().equals(dateAcctNew)) {
            this.addLog("OLD1: " + exp);
            MDepreciationEntry.deleteFacts(exp);
            exp.setDateAcct(dateAcctNew);
            exp.setA_Depreciation_Entry_ID(0);
            exp.saveEx();
            this.addLog("NEW1: " + exp);
        }
        if (exp.getA_Depreciation_Entry_ID() > 0) {
            int C_Period_ID = DB.getSQLValueEx((String)exp.get_TrxName(), (String)"SELECT C_Period_ID FROM A_Depreciation_Entry WHERE A_Depreciation_Entry_ID=?", (Object[])new Object[]{exp.getA_Depreciation_Entry_ID()});
            MPeriod period = MPeriod.get((Properties)exp.getCtx(), (int)C_Period_ID);
            if (!period.isInPeriod(exp.getDateAcct())) {
                this.addLog("OLD2: " + exp);
                MDepreciationEntry.deleteFacts(exp);
                exp.setA_Depreciation_Entry_ID(0);
                exp.saveEx();
                this.addLog("NEW2: " + exp);
            }
        }
    }

    private List<MDepreciationExp> getDepreciation(MAsset asset) {
        String whereClause = "A_Asset_ID=?";
        return new Query(this.getCtx(), "A_Depreciation_Exp", whereClause, this.get_TrxName()).setParameters(new Object[]{asset.get_ID()}).setOrderBy("A_Period").list();
    }
}

