/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class LastPOPriceCostingMethod
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = model;
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
    }

    @Override
    public MCostDetail process() {
        CLogger logger = CLogger.getCLogger(LastPOPriceCostingMethod.class);
        boolean isReturnTrx = this.costDetail.getQty().signum() < 0;
        int precision = this.accountSchema.getCostingPrecision();
        BigDecimal price = this.costDetail.getAmt();
        if (this.costDetail.getQty().signum() != 0) {
            price = this.costDetail.getAmt().divide(this.costDetail.getQty(), precision, RoundingMode.HALF_UP);
        }
        if (this.costDetail.getC_OrderLine_ID() != 0) {
            if (!isReturnTrx) {
                if (this.costDetail.getQty().signum() != 0) {
                    this.dimension.setCurrentCostPrice(price);
                } else {
                    BigDecimal currentCost = this.dimension.getCurrentCostPrice().add(this.costDetail.getAmt());
                    this.dimension.setCurrentCostPrice(currentCost);
                }
            }
            this.dimension.add(this.costDetail.getAmt(), this.costDetail.getQty());
            logger.finer("PO - LastPO - " + this.dimension);
        } else if (this.costDetail.getM_InOutLine_ID() != 0 || this.costDetail.getM_MovementLine_ID() != 0 || this.costDetail.getM_InventoryLine_ID() != 0 || this.costDetail.getM_ProductionLine_ID() != 0 || this.costDetail.getC_ProjectIssue_ID() != 0 || this.costDetail.getPP_Cost_Collector_ID() != 0) {
            this.dimension.setCurrentQty(this.dimension.getCurrentQty().add(this.costDetail.getQty()));
            logger.finer("QtyAdjust - LastPO - " + this.dimension);
            this.dimension.saveEx();
        }
        return this.costDetail;
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public void updateAmountCost() {
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, int roundingMode) {
        return this.getNewCurrentCostPrice(cost, scale, RoundingMode.valueOf(roundingMode));
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, RoundingMode roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmount(cost).signum() != 0) {
            return this.getNewAccumulatedAmount(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cost) {
        BigDecimal accumulatedAmount = Env.ZERO;
        if (cost.getQty().signum() > 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
            }
        }
        return accumulatedAmount;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cost) {
        BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
        if (cost.getQty().signum() >= 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
            }
        }
        return accumulatedAmountLowerLevel;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, int roundingMode) {
        return this.getNewCurrentCostPriceLowerLevel(cost, scale, RoundingMode.valueOf(roundingMode));
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, RoundingMode roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmountLowerLevel(cost).signum() != 0) {
            return this.getNewAccumulatedAmountLowerLevel(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cost) {
        return cost.getCumulatedQty().add(cost.getQty());
    }
}

