/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MDocType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class StandardCostingMethod
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.isSalesTransaction = isSalesTransaction;
        this.model = transaction.getDocumentLine();
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(this.accountSchema, this.transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
        this.movementQuantity = transaction.getMovementQty();
        MDocType documentType = new MDocType(transaction.getCtx(), transaction.getDocumentLine().getC_DocType_ID(), transaction.get_TrxName());
        this.isOpenPeriod = MPeriod.isOpen(transaction.getCtx(), model.getDateAcct(), documentType.getDocBaseType(), transaction.getAD_Org_ID());
        this.dateAccounting = this.isOpenPeriod != false ? model.getDateAcct() : (model instanceof MLandedCostAllocation ? ((MLandedCostAllocation)model).getC_InvoiceLine().getC_Invoice().getDateAcct() : (model instanceof MMatchInv ? ((MMatchInv)model).getC_InvoiceLine().getC_Invoice().getDateAcct() : null));
    }

    private void calculate() {
        if (this.model.getReversalLine_ID() > 0 && !this.model.isReversalParent()) {
            return;
        }
        this.lastCostDetail = MCostDetail.getLastTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.dateAccounting, this.costingLevel);
        if (this.lastCostDetail == null) {
            this.lastCostDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), Env.ZERO, Env.ZERO, Env.ZERO, this.transaction.get_TrxName());
            this.lastCostDetail.setDateAcct(this.dateAccounting);
        }
        if (this.movementQuantity.signum() < 0) {
            this.currentCostPrice = this.dimension.getCurrentCostPrice();
            this.currentCostPriceLowerLevel = this.dimension.getCurrentCostPriceLL();
            this.amount = this.movementQuantity.multiply(this.currentCostPrice);
            this.amountLowerLevel = this.movementQuantity.multiply(this.currentCostPriceLowerLevel);
            this.accumulatedQuantity = this.dimension.getCumulatedQty().add(this.movementQuantity);
            this.accumulatedAmount = this.dimension.getCumulatedAmt().add(this.amount);
            this.accumulatedAmountLowerLevel = this.dimension.getCumulatedAmtLL().add(this.amountLowerLevel);
            return;
        }
        if (this.costDetail != null) {
            this.amount = this.movementQuantity.multiply(this.costDetail.getCurrentCostPrice());
            this.amountLowerLevel = this.movementQuantity.multiply(this.costDetail.getCurrentCostPriceLL());
            this.accumulatedQuantity = this.costDetail.getCumulatedQty().add(this.movementQuantity);
            this.accumulatedAmount = this.costDetail.getCumulatedAmt().add(this.amount);
            this.accumulatedAmountLowerLevel = this.costDetail.getCumulatedAmtLL().add(this.amountLowerLevel);
            this.currentCostPrice = this.dimension.getCurrentCostPrice();
            this.currentCostPriceLowerLevel = this.dimension.getCurrentCostPriceLL();
            this.adjustCost = this.currentCostPrice.multiply(this.dimension.getCumulatedQty()).subtract(this.dimension.getCumulatedAmt());
            this.adjustCost = this.currentCostPriceLowerLevel.multiply(this.dimension.getCumulatedQty()).subtract(this.dimension.getCumulatedAmtLL());
            return;
        }
        this.amount = this.movementQuantity.multiply(this.dimension.getCurrentCostPrice());
        this.amountLowerLevel = this.movementQuantity.multiply(this.dimension.getCurrentCostPriceLL());
        this.accumulatedAmount = this.dimension.getCumulatedAmt().add(this.amount).add(this.adjustCost);
        this.accumulatedAmountLowerLevel = this.dimension.getCumulatedAmtLL().add(this.amountLowerLevel).add(this.adjustCostLowerLevel);
        this.accumulatedQuantity = this.dimension.getCumulatedQty().add(this.movementQuantity);
        this.currentCostPrice = this.dimension.getCurrentCostPrice();
        this.currentCostPriceLowerLevel = this.dimension.getCurrentCostPriceLL();
    }

    private void createCostDetail() {
        CharSequence description;
        String idColumnName = CostEngine.getIDColumnName(this.model);
        if (this.model.getReversalLine_ID() > 0 && !this.model.isReversalParent()) {
            this.createReversalCostDetail();
            return;
        }
        int seqNo = this.lastCostDetail.getSeqNo() + 10;
        if (this.costDetail == null) {
            this.costDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), this.currentCostPrice.multiply(this.movementQuantity).abs(), this.currentCostPriceLowerLevel.multiply(this.movementQuantity).abs(), this.movementQuantity, this.transaction.get_TrxName());
            this.costDetail.setDateAcct(this.dateAccounting);
            this.costDetail.setSeqNo(seqNo);
        }
        if (this.adjustCost.signum() != 0 || this.adjustCostLowerLevel.signum() != 0) {
            CharSequence charSequence = description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
            if (this.adjustCost.signum() != 0) {
                this.costDetail.setCostAdjustmentDate(this.model.getDateAcct());
                this.costDetail.setCostAdjustment(this.adjustCost);
                this.costDetail.setAmt(this.costDetail.getAmt().add(this.costDetail.getCostAdjustment()));
                this.costDetail.setDescription((String)description + " Adjust Cost:" + this.adjustCost);
            }
            if (this.adjustCostLowerLevel.signum() != 0) {
                description = this.costDetail.getDescription() != null ? this.costDetail.getDescription() : "";
                this.costDetail.setCostAdjustmentDateLL(this.model.getDateAcct());
                this.costDetail.setCostAdjustmentLL(this.adjustCostLowerLevel);
                this.costDetail.setAmtLL(this.costDetail.getCostAmtLL().add(this.costDetail.getCostAdjustmentLL()));
                this.costDetail.setDescription((String)description + " Adjust Cost LL:" + this.adjustCost);
            }
        }
        if (!this.costDetail.set_ValueOfColumnReturningBoolean(idColumnName, (Object)this.model.get_ID())) {
            throw new AdempiereException("Cannot set " + idColumnName);
        }
        if (this.isSalesTransaction != null) {
            this.costDetail.setIsSOTrx(this.isSalesTransaction);
        } else {
            this.costDetail.setIsSOTrx(this.model.isSOTrx());
        }
        if (this.transaction != null) {
            this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
        }
        this.costDetail.setCumulatedQty(this.dimension.getCumulatedQty());
        this.costDetail.setCumulatedAmt(this.dimension.getCumulatedAmt());
        this.costDetail.setCumulatedAmtLL(this.dimension.getCumulatedAmtLL());
        this.costDetail.setCurrentCostPrice(this.dimension.getCurrentCostPrice());
        this.costDetail.setCurrentCostPriceLL(this.dimension.getCurrentCostPriceLL());
        description = new StringBuilder();
        if (!Util.isEmpty(this.model.getDescription(), true)) {
            ((StringBuilder)description).append(this.model.getDescription());
        }
        if (this.isSalesTransaction != null) {
            ((StringBuilder)description).append(this.isSalesTransaction != false ? "(|->)" : "(|<-)");
        }
        if (this.transaction != null) {
            this.costDetail.setM_Transaction_ID(this.transaction.getM_Transaction_ID());
        }
        this.costDetail.setDescription(((StringBuilder)description).toString());
        this.updateAmountCost();
        this.costDetail.saveEx();
    }

    public void createCostAdjustment() {
    }

    @Override
    public MCostDetail process() {
        this.calculate();
        this.createCostDetail();
        this.updateInventoryValue();
        this.createCostAdjustment();
        return this.costDetail;
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, int roundingMode) {
        return this.getNewCurrentCostPrice(cost, scale, RoundingMode.valueOf(roundingMode));
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, RoundingMode roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmount(cost).signum() != 0) {
            return this.getNewAccumulatedAmount(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cost) {
        BigDecimal accumulatedAmount = Env.ZERO;
        if (cost.getQty().signum() > 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt()).add(cost.getCostAdjustment());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmount = cost.getCumulatedAmt().add(cost.getCostAmt().negate()).add(cost.getCostAdjustment().negate());
            }
        }
        return accumulatedAmount;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cost) {
        BigDecimal accumulatedAmountLowerLevel = Env.ZERO;
        if (cost.getQty().signum() >= 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
        } else if (cost.getQty().signum() < 0) {
            accumulatedAmountLowerLevel = cost.getCumulatedAmtLL().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
        } else if (cost.getQty().signum() == 0) {
            if (this.getNewAccumulatedQuantity(cost).signum() > 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmt().add(cost.getCostAmtLL()).add(cost.getCostAdjustmentLL());
            } else if (this.getNewAccumulatedQuantity(cost).signum() < 0) {
                accumulatedAmountLowerLevel = cost.getCumulatedAmt().add(cost.getCostAmtLL().negate()).add(cost.getCostAdjustmentLL().negate());
            }
        }
        return accumulatedAmountLowerLevel;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, int roundingMode) {
        return this.getNewCurrentCostPriceLowerLevel(cost, scale, RoundingMode.valueOf(roundingMode));
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, RoundingMode roundingMode) {
        if (this.getNewAccumulatedQuantity(cost).signum() != 0 && this.getNewAccumulatedAmountLowerLevel(cost).signum() != 0) {
            return this.getNewAccumulatedAmountLowerLevel(cost).divide(this.getNewAccumulatedQuantity(cost), scale, roundingMode);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cost) {
        return cost.getCumulatedQty().add(cost.getQty());
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public void updateAmountCost() {
        if (this.movementQuantity.signum() > 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().subtract(this.costDetail.getCostAdjustment()));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().subtract(this.costDetail.getCostAdjustmentLL()));
        } else if (this.movementQuantity.signum() < 0) {
            this.costDetail.setCostAmt(this.costDetail.getAmt().add(this.adjustCost));
            this.costDetail.setCostAmtLL(this.costDetail.getAmtLL().add(this.adjustCostLowerLevel));
        }
        this.costDetail.setCumulatedQty(this.getNewAccumulatedQuantity(this.lastCostDetail));
        this.costDetail.setCumulatedAmt(this.getNewAccumulatedAmount(this.lastCostDetail));
        this.costDetail.setCumulatedAmtLL(this.getNewAccumulatedAmountLowerLevel(this.lastCostDetail));
        this.costDetail.setCurrentCostPrice(this.currentCostPrice);
        this.costDetail.setCurrentCostPriceLL(this.currentCostPriceLowerLevel);
        String idColumnName = CostEngine.getIDColumnName(this.model);
        this.costDetail.set_ValueOfColumn(idColumnName, (Object)CostEngine.getIDColumn(this.model));
        if (this.model instanceof MInOutLine) {
            MInOutLine ioLine = (MInOutLine)this.model;
            this.costDetail.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
            this.costDetail.setC_InvoiceLine_ID(0);
        }
        if (this.model instanceof MMatchInv && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchInv iMatch = (MMatchInv)this.model;
            this.costDetail.setM_InOutLine_ID(iMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MMatchPO && this.costDetail.getM_InOutLine_ID() == 0) {
            MMatchPO poMatch = (MMatchPO)this.model;
            this.costDetail.setM_InOutLine_ID(poMatch.getM_InOutLine_ID());
        }
        if (this.model instanceof MLandedCostAllocation) {
            MLandedCostAllocation allocation = (MLandedCostAllocation)this.model;
            this.costDetail.setM_InOutLine_ID(allocation.getM_InOutLine_ID());
            this.costDetail.setC_InvoiceLine_ID(allocation.getC_InvoiceLine_ID());
            this.costDetail.setC_LandedCostAllocation_ID(allocation.getC_LandedCostAllocation_ID());
            this.costDetail.setProcessed(false);
        }
        this.costDetail.saveEx();
    }

    @Override
    public void updateInventoryValue() {
        this.dimension.setCumulatedAmt(this.accumulatedAmount);
        this.dimension.setCumulatedAmtLL(this.accumulatedAmountLowerLevel);
        this.dimension.setCumulatedQty(this.accumulatedQuantity);
        this.dimension.setCurrentQty(this.accumulatedQuantity);
        this.dimension.saveEx();
    }
}

