/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class NoCurrencyConversionException
extends AdempiereException {
    private static final long serialVersionUID = 1L;

    public NoCurrencyConversionException(int C_Currency_ID, int C_Currency_ID_To, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        super(NoCurrencyConversionException.buildMessage(C_Currency_ID, C_Currency_ID_To, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID));
    }

    private static final String buildMessage(int C_Currency_ID, int C_Currency_ID_To, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        SimpleDateFormat df = DisplayType.getDateFormat(15);
        StringBuffer sb = new StringBuffer("@NoCurrencyConversion@ ").append(MCurrency.getISO_Code(Env.getCtx(), C_Currency_ID)).append("->").append(MCurrency.getISO_Code(Env.getCtx(), C_Currency_ID_To));
        sb.append(", @Date@: ");
        if (ConvDate != null) {
            sb.append(df.format(ConvDate));
        } else {
            sb.append("*");
        }
        sb.append(", @C_ConversionType_ID@: ");
        if (C_ConversionType_ID > 0) {
            String sql = "SELECT Name FROM C_ConversionType WHERE C_ConversionType_ID=?";
            String name = DB.getSQLValueString(null, "SELECT Name FROM C_ConversionType WHERE C_ConversionType_ID=?", C_ConversionType_ID);
            sb.append(name);
        } else {
            sb.append("*");
        }
        return sb.toString();
    }
}

