/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.model.GenericPO;
import org.adempiere.model.IDocumentStatus;
import org.adempiere.model.POWrapper;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ResultSetIterable;

public class MDocumentStatus {
    private static CLogger log = CLogger.getCLogger(MDocumentStatus.class);

    public static IDocumentStatus[] getDocumentStatusIndicators(Properties ctx, int userId, int roleId) {
        if (userId < 0) {
            return new IDocumentStatus[0];
        }
        ArrayList list = new ArrayList();
        String sql = "SELECT * FROM PA_DocumentStatus g WHERE IsActive = ?  AND ((AD_User_ID IS NULL OR AD_User_ID=?) AND  ( AD_Role_ID IS NULL OR AD_Role_ID=?)) ORDER BY SeqNo";
        String sqlAccess = MRole.getDefault().addAccessSQL("SELECT * FROM PA_DocumentStatus g WHERE IsActive = ?  AND ((AD_User_ID IS NULL OR AD_User_ID=?) AND  ( AD_Role_ID IS NULL OR AD_Role_ID=?)) ORDER BY SeqNo", "g", true, false);
        ((Try)DB.runResultSetFunction.apply(null, (Object)sqlAccess, (Object)List.of((Object[])new Object[]{"Y", userId, roleId}), resultSet -> new ResultSetIterable<IDocumentStatus>((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> {
            GenericPO indicator = new GenericPO("PA_DocumentStatus", ctx, (ResultSet)row);
            return POWrapper.create(indicator, IDocumentStatus.class);
        }).forEach(documentStatus -> list.add(documentStatus)))).onFailure(throwable -> log.severe(throwable.getMessage()));
        IDocumentStatus[] retValue = new IDocumentStatus[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int evaluate(IDocumentStatus documentStatus) {
        StringBuffer sql = new StringBuffer("SELECT Count(*) FROM ");
        String tableName = MTable.getTableName(Env.getCtx(), documentStatus.getAD_Table_ID());
        sql.append(tableName);
        String where = MDocumentStatus.getWhereClause(documentStatus);
        if (where != null && where.trim().length() > 0) {
            sql.append(" WHERE ").append(where);
        }
        String parsedSql = MRole.getDefault().addAccessSQL(sql.toString(), tableName, true, false);
        return DB.getSQLValue(null, parsedSql.toString());
    }

    public static String getWhereClause(IDocumentStatus documentStatus) {
        String extra;
        StringBuffer where = new StringBuffer(" AD_Client_ID= " + documentStatus.getAD_Client_ID());
        if (documentStatus.getC_Project_ID() > 0) {
            where.append(" AND C_Project_ID=").append(documentStatus.getC_Project_ID());
        }
        if (documentStatus.getAD_Org_ID() > 0) {
            where.append(" AND AD_Org_ID=").append(documentStatus.getAD_Org_ID());
        }
        if ((extra = documentStatus.getWhereClause()) != null && extra.trim().length() > 0) {
            where.append(" AND ( ").append(extra).append(" ) ");
        }
        return Env.parseContext(Env.getCtx(), 0, where.toString(), true);
    }
}

