/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.ElementHandler;
import org.adempiere.pipo.IDFinder;
import org.adempiere.pipo.PackIn;
import org.adempiere.pipo.handler.GenericPOHandler;
import org.adempiere.pipo.handler.PackinCustomHandler;
import org.compiere.model.MColumn;
import org.compiere.model.MSequence;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.spin.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PackInHandler
extends DefaultHandler {
    private boolean updateMode = true;
    private String packageDirectory = null;
    private String databaseType = "Oracle";
    private boolean synchronizeColumns = true;
    private int clientId = 0;
    private int AD_Package_Imp_ID = 0;
    private int AD_Package_Imp_Inst_ID = 0;
    private CLogger log = CLogger.getCLogger(PackInHandler.class);
    private OutputStream fw_document = null;
    private TransformerHandler logDocument = null;
    private StreamResult streamResult_document = null;
    private SAXTransformerFactory tf_document = null;
    private Transformer serializer_document = null;
    private int Start_Doc = 0;
    private String logDate = null;
    private String PK_Status = "Installing";
    private String trxName = null;
    private Properties context = null;
    private List<Element> workflow = new ArrayList<Element>();
    private List<DeferEntry> defer = new ArrayList<DeferEntry>();
    private Stack<Element> stack = new Stack();
    private List<Element> columns = new ArrayList<Element>();
    private PackIn packIn;

    public PackInHandler() {
        PackinCustomHandler.getInstance();
    }

    private void init() throws SAXException {
        if (this.packIn == null) {
            this.packIn = new PackIn();
        }
        this.packageDirectory = PackIn.packageDirectory;
        this.updateMode = PackIn.updateMode;
        this.databaseType = PackIn.database;
        this.synchronizeColumns = PackIn.isRequiresSync;
        SimpleDateFormat formatter_file = new SimpleDateFormat("yyMMddHHmmssZ");
        SimpleDateFormat formatter_log = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        Date today = new Date();
        String fileDate = formatter_file.format(today);
        this.logDate = formatter_log.format(today);
        String file_document = this.packageDirectory + File.separator + "doc" + File.separator + "Importlog_" + fileDate + ".xml";
        this.log.info("file_document=" + file_document);
        try {
            this.fw_document = new FileOutputStream(file_document, false);
        }
        catch (FileNotFoundException e1) {
            this.log.warning("Failed to create log file:" + e1);
        }
        this.streamResult_document = new StreamResult(this.fw_document);
        this.tf_document = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        XMLUtils.setDefaultFeatures(this.tf_document);
        try {
            this.logDocument = this.tf_document.newTransformerHandler();
        }
        catch (TransformerConfigurationException e2) {
            this.log.info("startElement:" + e2);
        }
        this.serializer_document = this.logDocument.getTransformer();
        this.serializer_document.setOutputProperty("encoding", "ISO-8859-1");
        this.serializer_document.setOutputProperty("indent", "yes");
        this.logDocument.setResult(this.streamResult_document);
        this.logDocument.startDocument();
        this.logDocument.processingInstruction("xml-stylesheet", "type=\"text/css\" href=\"adempiereDocument.css\"");
        Properties tmp = new Properties();
        if (this.context != null) {
            tmp.putAll((Map<?, ?>)this.context);
        } else {
            tmp.putAll((Map<?, ?>)Env.getCtx());
        }
        this.context = tmp;
        if (this.trxName == null) {
            this.trxName = Trx.createTrxName("PackIn");
        }
        this.clientId = Env.getContextAsInt(this.context, "AD_Client_ID");
        this.Start_Doc = 1;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ElementHandler handler;
        if (this.Start_Doc == 0) {
            this.init();
        }
        Object elementValue = null;
        elementValue = "".equals(uri) ? qName : uri + localName;
        if (((String)elementValue).equals("adempiereAD")) {
            this.log.info("adempiereAD updateMode=" + this.updateMode);
            AttributesImpl attsOut = new AttributesImpl();
            this.logDocument.startElement("", "", "adempiereDocument", attsOut);
            this.logDocument.startElement("", "", "header", attsOut);
            this.logDocument.characters((atts.getValue("Name") + " Install Log").toCharArray(), 0, (atts.getValue("Name") + " Install Log").length());
            this.logDocument.endElement("", "", "header");
            this.logDocument.startElement("", "", "H3", attsOut);
            this.logDocument.characters("Package Name:".toCharArray(), 0, "Package Name:".length());
            this.logDocument.endElement("", "", "H3");
            this.logDocument.startElement("", "", "packagename4log", attsOut);
            this.logDocument.characters(atts.getValue("Name").toCharArray(), 0, atts.getValue("Name").length());
            this.logDocument.endElement("", "", "packagename4log");
            this.logDocument.startElement("", "", "H3", attsOut);
            this.logDocument.characters("Version:".toCharArray(), 0, "Version:".length());
            this.logDocument.endElement("", "", "H3");
            this.logDocument.startElement("", "", "Version", attsOut);
            this.logDocument.characters(atts.getValue("Version").toCharArray(), 0, atts.getValue("Version").length());
            this.logDocument.endElement("", "", "Version");
            this.logDocument.startElement("", "", "H3", attsOut);
            this.logDocument.characters("Package Install Date:".toCharArray(), 0, "Package Install Date:".length());
            this.logDocument.endElement("", "", "H3");
            this.logDocument.startElement("", "", "installDate", attsOut);
            this.logDocument.characters(this.logDate.toCharArray(), 0, this.logDate.length());
            this.logDocument.endElement("", "", "installDate");
            this.logDocument.startElement("", "", "H3", attsOut);
            this.logDocument.characters("Min. Compiere Version:".toCharArray(), 0, "Min. Compiere Version:".length());
            this.logDocument.endElement("", "", "H3");
            this.logDocument.startElement("", "", "CompVer", attsOut);
            this.logDocument.characters(atts.getValue("CompVer").toCharArray(), 0, atts.getValue("CompVer").length());
            this.logDocument.endElement("", "", "CompVer");
            this.logDocument.startElement("", "", "H3", attsOut);
            this.logDocument.characters("Min. Database Date:".toCharArray(), 0, "Min. Database Date:".length());
            this.logDocument.endElement("", "", "H3");
            this.logDocument.startElement("", "", "DataBase", attsOut);
            this.logDocument.characters(atts.getValue("DataBase").toCharArray(), 0, atts.getValue("DataBase").length());
            this.logDocument.endElement("", "", "DataBase");
            this.createImp_Sum_table("AD_Package_Imp_Backup");
            this.createImp_Sum_table("AD_Package_Imp");
            this.createImp_Sum_table("AD_Package_Imp_Inst");
            this.createImp_Sum_table("AD_Package_Imp_Detail");
            String sql2 = "SELECT AD_PACKAGE_IMP_INST_ID FROM AD_PACKAGE_IMP_INST WHERE NAME ='" + atts.getValue("Name") + "' AND PK_VERSION ='" + atts.getValue("Version") + "'";
            int PK_preInstalled = DB.getSQLValue(this.trxName, sql2);
            this.AD_Package_Imp_ID = DB.getNextID(Env.getAD_Client_ID(this.context), "AD_Package_Imp", null);
            StringBuffer sqlB = new StringBuffer("INSERT INTO AD_Package_Imp").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_PACKAGE_IMP_ID, RELEASENO, PK_VERSION, VERSION ").append(", DESCRIPTION, NAME, CREATOR").append(", CREATORCONTACT, CREATEDDATE,UPDATEDDATE,PK_STATUS)").append("VALUES(").append(" " + Env.getAD_Client_ID(this.context)).append(", " + Env.getAD_Org_ID(this.context)).append(", " + Env.getAD_User_ID(this.context)).append(", " + Env.getAD_User_ID(this.context)).append(", " + this.AD_Package_Imp_ID).append(", '" + atts.getValue("CompVer")).append("', '" + atts.getValue("Version")).append("', '" + atts.getValue("DataBase")).append("', '" + atts.getValue("Description").replaceAll("'", "''")).append("', '" + atts.getValue("Name")).append("', '" + atts.getValue("creator")).append("', '" + atts.getValue("creatorcontact")).append("', '" + atts.getValue("createddate")).append("', '" + atts.getValue("updateddate")).append("', '" + this.PK_Status).append("')");
            Env.getAD_User_ID(this.context);
            int no = DB.executeUpdate(sqlB.toString(), this.trxName);
            if (no == -1) {
                this.log.info("Insert to Package import failed");
            }
            if (PK_preInstalled == -1) {
                this.AD_Package_Imp_Inst_ID = DB.getNextID(Env.getAD_Client_ID(this.context), "AD_Package_Imp_Inst", null);
                sqlB = new StringBuffer("INSERT INTO AD_Package_Imp_Inst").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_PACKAGE_IMP_INST_ID, RELEASENO, PK_VERSION, VERSION ").append(", DESCRIPTION, NAME, CREATOR").append(", CREATORCONTACT, CREATEDDATE,UPDATEDDATE,PK_STATUS)").append("VALUES(").append(" " + Env.getAD_Client_ID(this.context)).append(", " + Env.getAD_Org_ID(this.context)).append(", " + Env.getAD_User_ID(this.context)).append(", " + Env.getAD_User_ID(this.context)).append(", " + this.AD_Package_Imp_Inst_ID).append(", '" + atts.getValue("CompVer")).append("', '" + atts.getValue("Version")).append("', '" + atts.getValue("DataBase")).append("', '" + atts.getValue("Description").replaceAll("'", "''")).append("', '" + atts.getValue("Name")).append("', '" + atts.getValue("creator")).append("', '" + atts.getValue("creatorcontact")).append("', '" + atts.getValue("createddate")).append("', '" + atts.getValue("updateddate")).append("', '" + this.PK_Status).append("')");
                Env.getAD_User_ID(this.context);
                no = DB.executeUpdate(sqlB.toString(), this.trxName);
                if (no == -1) {
                    this.log.info("Insert to Package List import failed");
                }
            } else {
                this.AD_Package_Imp_Inst_ID = PK_preInstalled;
                sqlB = new StringBuffer("UPDATE AD_Package_Imp_Inst SET PK_Status = '" + this.PK_Status + "' WHERE AD_Package_Imp_Inst_ID = " + this.AD_Package_Imp_Inst_ID);
                no = DB.executeUpdate(sqlB.toString(), this.trxName);
                if (no == -1) {
                    this.log.info("Update to package summary failed");
                }
            }
            Env.setContext(this.context, "AD_Package_Imp_ID", this.AD_Package_Imp_ID);
            Env.setContext(this.context, "UpdateMode", this.updateMode);
            Env.setContext(this.context, "TrxName", this.trxName);
            Env.setContext(this.context, "SynchronizeColumns", this.synchronizeColumns);
            Env.setContext(this.context, "PackageDirectory", this.packageDirectory);
            this.context.put("LogDocument", this.logDocument);
            this.context.put("PackInProcess", this.packIn);
        }
        Element e = new Element(uri, localName, qName, new AttributesImpl(atts));
        if (this.stack.size() > 0) {
            e.parent = this.stack.peek();
        }
        this.stack.push(e);
        if (((String)elementValue).startsWith("GenericPO_AD_Workflow")) {
            this.workflow.add(e);
        }
        if (((String)elementValue).equals("GenericPO_AD_Column")) {
            this.columns.add(e);
        }
        if ((handler = PackinCustomHandler.getInstance().getHandler((String)elementValue)) == null && ((String)elementValue).startsWith("GenericPO")) {
            handler = new GenericPOHandler();
        }
        if (handler != null) {
            handler.startElement(this.context, e);
        }
        if (e.defer) {
            this.defer.add(new DeferEntry(e, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createImp_Sum_table(String tablename) {
        Connection conn = DB.getConnectionRW();
        ResultSet tables = null;
        DatabaseMetaData dbm = conn.getMetaData();
        if (this.databaseType.equals("Oracle")) {
            tables = dbm.getTables(null, null, tablename.toUpperCase(), null);
        } else if (this.databaseType.equals("PostgreSQL")) {
            tables = dbm.getTables(null, null, tablename.toLowerCase(), null);
        }
        if (tables.next()) {
            this.log.info("Table Found");
        } else {
            CPreparedStatement pstmt;
            StringBuffer sqlB;
            if (tablename.equals("AD_Package_Imp")) {
                sqlB = new StringBuffer("CREATE TABLE " + tablename.toUpperCase() + "( ").append(tablename.toUpperCase() + "_ID   NUMBER(10) NOT NULL, ").append("AD_CLIENT_ID NUMBER(10) NOT NULL, ").append("AD_ORG_ID  NUMBER(10) NOT NULL, ").append("ISACTIVE CHAR(1) DEFAULT 'Y' NOT NULL, ").append("CREATED DATE DEFAULT SYSDATE NOT NULL, ").append("CREATEDBY NUMBER(10) NOT NULL, ").append("UPDATED DATE DEFAULT SYSDATE NOT NULL, ").append("UPDATEDBY NUMBER(10) NOT NULL, ").append("NAME NVARCHAR2(60) NOT NULL, ").append("PK_STATUS NVARCHAR2(22), ").append("RELEASENO NVARCHAR2(20), ").append("PK_VERSION NVARCHAR2(20), ").append("VERSION NVARCHAR2(20), ").append("DESCRIPTION NVARCHAR2(1000) NOT NULL, ").append("EMAIL NVARCHAR2(60), ").append("PROCESSED CHAR(1) DEFAULT 'N', ").append("PROCESSING CHAR(1) DEFAULT 'N', ").append("CREATOR VARCHAR2(60 ), ").append("CREATORCONTACT VARCHAR2(255), ").append(" CREATEDDATE  VARCHAR2(25), ").append("UPDATEDDATE VARCHAR2(25), ").append("PRIMARY KEY( " + tablename.toUpperCase() + "_ID))");
                pstmt = null;
                try {
                    pstmt = DB.prepareStatement(sqlB.toString(), 1003, 1008, null);
                    pstmt.executeUpdate();
                    MSequence.createTableSequence(this.context, "AD_Package_Imp", this.trxName);
                }
                catch (Exception e) {
                    try {
                        this.log.info("createImp_Sum_table:" + e);
                    }
                    catch (Throwable throwable) {
                        DB.close(pstmt);
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(pstmt);
                    pstmt = null;
                }
                DB.close(pstmt);
                pstmt = null;
            }
            if (tablename.equals("AD_Package_Imp_Inst")) {
                sqlB = new StringBuffer("CREATE TABLE " + tablename.toUpperCase() + "( ").append(tablename.toUpperCase() + "_ID   NUMBER(10) NOT NULL, ").append("AD_CLIENT_ID NUMBER(10) NOT NULL, ").append("AD_ORG_ID  NUMBER(10) NOT NULL, ").append("ISACTIVE CHAR(1) DEFAULT 'Y' NOT NULL, ").append("CREATED DATE DEFAULT SYSDATE NOT NULL, ").append("CREATEDBY NUMBER(10) NOT NULL, ").append("UPDATED DATE DEFAULT SYSDATE NOT NULL, ").append("UPDATEDBY NUMBER(10) NOT NULL, ").append("NAME NVARCHAR2(60) NOT NULL, ").append("PK_STATUS NVARCHAR2(22), ").append("RELEASENO NVARCHAR2(20), ").append("PK_VERSION NVARCHAR2(20), ").append("VERSION NVARCHAR2(20), ").append("DESCRIPTION NVARCHAR2(1000) NOT NULL, ").append("EMAIL NVARCHAR2(60), ").append("PROCESSED CHAR(1) DEFAULT 'N', ").append("PROCESSING CHAR(1) DEFAULT 'N', ").append("CREATOR VARCHAR2(60 ), ").append("CREATORCONTACT VARCHAR2(255), ").append(" CREATEDDATE  VARCHAR2(25), ").append("UPDATEDDATE VARCHAR2(25), ").append("PRIMARY KEY( " + tablename.toUpperCase() + "_ID))");
                pstmt = null;
                try {
                    pstmt = DB.prepareStatement(sqlB.toString(), 1003, 1008, null);
                    pstmt.executeUpdate();
                    MSequence.createTableSequence(this.context, "AD_Package_Imp_Inst", this.trxName);
                }
                catch (Exception e) {
                    this.log.info("createImp_Sum_table:" + e);
                }
                finally {
                    DB.close(pstmt);
                    pstmt = null;
                }
            }
            if (tablename.equals("AD_Package_Imp_Detail")) {
                sqlB = new StringBuffer("CREATE TABLE " + tablename.toUpperCase() + "( ").append(tablename.toUpperCase() + "_ID   NUMBER(10) NOT NULL, ").append("AD_CLIENT_ID NUMBER(10) NOT NULL, ").append("AD_ORG_ID  NUMBER(10) NOT NULL, ").append("ISACTIVE CHAR(1) DEFAULT 'Y' NOT NULL, ").append("CREATED DATE DEFAULT SYSDATE NOT NULL, ").append("CREATEDBY NUMBER(10) NOT NULL, ").append("UPDATED DATE DEFAULT SYSDATE NOT NULL, ").append("UPDATEDBY NUMBER(10) NOT NULL, ").append("NAME NVARCHAR2(60), ").append("AD_PACKAGE_IMP_ID Number(10) NOT NULL, ").append("AD_ORIGINAL_ID Number(10) NOT NULL, ").append("AD_BACKUP_ID Number(10), ").append("ACTION NVARCHAR2(20), ").append("SUCCESS NVARCHAR2(20), ").append("TYPE NVARCHAR2(60), ").append("TABLENAME NVARCHAR2(60), ").append("AD_TABLE_ID NUMBER(10), ").append("UNINSTALL CHAR(1), ").append("PRIMARY KEY( " + tablename.toUpperCase() + "_ID))");
                pstmt = null;
                try {
                    pstmt = DB.prepareStatement(sqlB.toString(), 1003, 1008, null);
                    pstmt.executeUpdate();
                    MSequence.createTableSequence(this.context, "AD_Package_Imp_Detail", this.trxName);
                }
                catch (Exception e) {
                    try {
                        this.log.info("createImp_Sum_table:" + e);
                    }
                    catch (Throwable throwable) {
                        DB.close(pstmt);
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(pstmt);
                    pstmt = null;
                }
                DB.close(pstmt);
                pstmt = null;
            }
            if (tablename.equals("AD_Package_Imp_Backup")) {
                sqlB = new StringBuffer("CREATE TABLE " + tablename.toUpperCase() + "( ").append(tablename.toUpperCase() + "_ID NUMBER(10) NOT NULL, ").append("AD_CLIENT_ID NUMBER(10) NOT NULL, ").append("AD_ORG_ID  NUMBER(10) NOT NULL, ").append("ISACTIVE CHAR(1) DEFAULT 'Y' NOT NULL, ").append("CREATED DATE DEFAULT SYSDATE NOT NULL, ").append("CREATEDBY NUMBER(10) NOT NULL, ").append("UPDATED DATE DEFAULT SYSDATE NOT NULL, ").append("UPDATEDBY NUMBER(10) NOT NULL, ").append("AD_PACKAGE_IMP_ID Number(10) NOT NULL, ").append("AD_PACKAGE_IMP_DETAIL_ID Number(10) NOT NULL, ").append("AD_TABLE_ID NUMBER(10), ").append("AD_COLUMN_ID NUMBER(10), ").append("AD_REFERENCE_ID NUMBER(10), ").append("AD_PACKAGE_IMP_BCK_DIR NVARCHAR2(255), ").append("AD_PACKAGE_IMP_ORG_DIR NVARCHAR2(255), ").append("COLVALUE NVARCHAR2(2000), ").append("UNINSTALL CHAR(1), ").append("PRIMARY KEY( " + tablename.toUpperCase() + "_ID))");
                pstmt = null;
                try {
                    pstmt = DB.prepareStatement(sqlB.toString(), 1003, 1008, null);
                    pstmt.executeUpdate();
                    MSequence.createTableSequence(this.context, "AD_Package_Imp_Backup", this.trxName);
                }
                catch (Exception e) {
                    this.log.info("createImp_Sum_table:" + e);
                }
                finally {
                    DB.close(pstmt);
                    pstmt = null;
                }
            }
        }
        tables.close();
        DB.close(tables, null);
        tables = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (Exception sqlB) {}
        return;
        catch (SQLException e) {
            this.log.info("createImp_Sum_table:" + e);
            return;
        }
        finally {
            DB.close(tables, null);
            tables = null;
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Object elementValue = null;
        elementValue = "".equals(uri) ? qName : uri + localName;
        if (((String)elementValue).equals("adempiereAD")) {
            Attributes atts;
            StringBuffer sqlB;
            int no;
            this.processDeferElements();
            if (!this.PK_Status.equals("Completed with errors")) {
                this.PK_Status = "Completed successfully";
            }
            if ((no = DB.executeUpdate((sqlB = new StringBuffer("UPDATE AD_Package_Imp SET PK_Status = '" + this.PK_Status + "' WHERE AD_Package_Imp_ID = " + this.AD_Package_Imp_ID)).toString(), this.trxName)) == -1) {
                this.log.info("Update to package summary failed");
            }
            if ((no = DB.executeUpdate((sqlB = new StringBuffer("UPDATE AD_Package_Imp_Inst SET PK_Status = '" + this.PK_Status + "' WHERE AD_Package_Imp_Inst_ID = " + this.AD_Package_Imp_Inst_ID)).toString(), this.trxName)) == -1) {
                this.log.info("Update to package list failed");
            }
            if (this.workflow.size() > 0) {
                for (Element e : this.workflow) {
                    List<MWFNode> nodesList;
                    Optional<MWFNode> optionalNode;
                    atts = e.attributes;
                    String workflowUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_Workflow"));
                    MWorkflow workflow = null;
                    int workflowId = IDFinder.getIdFromUUID(Env.getCtx(), "AD_Workflow", workflowUuid, this.clientId, this.trxName);
                    if (workflowId <= 0) continue;
                    workflow = new MWorkflow(this.context, workflowId, this.trxName);
                    String workFlowNodeUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_WF_Node_ID"));
                    if (Util.isEmpty(workFlowNodeUuid) || !(optionalNode = (nodesList = Arrays.asList(workflow.getNodes(false, this.clientId))).stream().filter(node -> node.getUUID().equals(workFlowNodeUuid)).findFirst()).isPresent()) continue;
                    workflow.setAD_WF_Node_ID(optionalNode.get().getAD_WF_Node_ID());
                    workflow.saveEx();
                }
            }
            if (Env.getContext(this.context, "SynchronizeColumns").equals("Y") && this.columns.size() > 0) {
                for (Element e : this.columns) {
                    MColumn column;
                    atts = e.attributes;
                    String columnUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_Column"));
                    int id = IDFinder.getIdFromUUID(this.context, "AD_Column", columnUuid, 0, this.trxName);
                    if (id <= 0 || (column = new MColumn(this.context, id, this.trxName)).getAD_Table_ID() <= 0) continue;
                    try {
                        column.syncDatabase();
                    }
                    catch (Exception ex) {
                        this.log.warning("SyncDatabase Error: " + e.getElementValue() + " - " + ex.getLocalizedMessage());
                    }
                }
            }
            this.logDocument.endElement("", "", "adempiereDocument");
            this.logDocument.endDocument();
            try {
                this.fw_document.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            PackinCustomHandler.getInstance();
        } else {
            Element e = this.stack.pop();
            if (e.defer) {
                this.defer.add(new DeferEntry(e, false));
            } else {
                ElementHandler handler = PackinCustomHandler.getInstance().getHandler((String)elementValue);
                if (handler != null) {
                    handler.endElement(this.context, e);
                }
                if (e.defer || e.deferEnd) {
                    this.defer.add(new DeferEntry(e, false));
                } else if (!e.skip && this.log.isLoggable(Level.INFO)) {
                    this.log.info("Processed: " + e.getElementValue() + " - " + e.attributes.getValue(0));
                }
            }
        }
    }

    private void processDeferElements() throws SAXException {
        int endSize;
        int startSize;
        if (this.defer.isEmpty()) {
            return;
        }
        do {
            startSize = this.defer.size();
            ArrayList<DeferEntry> tmp = new ArrayList<DeferEntry>(this.defer);
            this.defer.clear();
            for (DeferEntry d : tmp) {
                ElementHandler handler;
                if (d.startElement) {
                    d.element.defer = false;
                    d.element.unresolved = "";
                    ++d.element.pass;
                } else if (d.element.deferEnd) {
                    d.element.deferEnd = false;
                    d.element.unresolved = "";
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Processing Defer Element: " + d.element.getElementValue() + " - " + d.element.attributes.getValue(0));
                }
                if ((handler = PackinCustomHandler.getInstance().getHandler(d.element.getElementValue())) != null) {
                    if (d.startElement) {
                        handler.startElement(this.context, d.element);
                    } else {
                        handler.endElement(this.context, d.element);
                    }
                }
                if (d.element.defer) {
                    this.defer.add(d);
                    continue;
                }
                if (d.startElement) continue;
                if (d.element.deferEnd) {
                    this.defer.add(d);
                    continue;
                }
                if (!this.log.isLoggable(Level.INFO)) continue;
                this.log.info("Imported Defer Element: " + d.element.getElementValue() + " - " + d.element.attributes.getValue(0));
            }
        } while (startSize != (endSize = this.defer.size()) && this.defer.size() > 0);
        if (this.defer.size() > 0) {
            int count = 0;
            for (DeferEntry d : this.defer) {
                if (d.startElement) continue;
                ++count;
                if (!this.log.isLoggable(Level.SEVERE)) continue;
                this.log.severe("Unresolved: " + d.element.getElementValue() + " - " + d.element.attributes.getValue(0) + ", " + d.element.unresolved);
            }
            throw new RuntimeException("Failed to resolve dependency for " + count + " elements.");
        }
    }

    public void set_TrxName(String trxName) {
        this.trxName = trxName;
    }

    public void setCtx(Properties ctx) {
        this.context = ctx;
    }

    public void setProcess(PackIn packIn) {
        this.packIn = packIn;
    }

    class DeferEntry {
        Element element;
        boolean startElement = false;

        DeferEntry(Element e, boolean b) {
            this.element = e;
            this.startElement = b;
        }
    }
}

