/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.adempiere.core.domains.models.I_AD_Menu;
import org.adempiere.core.domains.models.I_ASP_Level;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.process.CreateCustomizationFromASPAbstract;
import org.compiere.model.MBrowseCustom;
import org.compiere.model.MBrowseFieldCustom;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MFieldCustom;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessCustom;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProcessParaCustom;
import org.compiere.model.MTab;
import org.compiere.model.MTabCustom;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.model.MWindowCustom;
import org.compiere.util.DB;

public class CreateCustomizationFromASP
extends CreateCustomizationFromASPAbstract {
    private int noWindows = 0;
    private int noTabs = 0;
    private int noFields = 0;
    private int noProcesses = 0;
    private int noParameters = 0;
    private int noBrowses = 0;
    private int noBrowseFields = 0;
    private int menuId = 0;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTable_ID() == I_AD_Menu.Table_ID) {
            this.menuId = this.getRecord_ID();
        } else if (this.getTable_ID() == I_ASP_Level.Table_ID) {
            this.menuId = this.getParameterAsInt("AD_Menu_ID");
            this.setLevelId(this.getRecord_ID());
        }
    }

    @Override
    protected String doIt() throws Exception {
        MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        int AD_Tree_ID = clientInfo.getAD_Tree_Menu_ID();
        MTree thisTree = new MTree(this.getCtx(), AD_Tree_ID, true, true, null, this.get_TrxName());
        MTreeNode node = this.menuId > 0 ? thisTree.getRoot().findNode(this.menuId) : thisTree.getRoot();
        if (node != null) {
            if (node.isSummary()) {
                Enumeration<TreeNode> en = node.preorderEnumeration();
                while (en.hasMoreElements()) {
                    MTreeNode childNode = (MTreeNode)en.nextElement();
                    if (childNode.isSummary()) continue;
                    this.addNodeToLevel(childNode);
                }
            } else {
                this.addNodeToLevel(node);
            }
        }
        if (this.noWindows > 0) {
            this.addLog("@AD_Window_ID@ (" + this.noWindows + ")");
        }
        if (this.noTabs > 0) {
            this.addLog("@AD_Tab_ID@ (" + this.noTabs + ")");
        }
        if (this.noFields > 0) {
            this.addLog("@AD_Field_ID@ (" + this.noFields + ")");
        }
        if (this.noProcesses > 0) {
            this.addLog("@AD_Process_ID@ (" + this.noProcesses + ")");
        }
        if (this.noParameters > 0) {
            this.addLog("@AD_Process_Para_ID@ (" + this.noParameters + ")");
        }
        if (this.noBrowses > 0) {
            this.addLog("@AD_Browse_ID@ (" + this.noBrowses + ")");
        }
        if (this.noBrowseFields > 0) {
            this.addLog("@AD_Browse_Field_ID@ (" + this.noBrowseFields + ")");
        }
        return "@OK@";
    }

    private void addNodeToLevel(MTreeNode nn) {
        MMenu menu = new MMenu(this.getCtx(), nn.getNode_ID(), this.get_TrxName());
        if (menu.getAction().equals("W")) {
            MWindow window = new MWindow(this.getCtx(), menu.getAD_Window_ID(), this.get_TrxName());
            int customWindowId = DB.getSQLValueEx(this.get_TrxName(), "SELECT AD_WindowCustom_ID FROM AD_WindowCustom WHERE ASP_Level_ID = ? AND AD_Window_ID = ?", this.getRecord_ID(), window.getAD_Window_ID());
            MWindowCustom customWindow = null;
            if (customWindowId < 1) {
                customWindow = new MWindowCustom(this.getCtx(), 0, this.get_TrxName());
                customWindow.setASP_Level_ID(this.getLevelId());
                customWindow.setAD_Window_ID(window.getAD_Window_ID());
                customWindow.setHierarchyType(this.getHierarchyType());
                customWindow.saveEx();
                ++this.noWindows;
                customWindowId = customWindow.getAD_WindowCustom_ID();
            } else {
                customWindow = new MWindowCustom(this.getCtx(), customWindowId, this.get_TrxName());
            }
            for (MTab tab : window.getTabs(true, this.get_TrxName())) {
                int tabId = DB.getSQLValueEx(this.get_TrxName(), "SELECT AD_TabCustom_ID FROM AD_TabCustom WHERE AD_WindowCustom_ID = ? AND AD_Tab_ID = ?", customWindowId, tab.getAD_Tab_ID());
                MTabCustom customTab = null;
                if (tabId < 1) {
                    customTab = new MTabCustom(customWindow);
                    customTab.setAD_Tab_ID(tab.getAD_Tab_ID());
                    customTab.saveEx();
                    ++this.noTabs;
                    tabId = customTab.getAD_TabCustom_ID();
                } else {
                    customTab = new MTabCustom(this.getCtx(), tabId, this.get_TrxName());
                }
                if (!this.isAllFields()) continue;
                for (MField field : tab.getFields(true, this.get_TrxName())) {
                    MColumn column;
                    if (field.isActive() && DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_FieldCustom WHERE AD_TabCustom_ID = ? AND AD_Field_ID = ?", customTab.getAD_TabCustom_ID(), field.getAD_Field_ID()) < 1) {
                        MFieldCustom customField = new MFieldCustom(customTab);
                        customField.setAD_Field_ID(field.getAD_Field_ID());
                        customField.saveEx();
                        ++this.noFields;
                    }
                    if ((column = MColumn.get(this.getCtx(), field.getAD_Column_ID())).getAD_Reference_ID() != 28 || column.getAD_Process_ID() <= 0) continue;
                    this.generateProcess(column.getAD_Process_ID());
                }
            }
        } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
            this.generateProcess(menu.getAD_Process_ID());
        } else if (menu.getAction().equals("S")) {
            MBrowse browse = new MBrowse(this.getCtx(), menu.getAD_Browse_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_BrowseCustom WHERE ASP_Level_ID = ? AND AD_Browse_ID = ?", this.getRecord_ID(), browse.getAD_Browse_ID()) < 1) {
                MBrowseCustom customBrowse = new MBrowseCustom(this.getCtx(), 0, this.get_TrxName());
                customBrowse.setASP_Level_ID(this.getLevelId());
                customBrowse.setAD_Browse_ID(browse.getAD_Browse_ID());
                customBrowse.setHierarchyType(this.getHierarchyType());
                customBrowse.saveEx();
                if (this.isAllFields()) {
                    for (MBrowseField browseField : browse.getFields()) {
                        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_BrowseFieldCustom WHERE AD_BrowseCustom_ID = ? AND AD_Browse_Field_ID = ?", customBrowse.getAD_BrowseCustom_ID(), browseField.getAD_Browse_Field_ID()) >= 1) continue;
                        MBrowseFieldCustom customBrowseField = new MBrowseFieldCustom(customBrowse);
                        customBrowseField.setAD_Browse_Field_ID(browseField.getAD_Browse_Field_ID());
                        customBrowseField.saveEx();
                        ++this.noBrowseFields;
                    }
                }
                ++this.noBrowses;
            }
        }
    }

    private void generateProcess(int processId) {
        MProcess process = new MProcess(this.getCtx(), processId, this.get_TrxName());
        int customprocessId = DB.getSQLValueEx(this.get_TrxName(), "SELECT AD_ProcessCustom_ID FROM AD_ProcessCustom WHERE ASP_Level_ID = ? AND AD_Process_ID = ?", this.getRecord_ID(), process.getAD_Process_ID());
        MProcessCustom customProcess = null;
        if (customprocessId < 1) {
            customProcess = new MProcessCustom(this.getCtx(), 0, this.get_TrxName());
            customProcess.setASP_Level_ID(this.getLevelId());
            customProcess.setAD_Process_ID(process.getAD_Process_ID());
            customProcess.setHierarchyType(this.getHierarchyType());
            customProcess.saveEx();
            ++this.noProcesses;
            customprocessId = customProcess.getAD_ProcessCustom_ID();
        } else {
            customProcess = new MProcessCustom(this.getCtx(), customprocessId, this.get_TrxName());
        }
        if (this.isAllFields()) {
            for (MProcessPara processParameter : process.getParameters()) {
                if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_ProcessParaCustom WHERE AD_ProcessCustom_ID = ? AND AD_Process_Para_ID = ?", customprocessId, processParameter.getAD_Process_Para_ID()) >= 1) continue;
                MProcessParaCustom customProcessPara = new MProcessParaCustom(customProcess);
                customProcessPara.setAD_Process_Para_ID(processParameter.getAD_Process_Para_ID());
                customProcessPara.saveEx();
                ++this.noParameters;
            }
        }
    }
}

