/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_HouseKeeping;
import org.adempiere.model.GenericPO;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class HouseKeeping
extends SvrProcess {
    private int p_AD_HouseKeeping_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameter = this.getParameter();
        for (int i = 0; i < parameter.length; ++i) {
            String name = parameter[i].getParameterName();
            if (parameter[i].getParameter() == null) continue;
            if (name.equals("AD_HouseKeeping_ID")) {
                this.p_AD_HouseKeeping_ID = parameter[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_AD_HouseKeeping_ID == 0) {
            this.p_AD_HouseKeeping_ID = this.getRecord_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        Date date;
        int nodel;
        String whereClause;
        String tableName;
        X_AD_HouseKeeping houseKeeping;
        block12: {
            houseKeeping = new X_AD_HouseKeeping(this.getCtx(), this.p_AD_HouseKeeping_ID, this.get_TrxName());
            int tableID = houseKeeping.getAD_Table_ID();
            MTable table2 = new MTable(this.getCtx(), tableID, this.get_TrxName());
            tableName = table2.getTableName();
            whereClause = houseKeeping.getWhereClause();
            int noins = 0;
            int noexp = 0;
            nodel = 0;
            if (houseKeeping.isSaveInHistoric()) {
                String sql = "INSERT INTO hst_" + tableName + " SELECT * FROM " + tableName;
                if (whereClause != null && whereClause.length() > 0) {
                    sql = sql + " WHERE " + whereClause;
                }
                if ((noins = DB.executeUpdate(sql, this.get_TrxName())) == -1) {
                    throw new AdempiereSystemError("Cannot insert into hst_" + tableName);
                }
                this.addLog("@Inserted@ " + noins);
            }
            date = new Date();
            if (!houseKeeping.isExportXMLBackup()) break block12;
            String pathFile = houseKeeping.getBackupFolder();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateString = dateFormat.format(date);
            FileWriter file = new FileWriter(pathFile + File.separator + tableName + dateString + ".xml");
            String sql = "SELECT * FROM " + tableName;
            if (whereClause != null && whereClause.length() > 0) {
                sql = sql + " WHERE " + whereClause;
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            StringBuffer linexml = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    GenericPO po = new GenericPO(tableName, this.getCtx(), rs, this.get_TrxName());
                    linexml = po.get_xmlString(linexml);
                    ++noexp;
                }
                if (linexml != null) {
                    file.write(linexml.toString());
                }
                file.close();
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
            this.addLog("@Exported@ " + noexp);
        }
        String sql = "DELETE FROM " + tableName;
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause;
        }
        if ((nodel = DB.executeUpdate(sql, this.get_TrxName())) == -1) {
            throw new AdempiereSystemError("Cannot delete from " + tableName);
        }
        Timestamp time = new Timestamp(date.getTime());
        houseKeeping.setLastRun(time);
        houseKeeping.setLastDeleted(nodel);
        houseKeeping.saveEx();
        this.addLog("@Deleted@ " + nodel);
        String msg = Msg.translate(this.getCtx(), tableName + "_ID") + " #" + nodel;
        return msg;
    }
}

