/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_I_PriceList;
import org.adempiere.core.domains.models.X_M_ProductPriceVendorBreak;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportPriceList
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private boolean p_importPriceList = true;
    private boolean p_importPriceStd = true;
    private boolean p_importPriceLimit = true;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsImportPriceList")) {
                this.p_importPriceList = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsImportPriceStd")) {
                this.p_importPriceStd = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("IsImportPriceLimit")) {
                this.p_importPriceLimit = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.m_AD_Client_ID;
        int m_discountschema_id = DB.getSQLValue(this.get_TrxName(), "SELECT MIN(M_DiscountSchema_ID) FROM M_DiscountSchema WHERE DiscountType='P' AND IsActive='Y' AND AD_Client_ID=?", this.m_AD_Client_ID);
        if (m_discountschema_id <= 0) {
            throw new AdempiereUserError("Price List Schema not configured");
        }
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_PriceList WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.info("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_PriceList SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), EnforcePriceLimit = COALESCE (EnforcePriceLimit, 'N'), IsSOPriceList = COALESCE (IsSOPriceList, 'N'), IsTaxIncluded = COALESCE (IsTaxIncluded, 'N'), PricePrecision = COALESCE (PricePrecision, 2), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE I_PriceList.BPartner_Value=p.Value AND I_PriceList.AD_Client_ID=p.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("BPartner=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid BPartner,' WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid BPartner=" + no);
        }
        sql = new StringBuffer("UPDATE I_PriceList SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE I_PriceList.ProductValue=p.Value AND I_PriceList.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' WHERE M_Product_ID IS NULL AND (ProductValue IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Product=" + no);
        }
        sql = new StringBuffer("UPDATE I_PriceList SET M_PriceList_ID=(SELECT M_PriceList_ID FROM M_PriceList p WHERE I_PriceList.Name=p.Name AND I_PriceList.AD_Client_ID=p.AD_Client_ID) WHERE M_PriceList_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Price List Existing Value=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET M_PriceList_Version_ID=(SELECT M_PriceList_Version_ID FROM M_PriceList_Version p WHERE I_PriceList.ValidFrom=p.ValidFrom AND I_PriceList.M_PriceList_ID=p.M_PriceList_ID) WHERE M_PriceList_ID IS NOT NULL AND M_PriceList_Version_ID IS NULL AND I_IsImported='N'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Price List Version Existing Value=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET ISO_Code=(SELECT ISO_Code FROM C_Currency c INNER JOIN C_AcctSchema a ON (a.C_Currency_ID=c.C_Currency_ID) INNER JOIN AD_ClientInfo ci ON (a.C_AcctSchema_ID=ci.C_AcctSchema1_ID) WHERE ci.AD_Client_ID=I_PriceList.AD_Client_ID) WHERE C_Currency_ID IS NULL AND ISO_Code IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Currency Default=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET C_Currency_ID=(SELECT C_Currency_ID FROM C_Currency c WHERE I_PriceList.ISO_Code=c.ISO_Code AND c.AD_Client_ID IN (0,I_PriceList.AD_Client_ID)) WHERE C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("doIt- Set Currency=" + no);
        sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Currency,' WHERE C_Currency_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Currency=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Mandatory Name or PriceListID,' WHERE Name IS NULL AND M_PriceList_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Mandatory Name=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Mandatory ValidFrom or PriceListVersionID,' WHERE ValidFrom IS NULL AND M_PriceList_Version_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Mandatory ValidFrom=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Mandatory BreakValue,' WHERE BreakValue IS NULL AND (C_BPartner_ID IS NOT NULL OR BPartner_Value IS NOT NULL) AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Mandatory BreakValue=" + no);
        }
        this.commitEx();
        int noInsertpp = 0;
        int noUpdatepp = 0;
        int noInsertppvb = 0;
        int noUpdateppvb = 0;
        int noInsertpl = 0;
        int noInsertplv = 0;
        this.log.fine("start inserting/updating ...");
        sql = new StringBuffer("SELECT * FROM I_PriceList WHERE I_IsImported='N'").append(clientCheck);
        CPreparedStatement pstmt_setImported = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt_setImported = DB.prepareStatement("UPDATE I_PriceList SET I_IsImported='Y', M_PriceList_ID=?, M_PriceList_Version_ID=?, Updated=SysDate, Processed='Y' WHERE I_PriceList_ID=?", this.get_TrxName());
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int M_PriceList_Version_ID;
                int M_PriceList_ID;
                int I_PriceList_ID;
                block40: {
                    MPriceListVersion pricelistversion;
                    X_I_PriceList imp;
                    block39: {
                        MPriceList pricelist;
                        block38: {
                            imp = new X_I_PriceList(this.getCtx(), rs, this.get_TrxName());
                            I_PriceList_ID = imp.getI_PriceList_ID();
                            M_PriceList_ID = imp.getM_PriceList_ID();
                            if (M_PriceList_ID == 0 && (M_PriceList_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM M_PriceList WHERE IsActive='Y' AND AD_Client_ID=? AND Name=?", this.m_AD_Client_ID, imp.getName())) < 0) {
                                M_PriceList_ID = 0;
                            }
                            boolean newPriceList = M_PriceList_ID == 0;
                            this.log.fine("I_PriceList_ID=" + I_PriceList_ID + ", M_PriceList_ID=" + M_PriceList_ID);
                            pricelist = null;
                            if (newPriceList) {
                                pricelist = new MPriceList(imp);
                                if (pricelist.save()) {
                                    M_PriceList_ID = pricelist.getM_PriceList_ID();
                                    this.log.finer("Insert Price List");
                                    ++noInsertpl;
                                    break block38;
                                } else {
                                    StringBuffer sql0 = new StringBuffer("UPDATE I_PriceList i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Insert Price List failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                                    DB.executeUpdate(sql0.toString(), this.get_TrxName());
                                    continue;
                                }
                            }
                            pricelist = new MPriceList(this.getCtx(), M_PriceList_ID, this.get_TrxName());
                        }
                        M_PriceList_Version_ID = imp.getM_PriceList_Version_ID();
                        if (M_PriceList_Version_ID == 0 && (M_PriceList_Version_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_Version_ID FROM M_PriceList_Version WHERE IsActive='Y' AND ValidFrom=? AND M_PriceList_ID=?", imp.getValidFrom(), M_PriceList_ID)) < 0) {
                            M_PriceList_Version_ID = 0;
                        }
                        boolean newPriceListVersion = M_PriceList_Version_ID == 0;
                        this.log.fine("I_PriceList_ID=" + I_PriceList_ID + ", M_PriceList_Version_ID=" + M_PriceList_Version_ID);
                        pricelistversion = null;
                        if (newPriceListVersion) {
                            pricelistversion = new MPriceListVersion(pricelist);
                            pricelistversion.setValidFrom(imp.getValidFrom());
                            pricelistversion.setName(pricelist.getName() + " " + imp.getValidFrom());
                            pricelistversion.setM_DiscountSchema_ID(m_discountschema_id);
                            if (pricelistversion.save()) {
                                M_PriceList_Version_ID = pricelistversion.getM_PriceList_Version_ID();
                                this.log.finer("Insert Price List Version");
                                ++noInsertplv;
                                break block39;
                            } else {
                                StringBuffer sql0 = new StringBuffer("UPDATE I_PriceList i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Insert Price List Version failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                                DB.executeUpdate(sql0.toString(), this.get_TrxName());
                                continue;
                            }
                        }
                        pricelistversion = new MPriceListVersion(this.getCtx(), M_PriceList_Version_ID, this.get_TrxName());
                    }
                    if (imp.getC_BPartner_ID() > 0) {
                        int M_ProductPriceVendorBreak_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_ProductPriceVendorBreak_ID FROM M_ProductPriceVendorBreak WHERE M_PriceList_Version_ID=? AND IsActive='Y' AND C_BPartner_ID=? AND M_Product_ID=? AND BreakValue=?", pricelistversion.getM_PriceList_Version_ID(), imp.getC_BPartner_ID(), imp.getM_Product_ID(), imp.getBreakValue());
                        if (M_ProductPriceVendorBreak_ID < 0) {
                            M_ProductPriceVendorBreak_ID = 0;
                        }
                        X_M_ProductPriceVendorBreak ppvb = new X_M_ProductPriceVendorBreak(this.getCtx(), M_ProductPriceVendorBreak_ID, this.get_TrxName());
                        boolean isInsert = false;
                        if (M_ProductPriceVendorBreak_ID == 0) {
                            ppvb.setM_PriceList_Version_ID(pricelistversion.getM_PriceList_Version_ID());
                            ppvb.setC_BPartner_ID(imp.getC_BPartner_ID());
                            ppvb.setM_Product_ID(imp.getM_Product_ID());
                            ppvb.setBreakValue(imp.getBreakValue());
                            isInsert = true;
                        }
                        if (this.p_importPriceLimit) {
                            ppvb.setPriceLimit(imp.getPriceLimit());
                        }
                        if (this.p_importPriceList) {
                            ppvb.setPriceList(imp.getPriceList());
                        }
                        if (this.p_importPriceStd) {
                            ppvb.setPriceStd(imp.getPriceStd());
                        }
                        if (ppvb.save()) {
                            if (isInsert) {
                                ++noInsertppvb;
                            } else {
                                ++noUpdateppvb;
                            }
                            this.log.finer("Insert/Update Product Price Vendor Break");
                            break block40;
                        } else {
                            StringBuffer sql0 = new StringBuffer("UPDATE I_PriceList i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Insert/Update Product Price Vendor Break Version failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                            DB.executeUpdate(sql0.toString(), this.get_TrxName());
                            continue;
                        }
                    }
                    MProductPrice pp = MProductPrice.get(this.getCtx(), pricelistversion.getM_PriceList_Version_ID(), imp.getM_Product_ID(), this.get_TrxName());
                    boolean isInsert = false;
                    if (pp != null) {
                        if (this.p_importPriceLimit) {
                            pp.setPriceLimit(imp.getPriceLimit());
                        }
                        if (this.p_importPriceList) {
                            pp.setPriceList(imp.getPriceList());
                        }
                        if (this.p_importPriceStd) {
                            pp.setPriceStd(imp.getPriceStd());
                        }
                    } else {
                        pp = new MProductPrice(pricelistversion, imp.getM_Product_ID(), this.p_importPriceList ? imp.getPriceList() : Env.ZERO, this.p_importPriceStd ? imp.getPriceStd() : Env.ZERO, this.p_importPriceLimit ? imp.getPriceLimit() : Env.ZERO);
                        isInsert = true;
                    }
                    if (pp.save()) {
                        this.log.finer("Insert/Update Product Price");
                        if (isInsert) {
                            ++noInsertpp;
                        } else {
                            ++noUpdatepp;
                        }
                    } else {
                        StringBuffer sql0 = new StringBuffer("UPDATE I_PriceList i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append(DB.TO_STRING("Insert/Update Product Price failed")).append("WHERE I_PriceList_ID=").append(I_PriceList_ID);
                        DB.executeUpdate(sql0.toString(), this.get_TrxName());
                        continue;
                    }
                }
                pstmt_setImported.setInt(1, M_PriceList_ID);
                pstmt_setImported.setInt(2, M_PriceList_Version_ID);
                pstmt_setImported.setInt(3, I_PriceList_ID);
                no = pstmt_setImported.executeUpdate();
                this.commitEx();
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            DB.close(pstmt_setImported);
            pstmt_setImported = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        DB.close(pstmt_setImported);
        pstmt_setImported = null;
        sql = new StringBuffer("UPDATE I_PriceList SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsertpl), "@M_PriceList_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertplv), "@M_PriceList_Version_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertpp), "Product Price: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdatepp), "Product Price: @Updated@");
        this.addLog(0, null, new BigDecimal(noInsertppvb), "@M_ProductPriceVendorBreak_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdateppvb), "@M_ProductPriceVendorBreak_ID@: @Updated@");
        return "";
    }
}

