/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import org.compiere.model.MTable;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class DeleteEntitiesModel {
    private boolean isMandatoryLink;
    private int clientId;
    private int tableId;
    private int parentTableId;
    private int count;
    private String tableName;
    private String keyColumn;
    private String joinColumn;
    private String parentTableName;
    private String parentColumn;
    private String whereClause;

    public DeleteEntitiesModel() {
        this.count = -1;
    }

    public DeleteEntitiesModel(int clientId, int tableId) {
        if (tableId > 0) {
            MTable table2 = MTable.get(Env.getCtx(), tableId);
            this.clientId = clientId;
            this.tableId = tableId;
            this.tableName = table2.getTableName();
            this.isMandatoryLink = true;
            String[] keyColumns = table2.getKeyColumns();
            this.joinColumn = keyColumns != null && keyColumns.length > 0 ? keyColumns[0] : "";
            this.createWhereClause(null);
        }
        this.count = -1;
    }

    public DeleteEntitiesModel(int clientId, int tableId, String tableName, String joinColumn, boolean isMandatoryLink, DeleteEntitiesModel parentNode) {
        this.clientId = clientId;
        this.tableId = tableId;
        this.tableName = tableName;
        this.joinColumn = joinColumn;
        this.isMandatoryLink = isMandatoryLink;
        this.createWhereClause(parentNode);
        this.count = -1;
    }

    private void createWhereClause(DeleteEntitiesModel parentNode) {
        if (parentNode != null) {
            this.whereClause = "EXISTS (SELECT 1 FROM " + parentNode.getTableName() + " WHERE " + parentNode.getTableName() + "." + parentNode.getTableName() + "_ID = " + this.getTableName() + "." + this.getJoinColumn() + " AND " + parentNode.getWhereClause() + ") ";
        } else {
            this.whereClause = this.getTableName() + ".AD_Client_ID = " + this.getClientId();
            if (this.getTableName().equals("AD_User")) {
                this.appeandWhereClause("NOT EXISTS (SELECT 1 FROM C_BPartner bp WHERE AD_User.Link_BPartner_ID = bp.C_BPartner_ID AND (bp.IsEmployee='Y' OR bp.IsSalesRep='Y'))");
            }
        }
    }

    public void appeandWhereClause(String whereClause) {
        if (whereClause == null) {
            return;
        }
        this.whereClause = this.whereClause + " AND " + whereClause;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getJoinColumn() {
        return this.joinColumn;
    }

    public String getParentTableName() {
        return this.parentTableName;
    }

    public int getParentTableId() {
        return this.parentTableId;
    }

    public String getParentColumn() {
        return this.parentColumn;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public boolean isMandatoryLink() {
        return this.isMandatoryLink;
    }

    public String getKeyColumnForTable() {
        return this.tableName + "_ID";
    }

    public int getCount() {
        if (this.count == -1) {
            this.count = DB.getSQLValue(null, "SELECT COUNT(*) FROM " + this.tableName + " WHERE " + this.whereClause);
        }
        return this.count;
    }

    public int delete(Trx m_trx) {
        String sql = this.isMandatoryLink ? "DELETE FROM " + this.tableName + " WHERE " + this.whereClause : "UPDATE " + this.tableName + " SET " + this.joinColumn + " = NULL  WHERE " + this.whereClause;
        int count = DB.executeUpdateEx(sql, m_trx.getTrxName());
        return count;
    }

    public String toString() {
        return (this.tableName == null ? "" : this.tableName) + (String)(this.joinColumn == null ? "" : "." + this.joinColumn) + " (" + this.getCount() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteEntitiesModel other = (DeleteEntitiesModel)obj;
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }
}

