/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.util.Env;

public class Doc_Inventory
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Inventory(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInventory.class, rs, "MMI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInventory inventory = (MInventory)this.getPO();
        this.setDateDoc(inventory.getMovementDate());
        this.setDateAcct(inventory.getMovementDate());
        this.m_Reversal_ID = inventory.getReversal_ID();
        this.m_DocStatus = inventory.getDocStatus();
        this.p_lines = this.loadLines(inventory);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MInventory inventory) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInventoryLine[] lines = inventory.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MInventoryLine line = lines[i2];
            if (line.getQtyBook().compareTo(line.getQtyCount()) == 0 && line.getQtyInternalUse().signum() == 0) continue;
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQtyInternalUse();
            if (Qty.signum() != 0) {
                Qty = Qty.negate();
            } else {
                BigDecimal QtyBook = line.getQtyBook();
                BigDecimal QtyCount = line.getQtyCount();
                Qty = QtyCount.subtract(QtyBook);
            }
            docLine.setQty(Qty, false);
            docLine.setReversalLine_ID(line.getReversalLine_ID());
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        BigDecimal total = Env.ZERO;
        for (int i2 = 0; i2 < this.p_lines.length; ++i2) {
            DocLine line = this.p_lines[i2];
            BigDecimal costs = Env.ZERO;
            for (MCostDetail cost : line.getCostDetail(as, false)) {
                if (!MCostDetail.existsCost(cost)) continue;
                String description = cost.getM_CostElement().getName() + " " + cost.getM_CostType().getName();
                costs = line.getQty().signum() < 0 ? MCostDetail.getTotalCost(cost, as).negate() : MCostDetail.getTotalCost(cost, as);
                total = total.add(costs);
                dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
                if (dr == null) continue;
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.addDescription(description);
                dr.setM_Product_ID(cost.getM_Product_ID());
                dr.setQty(cost.getQty());
                if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInventory.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty(), Env.ONE.negate())) {
                    this.p_Error = "Original Physical Inventory not posted yet";
                    return null;
                }
                MAccount invDiff = null;
                invDiff = this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && line.getC_Charge_ID() != 0 ? line.getChargeAccount(as, costs) : line.getChargeAccount(as, costs.negate());
                if (invDiff == null) {
                    invDiff = this.getAccount(50, as);
                }
                if ((cr = fact.createLine(line, invDiff, as.getC_Currency_ID(), costs.negate())) == null) continue;
                cr.setM_Locator_ID(line.getM_Locator_ID());
                cr.setM_Product_ID(cost.getM_Product_ID());
                cr.setQty(cost.getQty().negate());
                if (line.getC_Charge_ID() != 0) {
                    cr.setAD_Org_ID(line.getAD_Org_ID());
                }
                if (this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0) continue;
                if (!cr.updateReverseLine(MInventory.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty().negate(), Env.ONE.negate())) {
                    this.p_Error = "Original Physical Inventory not posted yet";
                    return null;
                }
                costs = cr.getAcctBalance();
            }
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    public static String getDateAcctColumnName() {
        return "MovementDate";
    }
}

