/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_LandedCostAllocation;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostType;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MTax;
import org.compiere.model.ProductCost;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_Invoice
extends Doc {
    private DocTax[] m_taxes = null;
    private int m_precision = -1;
    private boolean m_allLinesService = true;
    private boolean m_allLinesItem = true;

    public Doc_Invoice(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInvoice.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MInvoice invoice = (MInvoice)this.getPO();
        this.setDateDoc(invoice.getDateInvoiced());
        this.setIsTaxIncluded(invoice.isTaxIncluded());
        this.setAmount(0, invoice.getGrandTotal());
        this.setAmount(1, invoice.getTotalLines());
        this.setAmount(2, invoice.getChargeAmt());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(invoice);
        this.log.fine("Lines=" + this.p_lines.length + ", Taxes=" + this.m_taxes.length);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_InvoiceTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, this.get_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Tax_ID = rs.getInt(1);
                String name = rs.getString(2);
                BigDecimal rate = rs.getBigDecimal(3);
                BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                BigDecimal amount = rs.getBigDecimal(5);
                boolean salesTax = "Y".equals(rs.getString(6));
                DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                this.log.fine(taxLine.toString());
                list.add(taxLine);
            }
        }
        catch (SQLException e) {
            DocTax[] docTaxArray;
            try {
                this.log.log(Level.SEVERE, sql, e);
                docTaxArray = null;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return docTaxArray;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    private DocLine[] loadLines(MInvoice invoice) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInvoiceLine[] lines = invoice.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MTax tax;
            MInvoiceLine line = lines[i2];
            if (line.isDescription()) continue;
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQtyInvoiced();
            boolean cm = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
            docLine.setQty(cm ? Qty.negate() : Qty, invoice.isSOTrx());
            BigDecimal LineNetAmt = line.getLineNetAmt();
            BigDecimal PriceList = line.getPriceList();
            int C_Tax_ID = docLine.getC_Tax_ID();
            if (this.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPrecision());
                this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                for (int t = 0; t < this.m_taxes.length; ++t) {
                    if (this.m_taxes[t].getC_Tax_ID() != C_Tax_ID) continue;
                    this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                    break;
                }
                BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPrecision());
                PriceList = PriceList.subtract(PriceListTax);
            }
            docLine.setAmount(LineNetAmt, PriceList, Qty);
            if (docLine.isItem()) {
                this.m_allLinesService = false;
            } else {
                this.m_allLinesItem = false;
            }
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        if (this.isTaxIncluded()) {
            block2: for (int i3 = 0; i3 < this.m_taxes.length; ++i3) {
                if (!this.m_taxes[i3].isIncludedTaxDifference()) continue;
                BigDecimal diff = this.m_taxes[i3].getIncludedTaxDifference();
                for (int j = 0; j < dls.length; ++j) {
                    if (dls[j].getC_Tax_ID() != this.m_taxes[i3].getC_Tax_ID()) continue;
                    dls[j].setLineNetAmtDifference(diff);
                    continue block2;
                }
            }
        }
        return dls;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    @Override
    public BigDecimal getBalance() {
        int i2;
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        for (i2 = 0; i2 < this.m_taxes.length; ++i2) {
            retValue = retValue.subtract(this.m_taxes[i2].getAmount());
            sb.append("-").append(this.m_taxes[i2].getAmount());
        }
        for (i2 = 0; i2 < this.p_lines.length; ++i2) {
            retValue = retValue.subtract(this.p_lines[i2].getAmtSource());
            sb.append("-").append(this.p_lines[i2].getAmtSource());
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema acctSchema) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, acctSchema, "A");
        if (!acctSchema.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("ARI") || this.getDocumentType().equals("ARF")) {
            int i2;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, acctSchema), this.getC_Currency_ID(), null, amt);
            }
            for (i2 = 0; i2 < this.m_taxes.length; ++i2) {
                FactLine tl;
                amt = this.m_taxes[i2].getAmount();
                if (amt == null || (tl = fact.createLine(null, this.m_taxes[i2].getAccount(0, acctSchema), this.getC_Currency_ID(), null, amt)) == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i2].getC_Tax_ID());
            }
            for (i2 = 0; i2 < this.p_lines.length; ++i2) {
                BigDecimal discount;
                amt = this.p_lines[i2].getAmtSource();
                BigDecimal dAmt = null;
                if (acctSchema.isTradeDiscountPosted() && (discount = this.p_lines[i2].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i2], this.p_lines[i2].getAccount(8, acctSchema), this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(this.p_lines[i2], this.p_lines[i2].getAccount(1, acctSchema), this.getC_Currency_ID(), null, amt);
                if (this.p_lines[i2].isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i3 = 0; i3 < fLines.length; ++i3) {
                if (fLines[i3] == null) continue;
                fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), true);
                fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
            }
            int receivablesId = this.getValidCombinationId(1, acctSchema);
            int receivablesServicesId = this.getValidCombinationId(4, acctSchema);
            if (this.m_allLinesItem || !acctSchema.isPostServices() || receivablesId == receivablesServicesId) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), receivablesId, this.getTrxName()), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), receivablesServicesId, this.getTrxName()), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else if (this.getDocumentType().equals("ARC")) {
            int i4;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, acctSchema), this.getC_Currency_ID(), amt, null);
            }
            for (i4 = 0; i4 < this.m_taxes.length; ++i4) {
                FactLine tl;
                amt = this.m_taxes[i4].getAmount();
                if (amt == null || (tl = fact.createLine(null, this.m_taxes[i4].getAccount(0, acctSchema), this.getC_Currency_ID(), amt, null)) == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i4].getC_Tax_ID());
            }
            for (i4 = 0; i4 < this.p_lines.length; ++i4) {
                BigDecimal discount;
                amt = this.p_lines[i4].getAmtSource();
                BigDecimal dAmt = null;
                if (acctSchema.isTradeDiscountPosted() && (discount = this.p_lines[i4].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i4], this.p_lines[i4].getAccount(8, acctSchema), this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(this.p_lines[i4], this.p_lines[i4].getAccount(1, acctSchema), this.getC_Currency_ID(), amt, null);
                if (this.p_lines[i4].isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i5 = 0; i5 < fLines.length; ++i5) {
                if (fLines[i5] == null) continue;
                fLines[i5].setLocationFromOrg(fLines[i5].getAD_Org_ID(), true);
                fLines[i5].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
            }
            int receivablesId = this.getValidCombinationId(1, acctSchema);
            int receivablesServicesId = this.getValidCombinationId(4, acctSchema);
            if (this.m_allLinesItem || !acctSchema.isPostServices() || receivablesId == receivablesServicesId) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), receivablesId, this.getTrxName()), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), receivablesServicesId, this.getTrxName()), this.getC_Currency_ID(), null, serviceAmt);
            }
        } else if (this.getDocumentType().equals("API")) {
            int i6;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, acctSchema), this.getC_Currency_ID(), this.getAmount(2), null);
            for (i6 = 0; i6 < this.m_taxes.length; ++i6) {
                FactLine tl = this.m_taxes[i6].getRate().signum() >= 0 ? fact.createLine(null, this.m_taxes[i6].getAccount(this.m_taxes[i6].getAPTaxType(), acctSchema), this.getC_Currency_ID(), this.m_taxes[i6].getAmount(), null) : fact.createLine(null, this.m_taxes[i6].getAccount(this.m_taxes[i6].getAPTaxType(), acctSchema), this.getC_Currency_ID(), null, this.m_taxes[i6].getAmount().negate());
                if (tl == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i6].getC_Tax_ID());
            }
            for (i6 = 0; i6 < this.p_lines.length; ++i6) {
                BigDecimal discount;
                DocLine line = this.p_lines[i6];
                boolean landedCost = this.landedCost(acctSchema, fact, line, true);
                if (landedCost && acctSchema.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, acctSchema), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, acctSchema), this.getC_Currency_ID(), null, line.getAmtSource());
                    Object desc = line.getDescription();
                    desc = desc == null ? "100%" : (String)desc + " 100%";
                    fl.setDescription((String)desc);
                }
                if (landedCost) continue;
                MAccount expense = line.getAccount(2, acctSchema);
                if (line.isItem()) {
                    expense = line.getAccount(10, acctSchema);
                }
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (acctSchema.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    MAccount tradeDiscountReceived = line.getAccount(7, acctSchema);
                    fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                if (line.isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i7 = 0; i7 < fLines.length; ++i7) {
                if (fLines[i7] == null) continue;
                fLines[i7].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i7].setLocationFromOrg(fLines[i7].getAD_Org_ID(), false);
            }
            int payablesId = this.getValidCombinationId(2, acctSchema);
            int payablesServicesId = this.getValidCombinationId(3, acctSchema);
            if (this.m_allLinesItem || !acctSchema.isPostServices() || payablesId == payablesServicesId) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), payablesId, this.getTrxName()), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), payablesServicesId, this.getTrxName()), this.getC_Currency_ID(), null, serviceAmt);
            }
            this.updateProductPO(acctSchema);
            this.updateProductInfo(acctSchema.getC_AcctSchema_ID());
        } else if (this.getDocumentType().equals("APC")) {
            int i8;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, acctSchema), this.getC_Currency_ID(), null, this.getAmount(2));
            for (i8 = 0; i8 < this.m_taxes.length; ++i8) {
                FactLine tl = this.m_taxes[i8].getRate().signum() >= 0 ? fact.createLine(null, this.m_taxes[i8].getAccount(this.m_taxes[i8].getAPTaxType(), acctSchema), this.getC_Currency_ID(), null, this.m_taxes[i8].getAmount()) : fact.createLine(null, this.m_taxes[i8].getAccount(this.m_taxes[i8].getAPTaxType(), acctSchema), this.getC_Currency_ID(), this.m_taxes[i8].getAmount().negate(), null);
                if (tl == null) continue;
                tl.setC_Tax_ID(this.m_taxes[i8].getC_Tax_ID());
            }
            for (i8 = 0; i8 < this.p_lines.length; ++i8) {
                BigDecimal discount;
                DocLine line = this.p_lines[i8];
                boolean landedCost = this.landedCost(acctSchema, fact, line, false);
                if (landedCost && acctSchema.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, acctSchema), this.getC_Currency_ID(), null, line.getAmtSource());
                    FactLine fl = fact.createLine(line, line.getAccount(2, acctSchema), this.getC_Currency_ID(), line.getAmtSource(), null);
                    Object desc = line.getDescription();
                    desc = desc == null ? "100%" : (String)desc + " 100%";
                    fl.setDescription((String)desc);
                }
                if (landedCost) continue;
                MAccount expense = line.getAccount(2, acctSchema);
                if (line.isItem()) {
                    expense = line.getAccount(10, acctSchema);
                }
                BigDecimal amt = line.getAmtSource();
                BigDecimal dAmt = null;
                if (acctSchema.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    MAccount tradeDiscountReceived = line.getAccount(7, acctSchema);
                    fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                if (line.isItem()) continue;
                grossAmt = grossAmt.subtract(amt);
                serviceAmt = serviceAmt.add(amt);
            }
            FactLine[] fLines = fact.getLines();
            for (int i9 = 0; i9 < fLines.length; ++i9) {
                if (fLines[i9] == null) continue;
                fLines[i9].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i9].setLocationFromOrg(fLines[i9].getAD_Org_ID(), false);
            }
            int payablesId = this.getValidCombinationId(2, acctSchema);
            int payablesServicesId = this.getValidCombinationId(3, acctSchema);
            if (this.m_allLinesItem || !acctSchema.isPostServices() || payablesId == payablesServicesId) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), payablesId, this.getTrxName()), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.getValidCombination(this.getCtx(), payablesServicesId, this.getTrxName()), this.getC_Currency_ID(), serviceAmt, null);
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    public BigDecimal createFactCash(MAcctSchema as, Fact fact, BigDecimal multiplier) {
        int i2;
        boolean creditMemo = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
        boolean payables = this.getDocumentType().equals("API") || this.getDocumentType().equals("APC");
        BigDecimal acctAmt = Env.ZERO;
        FactLine fl = null;
        for (i2 = 0; i2 < this.p_lines.length; ++i2) {
            DocLine line = this.p_lines[i2];
            boolean landedCost = false;
            if (payables) {
                landedCost = this.landedCost(as, fact, line, false);
            }
            if (landedCost && as.isExplicitCostAdjustment()) {
                fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                Object desc = line.getDescription();
                desc = desc == null ? "100%" : (String)desc + " 100%";
                fl.setDescription((String)desc);
            }
            if (landedCost) continue;
            MAccount acct = line.getAccount(payables ? 2 : 1, as);
            if (payables && line.isItem()) {
                acct = line.getAccount(10, as);
            }
            BigDecimal amt = line.getAmtSource().multiply(multiplier);
            BigDecimal amt2 = null;
            if (creditMemo) {
                amt2 = amt;
                amt = null;
            }
            if ((fl = payables ? fact.createLine(line, acct, this.getC_Currency_ID(), amt, amt2) : fact.createLine(line, acct, this.getC_Currency_ID(), amt2, amt)) == null) continue;
            acctAmt = acctAmt.add(fl.getAcctBalance());
        }
        for (i2 = 0; i2 < this.m_taxes.length; ++i2) {
            BigDecimal amt = this.m_taxes[i2].getAmount();
            BigDecimal amt2 = null;
            if (creditMemo) {
                amt2 = amt;
                amt = null;
            }
            FactLine tl = null;
            tl = payables ? fact.createLine(null, this.m_taxes[i2].getAccount(this.m_taxes[i2].getAPTaxType(), as), this.getC_Currency_ID(), amt, amt2) : fact.createLine(null, this.m_taxes[i2].getAccount(0, as), this.getC_Currency_ID(), amt2, amt);
            if (tl == null) continue;
            tl.setC_Tax_ID(this.m_taxes[i2].getC_Tax_ID());
        }
        FactLine[] fLines = fact.getLines();
        for (int i3 = 0; i3 < fLines.length; ++i3) {
            if (fLines[i3] == null) continue;
            if (payables) {
                fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), false);
                continue;
            }
            fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), true);
            fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
        }
        return acctAmt;
    }

    private boolean landedCost(MAcctSchema as, Fact fact, DocLine line, boolean isDebit) {
        int invoiceLineId = line.get_ID();
        MLandedCostAllocation[] landedCostAllocations = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), invoiceLineId, this.getTrxName());
        if (landedCostAllocations.length == 0) {
            return false;
        }
        BigDecimal totalBase = Arrays.stream(landedCostAllocations).map(X_C_LandedCostAllocation::getBase).reduce(BigDecimal.ZERO, BigDecimal::add);
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), invoiceLineId, this.getTrxName());
        Arrays.stream(landedCostAllocations).filter(landedCostAllocation -> landedCostAllocation.getBase().signum() != 0).forEach(landedCostAllocation -> {
            BigDecimal percent = landedCostAllocation.getBase().divide(totalBase, RoundingMode.HALF_UP);
            Object desc = invoiceLine.getDescription();
            desc = desc == null ? percent + "%" : (String)desc + " - " + percent + "%";
            if (line.getDescription() != null) {
                desc = (String)desc + " - " + line.getDescription();
            }
            ProductCost productCost = new ProductCost(Env.getCtx(), landedCostAllocation.getM_Product_ID(), landedCostAllocation.getM_AttributeSetInstance_ID(), this.getTrxName());
            BigDecimal debitAmount = BigDecimal.ZERO;
            BigDecimal creditAmount = BigDecimal.ZERO;
            FactLine factLine = null;
            MCostType costType = MCostType.get(as, landedCostAllocation.getM_Product_ID(), landedCostAllocation.getAD_Org_ID());
            if ("I".equals(costType.getCostingMethod())) {
                BigDecimal assetAmount = Optional.ofNullable(MCostDetail.getByDocLineLandedCost(landedCostAllocation, as.getC_AcctSchema_ID(), costType.get_ID())).orElseGet(() -> BigDecimal.ZERO);
                if (assetAmount.signum() != 0) {
                    if (isDebit) {
                        debitAmount = assetAmount;
                    } else {
                        creditAmount = assetAmount.negate();
                    }
                    factLine = fact.createLine(line, productCost.getAccount(3, as), as.getC_Currency_ID(), debitAmount, creditAmount);
                    factLine.setDescription((String)desc + " " + landedCostAllocation.getM_CostElement().getName());
                    factLine.setM_Product_ID(landedCostAllocation.getM_Product_ID());
                }
                BigDecimal costAllocation = landedCostAllocation.getPriceActual().multiply(landedCostAllocation.getQty());
                BigDecimal costAdjustment = costAllocation.subtract(assetAmount);
                this.setIsMultiCurrency(landedCostAllocation.getC_Currency_ID() != as.getC_Currency_ID());
                if (costAdjustment.signum() != 0) {
                    if (isDebit) {
                        debitAmount = costAdjustment;
                    } else {
                        creditAmount = costAdjustment;
                    }
                    factLine = fact.createLine(line, productCost.getAccount(9, as), this.getC_Currency_ID(), debitAmount, creditAmount);
                }
            } else {
                factLine = fact.createLine(line, productCost.getAccount(9, as), this.getC_Currency_ID(), debitAmount, creditAmount);
            }
            factLine.setDescription((String)desc + " " + landedCostAllocation.getM_CostElement().getName());
            factLine.setM_Product_ID(landedCostAllocation.getM_Product_ID());
        });
        this.log.config("Created #" + landedCostAllocations.length);
        return true;
    }

    private void updateProductPO(MAcctSchema as) {
        MClientInfo ci = MClientInfo.get(this.getCtx(), as.getAD_Client_ID(), this.getTrxName());
        if (ci.getC_AcctSchema1_ID() != as.getC_AcctSchema_ID()) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_PO po SET PriceLastInv = (SELECT currencyConvert(il.PriceActual,i.C_Currency_ID,po.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) FROM C_Invoice i, C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID");
        if (DB.isOracle()) {
            sql.append(" AND ROWNUM=1 ");
        } else {
            sql.append(" AND il.C_InvoiceLine_ID = (SELECT MIN(il1.C_InvoiceLine_ID) FROM C_Invoice i1, C_InvoiceLine il1 WHERE i1.C_Invoice_ID=il1.C_Invoice_ID AND po.M_Product_ID=il1.M_Product_ID AND po.C_BPartner_ID=i1.C_BPartner_ID").append("  AND i1.C_Invoice_ID=").append(this.get_ID()).append(") ");
        }
        sql.append("  AND i.C_Invoice_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM C_Invoice i, C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID AND i.C_Invoice_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("Updated=" + no);
    }

    private void updateProductInfo(int C_AcctSchema_ID) {
        this.log.fine("C_Invoice_ID=" + this.get_ID());
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing pc SET (PriceLastInv, TotalInvAmt,TotalInvQty) = (SELECT currencyConvert(il.PriceActual,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(il.LineNetAmt,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID),il.QtyInvoiced FROM C_Invoice i, C_InvoiceLine il, C_AcctSchema a WHERE i.C_Invoice_ID=il.C_Invoice_ID AND il.c_invoiceline_id = (SELECT MIN(C_InvoiceLine_ID) FROM C_InvoiceLine il2 WHERE  il2.M_PRODUCT_ID=il.M_PRODUCT_ID AND C_Invoice_ID=").append(this.get_ID()).append(") AND pc.M_Product_ID=il.M_Product_ID AND pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND i.C_Invoice_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM C_Invoice i, C_InvoiceLine il, C_AcctSchema a WHERE i.C_Invoice_ID=il.C_Invoice_ID AND pc.M_Product_ID=il.M_Product_ID AND pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND i.C_Invoice_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("M_Product_Costing - Updated=" + no);
    }
}

