/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MTransaction;
import org.compiere.util.Env;

public class Doc_Movement
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Movement(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMovement.class, rs, "MMM", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMovement move = (MMovement)this.getPO();
        this.setDateDoc(move.getMovementDate());
        this.setDateAcct(move.getMovementDate());
        this.m_Reversal_ID = move.getReversal_ID();
        this.m_DocStatus = move.getDocStatus();
        this.p_lines = this.loadLines(move);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MMovement move) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MMovementLine[] lines = move.getLines(false);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MMovementLine line = lines[i2];
            DocLine docLine = new DocLine(line, this);
            docLine.setQty(line.getMovementQty(), false);
            docLine.setReversalLine_ID(line.getReversalLine_ID());
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        for (int i2 = 0; i2 < this.p_lines.length; ++i2) {
            DocLine line = this.p_lines[i2];
            BigDecimal costs = Env.ZERO;
            for (MCostDetail cost : line.getCostDetail(as, false)) {
                if (!MCostDetail.existsCost(cost)) continue;
                String description = cost.getM_CostElement().getName() + " " + cost.getM_CostType().getName();
                costs = MCostDetail.getTotalCost(cost, as);
                MTransaction trx = new MTransaction(this.getCtx(), cost.getM_Transaction_ID(), this.getTrxName());
                if ("M-".equals(trx.getMovementType())) {
                    dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs.negate());
                    if (dr == null) continue;
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.addDescription(description);
                    dr.setM_Product_ID(cost.getM_Product_ID());
                    dr.setQty(cost.getQty().negate());
                    if (this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0 || dr.updateReverseLine(MMovement.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty().negate(), Env.ONE.negate())) continue;
                    this.p_Error = "Original Inventory Move not posted yet";
                    return null;
                }
                if (!"M+".equals(trx.getMovementType()) || (cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs)) == null) continue;
                cr.setM_Locator_ID(line.getM_LocatorTo_ID());
                cr.addDescription(description);
                cr.setM_Product_ID(cost.getM_Product_ID());
                cr.setQty(cost.getQty());
                if (this.m_Reversal_ID == 0 || line.getReversalLine_ID() == 0) continue;
                if (!cr.updateReverseLine(MMovement.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), cost.getQty(), Env.ONE.negate())) {
                    this.p_Error = "Original Inventory Move not posted yet";
                    return null;
                }
                costs = cr.getAcctBalance();
            }
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    public static String getDateAcctColumnName() {
        return "MovementDate";
    }
}

