/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_Production;
import org.adempiere.core.domains.models.X_M_ProductionLine;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_Production
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Production(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, X_M_Production.class, rs, "MMP", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        X_M_Production prod = (X_M_Production)this.getPO();
        this.setDateDoc(prod.getMovementDate());
        this.setDateAcct(prod.getMovementDate());
        this.m_Reversal_ID = prod.getReversal_ID();
        this.m_DocStatus = prod.getDocStatus();
        this.p_lines = this.loadLines(prod);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(X_M_Production prod) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        String sqlPL = "SELECT * FROM M_ProductionLine pl WHERE pl.M_Production_ID=? ORDER BY pl.Line";
        try {
            CPreparedStatement pstmtPL = DB.prepareStatement(sqlPL, this.getTrxName());
            pstmtPL.setInt(1, this.get_ID());
            ResultSet rsPL = pstmtPL.executeQuery();
            while (rsPL.next()) {
                X_M_ProductionLine line = new X_M_ProductionLine(this.getCtx(), rsPL, this.getTrxName());
                if (line.getMovementQty().signum() == 0) {
                    this.log.info("LineQty=0 - " + line);
                    continue;
                }
                DocLine docLine = new DocLine(line, this);
                docLine.setQty(line.getMovementQty(), false);
                docLine.setProductionBOM(line.getM_Product_ID() == prod.getM_Product_ID());
                this.log.fine(docLine.toString());
                list.add(docLine);
            }
            rsPL.close();
            pstmtPL.close();
        }
        catch (Exception ee) {
            this.log.log(Level.SEVERE, sqlPL, ee);
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine factLine = null;
        BigDecimal total = Env.ZERO;
        DocLine parentProductionLine = null;
        for (DocLine line : this.p_lines) {
            BigDecimal totalCosts;
            MProduct product = line.getProduct();
            if (line.isProductionBOM()) {
                parentProductionLine = line;
            }
            if ("I".equals(product.getProductType())) {
                totalCosts = Env.ZERO;
                BigDecimal qty = line.getQty();
                BigDecimal costTransaction = Env.ZERO;
                for (MCostDetail cost : line.getCostDetail(as, false)) {
                    if (!MCostDetail.existsCost(cost)) continue;
                    costTransaction = MCostDetail.getTotalCost(cost, as);
                    totalCosts = totalCosts.add(costTransaction);
                }
                if (qty.signum() < 0) {
                    totalCosts = totalCosts.negate();
                }
                total = total.add(totalCosts);
                factLine = fact.createLine(line, line.getAccount(3, as), line.getAccount(3, as), as.getC_Currency_ID(), totalCosts);
                factLine.setM_Product_ID(line.getM_Product_ID());
                factLine.setM_Locator_ID(line.getM_Locator_ID());
                factLine.setDescription("");
                factLine.saveEx();
                continue;
            }
            if ("I".equals(product.getProductType())) continue;
            totalCosts = Env.ZERO;
            MAccount acct = null;
            for (MCostElement costElement : MCostElement.getCostElement(line.getCtx(), line.getTrxName())) {
                acct = "B".equals(costElement.getCostElementType()) ? line.getAccount(19, as) : ("X".equals(costElement.getCostElementType()) ? line.getAccount(20, as) : ("O".equals(costElement.getCostElementType()) ? line.getAccount(21, as) : ("R".equals(costElement.getCostElementType()) ? line.getAccount(18, as) : line.getAccount(20, as))));
                int warehouseId = DB.getSQLValue(line.getTrxName(), "SELECT M_Warehouse_ID from M_Locator WHERE M_Locator_ID=?", line.getM_Locator_ID());
                BigDecimal costTransaction = Env.ZERO;
                MCost costDimension = MCost.validateCostForCostType(as, (MCostType)as.getM_CostType(), costElement, product.getM_Product_ID(), line.getAD_Org_ID(), warehouseId, line.getM_AttributeSetInstance_ID(), line.getTrxName());
                if (costDimension != null) {
                    costTransaction = costDimension.getCurrentCostPrice().add(costDimension.getCurrentCostPriceLL());
                }
                totalCosts = totalCosts.add(costTransaction.multiply(line.getQty()));
            }
            factLine = fact.createLine(line, acct, acct, as.getC_Currency_ID(), totalCosts);
            factLine.setM_Product_ID(line.getM_Product_ID());
            factLine.setM_Locator_ID(line.getM_Locator_ID());
            if (this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !factLine.updateReverseLine(MProduction.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), line.getQty(), Env.ONE)) {
                this.p_Error = "Original Physical Inventory not posted yet";
                return null;
            }
            factLine.setDescription("");
            factLine.saveEx();
            total = total.add(totalCosts);
        }
        if (total.signum() != 0) {
            factLine = fact.createLine(parentProductionLine, parentProductionLine.getAccount(9, as), as.getC_Currency_ID(), total);
            factLine.setM_Product_ID(parentProductionLine.getM_Product_ID());
            factLine.setM_Locator_ID(parentProductionLine.getM_LocatorTo_ID());
            factLine.setDescription(" Adjustment Cost");
            factLine.saveEx();
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    public static String getDateAcctColumnName() {
        return "MovementDate";
    }
}

