/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_ProjectIssue
extends Doc {
    private DocLine m_line = null;
    private MProjectIssue m_issue = null;

    public Doc_ProjectIssue(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MProjectIssue.class, rs, "PJI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        this.m_issue = (MProjectIssue)this.getPO();
        this.setDateDoc(this.m_issue.getMovementDate());
        this.setDateAcct(this.m_issue.getMovementDate());
        this.m_line = new DocLine(this.m_issue, this);
        this.m_line.setQty(this.m_issue.getMovementQty(), true);
        if (this.m_line.getM_Product_ID() == 0) {
            this.log.warning(this.m_line.toString() + " - No Product");
        }
        this.log.fine(this.m_line.toString());
        return null;
    }

    @Override
    public String getDocumentNo() {
        MProject p2 = this.m_issue.getParent();
        if (p2 != null) {
            return p2.getValue() + " #" + this.m_issue.getLine();
        }
        return "(" + this.m_issue.get_ID() + ")";
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        MProject project = new MProject(this.getCtx(), this.m_issue.getC_Project_ID(), this.getTrxName());
        String ProjectCategory = project.getProjectCategory();
        MProduct product = MProduct.get(this.getCtx(), this.m_issue.getM_Product_ID());
        FactLine dr = null;
        FactLine cr = null;
        BigDecimal costs = null;
        BigDecimal total = Env.ZERO;
        if (this.m_issue.getM_InOutLine_ID() != 0) {
            costs = this.getPOCost(as);
        } else if (this.m_issue.getS_TimeExpenseLine_ID() != 0) {
            costs = this.getLaborCost(as);
        }
        if (costs == null) {
            for (MCostDetail cost : this.m_line.getCostDetail(as, false)) {
                if (!MCostDetail.existsCost(cost)) continue;
                costs = MCostDetail.getTotalCost(cost, as);
                total = total.add(costs);
            }
        }
        if (total == null || total.signum() == 0) {
            this.p_Error = "Resubmit - No Costs for " + product.getName();
            this.log.log(Level.WARNING, this.p_Error);
            return null;
        }
        int acctType = 62;
        if ("A".equals(ProjectCategory)) {
            acctType = 61;
        }
        dr = fact.createLine(this.m_line, this.getAccount(acctType, as), as.getC_Currency_ID(), costs, null);
        dr.setQty(this.m_line.getQty().negate());
        acctType = 3;
        if (product.isService()) {
            acctType = 2;
        }
        cr = fact.createLine(this.m_line, this.m_line.getAccount(acctType, as), as.getC_Currency_ID(), null, costs);
        cr.setM_Locator_ID(this.m_line.getM_Locator_ID());
        cr.setLocationFromLocator(this.m_line.getM_Locator_ID(), true);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPOCost(MAcctSchema as) {
        BigDecimal retValue = null;
        String sql = "SELECT currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateOrdered, o.C_ConversionType_ID, ?, ?) FROM C_OrderLine ol INNER JOIN M_InOutLine iol ON (iol.C_OrderLine_ID=ol.C_OrderLine_ID) INNER JOIN C_Order o ON (o.C_Order_ID=ol.C_Order_ID) WHERE iol.M_InOutLine_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, as.getC_Currency_ID());
            pstmt.setInt(2, this.getAD_Client_ID());
            pstmt.setInt(3, this.getAD_Org_ID());
            pstmt.setInt(4, this.m_issue.getM_InOutLine_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
                this.log.fine("POCost = " + retValue);
            } else {
                this.log.warning("Not found for M_InOutLine_ID=" + this.m_issue.getM_InOutLine_ID());
            }
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getLaborCost(MAcctSchema as) {
        ResultSet rs;
        CPreparedStatement pstmt;
        BigDecimal retValue;
        block5: {
            retValue = Env.ZERO;
            BigDecimal qty = Env.ZERO;
            String sql = "SELECT ConvertedAmt, Qty FROM S_TimeExpenseLine  WHERE S_TimeExpenseLine.S_TimeExpenseLine_ID = ?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.getTrxName());
                pstmt.setInt(1, this.m_issue.getS_TimeExpenseLine_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                    qty = rs.getBigDecimal(2);
                    retValue = retValue.multiply(qty);
                    this.log.fine("ExpLineCost = " + retValue);
                    break block5;
                }
                this.log.warning("Not found for S_TimeExpenseLine_ID=" + this.m_issue.getS_TimeExpenseLine_ID());
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
            }
        }
        DB.close(rs, pstmt);
        pstmt = null;
        rs = null;
        return retValue;
    }

    public static String getDateAcctColumnName() {
        return "MovementDate";
    }
}

