/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_Fact_Acct;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMovement;
import org.compiere.model.MRevenueRecognitionPlan;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public final class FactLine
extends X_Fact_Acct {
    private static final long serialVersionUID = 6141312459030795891L;
    private MAccount m_acct = null;
    private MAcctSchema m_acctSchema = null;
    private Doc m_doc = null;
    private DocLine m_docLine = null;

    public FactLine(Properties ctx, int AD_Table_ID, int Record_ID, int Line_ID, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Client_ID(0);
        this.setAD_Org_ID(0);
        this.setAmtAcctCr(Env.ZERO);
        this.setAmtAcctDr(Env.ZERO);
        this.setAmtSourceCr(Env.ZERO);
        this.setAmtSourceDr(Env.ZERO);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
        this.setLine_ID(Line_ID);
    }

    public FactLine reverse(String description) {
        FactLine reversal = new FactLine(this.getCtx(), this.getAD_Table_ID(), this.getRecord_ID(), this.getLine_ID(), this.get_TrxName());
        reversal.setClientOrg(this);
        reversal.setDocumentInfo(this.m_doc, this.m_docLine);
        reversal.setAccount(this.m_acctSchema, this.m_acct);
        reversal.setPostingType(this.getPostingType());
        reversal.setAmtSource(this.getC_Currency_ID(), this.getAmtSourceDr().negate(), this.getAmtSourceCr().negate());
        reversal.setQty(this.getQty().negate());
        reversal.convert();
        reversal.setDescription(description);
        return reversal;
    }

    public FactLine accrue(String description) {
        FactLine accrual = new FactLine(this.getCtx(), this.getAD_Table_ID(), this.getRecord_ID(), this.getLine_ID(), this.get_TrxName());
        accrual.setClientOrg(this);
        accrual.setDocumentInfo(this.m_doc, this.m_docLine);
        accrual.setAccount(this.m_acctSchema, this.m_acct);
        accrual.setPostingType(this.getPostingType());
        accrual.setAmtSource(this.getC_Currency_ID(), this.getAmtSourceCr(), this.getAmtSourceDr());
        accrual.convert();
        accrual.setDescription(description);
        return accrual;
    }

    public void setAccount(MAcctSchema acctSchema, MAccount acct) {
        String ColumnName2;
        MAcctSchemaElement acctSchemaElement2;
        String ColumnName1;
        this.m_acctSchema = acctSchema;
        this.setC_AcctSchema_ID(acctSchema.getC_AcctSchema_ID());
        this.m_acct = acct;
        if (this.getAD_Client_ID() == 0) {
            this.setAD_Client_ID(this.m_acct.getAD_Client_ID());
        }
        this.setAccount_ID(this.m_acct.getAccount_ID());
        this.setC_SubAcct_ID(this.m_acct.getC_SubAcct_ID());
        MAcctSchemaElement acctSchemaElement1 = this.m_acctSchema.getAcctSchemaElement("X1");
        if (acctSchemaElement1 != null && (ColumnName1 = acctSchemaElement1.getDisplayColumnName()) != null) {
            int userElement1Id = 0;
            if (this.m_docLine != null) {
                userElement1Id = this.m_docLine.getValue(ColumnName1);
            }
            if (userElement1Id == 0) {
                if (this.m_doc == null) {
                    throw new IllegalArgumentException("Document not set yet");
                }
                userElement1Id = this.m_doc.getValue(ColumnName1);
            }
            if (userElement1Id == 0 && acct.getUserElement1_ID() > 0) {
                userElement1Id = acct.getUserElement1_ID();
            }
            if (userElement1Id != 0) {
                this.setUserElement1_ID(userElement1Id);
            }
        }
        if ((acctSchemaElement2 = this.m_acctSchema.getAcctSchemaElement("X2")) != null && (ColumnName2 = acctSchemaElement2.getDisplayColumnName()) != null) {
            int userElement2Id = 0;
            if (this.m_docLine != null) {
                userElement2Id = this.m_docLine.getValue(ColumnName2);
            }
            if (userElement2Id == 0) {
                if (this.m_doc == null) {
                    throw new IllegalArgumentException("Document not set yet");
                }
                userElement2Id = this.m_doc.getValue(ColumnName2);
            }
            if (userElement2Id == 0 && acct.getUserElement2_ID() > 0) {
                userElement2Id = acct.getUserElement2_ID();
            }
            if (userElement2Id != 0) {
                this.setUserElement2_ID(userElement2Id);
            }
        }
    }

    public boolean setAmtSource(int C_Currency_ID, BigDecimal AmtSourceDr, BigDecimal AmtSourceCr) {
        FactLine.setSourceAmount(this.m_acctSchema, this, AmtSourceDr, AmtSourceCr);
        AmtSourceDr = this.getAmtSourceDr();
        AmtSourceCr = this.getAmtSourceCr();
        this.setC_Currency_ID(C_Currency_ID);
        if (AmtSourceDr != null) {
            this.setAmtSourceDr(AmtSourceDr);
        }
        if (AmtSourceCr != null) {
            this.setAmtSourceCr(AmtSourceCr);
        }
        int precision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
        if (AmtSourceDr != null && AmtSourceDr.scale() > precision) {
            BigDecimal AmtSourceDr1 = AmtSourceDr.setScale(precision, RoundingMode.HALF_UP);
            if (AmtSourceDr1.compareTo(AmtSourceDr) != 0) {
                this.log.warning("Source DR Precision " + AmtSourceDr + " -> " + AmtSourceDr1);
            }
            this.setAmtSourceDr(AmtSourceDr1);
        }
        if (AmtSourceCr != null && AmtSourceCr.scale() > precision) {
            BigDecimal AmtSourceCr1 = AmtSourceCr.setScale(precision, RoundingMode.HALF_UP);
            if (AmtSourceCr1.compareTo(AmtSourceCr) != 0) {
                this.log.warning("Source CR Precision " + AmtSourceCr + " -> " + AmtSourceCr1);
            }
            this.setAmtSourceCr(AmtSourceCr1);
        }
        return true;
    }

    public void setAmtAcct(BigDecimal AmtAcctDr, BigDecimal AmtAcctCr) {
        FactLine.setAccountingAmount(this.m_acctSchema, this, AmtAcctDr, AmtAcctCr);
    }

    public void setAmtAcct(int C_Currency_ID, BigDecimal AmtAcctDr, BigDecimal AmtAcctCr) {
        FactLine.setAccountingAmount(this.m_acctSchema, this, AmtAcctDr, AmtAcctCr);
        AmtAcctDr = this.getAmtAcctDr();
        AmtAcctCr = this.getAmtAcctCr();
        int precision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
        if (AmtAcctDr != null && AmtAcctDr.scale() > precision) {
            BigDecimal AmtAcctDr1 = AmtAcctDr.setScale(precision, RoundingMode.HALF_UP);
            if (AmtAcctDr1.compareTo(AmtAcctDr) != 0) {
                this.log.warning("Accounted DR Precision " + AmtAcctDr + " -> " + AmtAcctDr1);
            }
            this.setAmtAcctDr(AmtAcctDr1);
        }
        if (AmtAcctCr != null && AmtAcctCr.scale() > precision) {
            BigDecimal AmtAcctCr1 = AmtAcctCr.setScale(precision, RoundingMode.HALF_UP);
            if (AmtAcctCr1.compareTo(AmtAcctCr) != 0) {
                this.log.warning("Accounted CR Precision " + AmtAcctCr + " -> " + AmtAcctCr1);
            }
            this.setAmtAcctCr(AmtAcctCr1);
        }
    }

    public static void setSourceAmount(MAcctSchema as, X_Fact_Acct fact, BigDecimal AmtDr, BigDecimal AmtCr) {
        FactLine.setAmount(as, fact, Optional.ofNullable(AmtDr).orElse(Env.ZERO), Optional.ofNullable(AmtCr).orElse(Env.ZERO), true);
    }

    public static void setAccountingAmount(MAcctSchema as, X_Fact_Acct fact, BigDecimal AmtDr, BigDecimal AmtCr) {
        FactLine.setAmount(as, fact, Optional.ofNullable(AmtDr).orElse(Env.ZERO), Optional.ofNullable(AmtCr).orElse(Env.ZERO), false);
    }

    public static void setAmount(MAcctSchema as, X_Fact_Acct fact, BigDecimal AmtDr, BigDecimal AmtCr, boolean isSource) {
        if (!as.isAllowNegativePosting()) {
            if (AmtDr.compareTo(Env.ZERO) == -1) {
                AmtCr = AmtDr.abs();
                AmtDr = Env.ZERO;
            }
            if (AmtCr.compareTo(Env.ZERO) == -1) {
                AmtDr = AmtCr.abs();
                AmtCr = Env.ZERO;
            }
        }
        if (isSource) {
            fact.setAmtSourceDr(AmtDr);
            fact.setAmtSourceCr(AmtCr);
        } else {
            fact.setAmtAcctDr(AmtDr);
            fact.setAmtAcctCr(AmtCr);
        }
    }

    public void setDocumentInfo(Doc doc, DocLine docLine) {
        this.m_doc = doc;
        this.m_docLine = docLine;
        this.setAD_Org_ID(0);
        this.setC_SalesRegion_ID(0);
        if (docLine != null) {
            this.setLine_ID(docLine.get_ID());
        }
        if (this.getAD_Client_ID() == 0) {
            this.setAD_Client_ID(this.m_doc.getAD_Client_ID());
        }
        this.setDateTrx(this.m_doc.getDateDoc());
        if (this.m_docLine != null && this.m_docLine.getDateDoc() != null) {
            this.setDateTrx(this.m_docLine.getDateDoc());
        }
        this.setDateAcct(this.m_doc.getDateAcct());
        if (this.m_docLine != null && this.m_docLine.getDateAcct() != null) {
            this.setDateAcct(this.m_docLine.getDateAcct());
        }
        if (this.m_docLine != null && this.m_docLine.getC_Period_ID() != 0) {
            this.setC_Period_ID(this.m_docLine.getC_Period_ID());
        } else {
            this.setC_Period_ID(this.m_doc.getC_Period_ID());
        }
        if (this.m_docLine != null) {
            this.setC_Tax_ID(this.m_docLine.getC_Tax_ID());
        }
        StringBuffer description = new StringBuffer(this.m_doc.getDocumentNo());
        if (this.m_docLine != null) {
            description.append(" #").append(this.m_docLine.getLine());
            if (this.m_docLine.getDescription() != null) {
                description.append(" (").append(this.m_docLine.getDescription()).append(")");
            } else if (this.m_doc.getDescription() != null && this.m_doc.getDescription().length() > 0) {
                description.append(" (").append(this.m_doc.getDescription()).append(")");
            }
        } else if (this.m_doc.getDescription() != null && this.m_doc.getDescription().length() > 0) {
            description.append(" (").append(this.m_doc.getDescription()).append(")");
        }
        this.setDescription(description.toString());
        this.setGL_Budget_ID(this.m_doc.getGL_Budget_ID());
        this.setGL_Category_ID(this.m_doc.getGL_Category_ID());
        if (this.m_docLine != null) {
            this.setM_Product_ID(this.m_docLine.getM_Product_ID());
        }
        if (this.getM_Product_ID() == 0) {
            this.setM_Product_ID(this.m_doc.getM_Product_ID());
        }
        if (this.m_docLine != null) {
            this.setC_UOM_ID(this.m_docLine.getC_UOM_ID());
        }
        if (this.get_Value("Qty") == null) {
            this.setQty(this.m_doc.getQty());
            if (this.m_docLine != null) {
                this.setQty(this.m_docLine.getQty());
            }
        }
        if (this.getC_LocFrom_ID() == 0 && this.m_docLine != null) {
            this.setC_LocFrom_ID(this.m_docLine.getC_LocFrom_ID());
        }
        if (this.getC_LocFrom_ID() == 0) {
            this.setC_LocFrom_ID(this.m_doc.getC_LocFrom_ID());
        }
        if (this.getC_LocTo_ID() == 0 && this.m_docLine != null) {
            this.setC_LocTo_ID(this.m_docLine.getC_LocTo_ID());
        }
        if (this.getC_LocTo_ID() == 0) {
            this.setC_LocTo_ID(this.m_doc.getC_LocTo_ID());
        }
        if (this.m_docLine != null) {
            this.setC_BPartner_ID(this.m_docLine.getC_BPartner_ID());
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setC_BPartner_ID(this.m_doc.getC_BPartner_ID());
        }
        if (this.m_docLine != null) {
            this.setAD_OrgTrx_ID(this.m_docLine.getAD_OrgTrx_ID());
        }
        if (this.getAD_OrgTrx_ID() == 0) {
            this.setAD_OrgTrx_ID(this.m_doc.getAD_OrgTrx_ID());
        }
        if (this.m_docLine != null) {
            this.setC_Project_ID(this.m_docLine.getC_Project_ID());
        }
        if (this.getC_Project_ID() == 0) {
            this.setC_Project_ID(this.m_doc.getC_Project_ID());
        }
        if (this.m_docLine != null) {
            this.setC_ProjectPhase_ID(this.m_docLine.getC_ProjectPhase_ID());
        }
        if (this.getC_ProjectPhase_ID() == 0) {
            this.setC_ProjectPhase_ID(this.m_doc.getC_ProjectPhase_ID());
        }
        if (this.m_docLine != null) {
            this.setC_ProjectTask_ID(this.m_docLine.getC_ProjectTask_ID());
        }
        if (this.getC_ProjectTask_ID() == 0) {
            this.setC_ProjectTask_ID(this.m_doc.getC_ProjectTask_ID());
        }
        if (this.m_docLine != null) {
            this.setC_Campaign_ID(this.m_docLine.getC_Campaign_ID());
        }
        if (this.getC_Campaign_ID() == 0) {
            this.setC_Campaign_ID(this.m_doc.getC_Campaign_ID());
        }
        if (this.m_docLine != null) {
            this.setC_Activity_ID(this.m_docLine.getC_Activity_ID());
        }
        if (this.getC_Activity_ID() == 0) {
            this.setC_Activity_ID(this.m_doc.getC_Activity_ID());
        }
        if (this.m_docLine != null) {
            this.setUser1_ID(this.m_docLine.getUser1_ID());
        }
        if (this.getUser1_ID() == 0) {
            this.setUser1_ID(this.m_doc.getUser1_ID());
        }
        if (this.m_docLine != null) {
            this.setUser2_ID(this.m_docLine.getUser2_ID());
        }
        if (this.getUser2_ID() == 0) {
            this.setUser2_ID(this.m_doc.getUser2_ID());
        }
        if (this.m_docLine != null) {
            this.setUser3_ID(this.m_docLine.getUser3_ID());
        }
        if (this.getUser3_ID() == 0) {
            this.setUser3_ID(this.m_doc.getUser3_ID());
        }
        if (this.m_docLine != null) {
            this.setUser4_ID(this.m_docLine.getUser4_ID());
        }
        if (this.getUser4_ID() == 0) {
            this.setUser4_ID(this.m_doc.getUser4_ID());
        }
        if (this.m_docLine != null) {
            this.setUserElement1_ID(this.m_docLine.getUserElement1_ID());
        }
        if (this.getUserElement1_ID() == 0) {
            this.setUserElement1_ID(this.m_doc.getUserElement1_ID());
        }
        if (this.m_docLine != null) {
            this.setUserElement2_ID(this.m_docLine.getUserElement2_ID());
        }
        if (this.getUserElement2_ID() == 0) {
            this.setUserElement2_ID(this.m_doc.getUserElement2_ID());
        }
    }

    public DocLine getDocLine() {
        return this.m_docLine;
    }

    public void addDescription(String description) {
        if (description == null) {
            return;
        }
        String original = this.getDescription();
        if (original == null || original.trim().length() == 0) {
            super.setDescription(description);
        } else {
            super.setDescription(original + " - " + description);
        }
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
        super.setM_Locator_ID(M_Locator_ID);
        this.setAD_Org_ID(0);
    }

    public void setLocation(int C_Location_ID, boolean isFrom) {
        if (isFrom) {
            this.setC_LocFrom_ID(C_Location_ID);
        } else {
            this.setC_LocTo_ID(C_Location_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationFromLocator(int M_Locator_ID, boolean isFrom) {
        if (M_Locator_ID == 0) {
            return;
        }
        int C_Location_ID = 0;
        String sql = "SELECT w.C_Location_ID FROM M_Warehouse w, M_Locator l WHERE w.M_Warehouse_ID=l.M_Warehouse_ID AND l.M_Locator_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, M_Locator_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Location_ID = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (C_Location_ID != 0) {
            this.setLocation(C_Location_ID, isFrom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationFromBPartner(int C_BPartner_Location_ID, boolean isFrom) {
        if (C_BPartner_Location_ID == 0) {
            return;
        }
        int C_Location_ID = 0;
        String sql = "SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, C_BPartner_Location_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Location_ID = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (C_Location_ID != 0) {
            this.setLocation(C_Location_ID, isFrom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationFromOrg(int AD_Org_ID, boolean isFrom) {
        if (AD_Org_ID == 0) {
            return;
        }
        int C_Location_ID = 0;
        String sql = "SELECT C_Location_ID FROM AD_OrgInfo WHERE AD_Org_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, AD_Org_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Location_ID = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (C_Location_ID != 0) {
            this.setLocation(C_Location_ID, isFrom);
        }
    }

    public BigDecimal getSourceBalance() {
        if (this.getAmtSourceDr() == null) {
            this.setAmtSourceDr(Env.ZERO);
        }
        if (this.getAmtSourceCr() == null) {
            this.setAmtSourceCr(Env.ZERO);
        }
        return this.getAmtSourceDr().subtract(this.getAmtSourceCr());
    }

    public boolean isDrSourceBalance() {
        return this.getSourceBalance().signum() != -1;
    }

    public BigDecimal getAcctBalance() {
        if (this.getAmtAcctDr() == null) {
            this.setAmtAcctDr(Env.ZERO);
        }
        if (this.getAmtAcctCr() == null) {
            this.setAmtAcctCr(Env.ZERO);
        }
        return this.getAmtAcctDr().subtract(this.getAmtAcctCr());
    }

    public boolean isBalanceSheet() {
        return this.m_acct.isBalanceSheet();
    }

    public void currencyCorrect(BigDecimal deltaAmount) {
        boolean negative = deltaAmount.compareTo(Env.ZERO) < 0;
        boolean adjustDr = this.getAmtAcctDr().abs().compareTo(this.getAmtAcctCr().abs()) > 0;
        this.log.fine(deltaAmount.toString() + "; Old-AcctDr=" + this.getAmtAcctDr() + ",AcctCr=" + this.getAmtAcctCr() + "; Negative=" + negative + "; AdjustDr=" + adjustDr);
        if (adjustDr) {
            if (negative) {
                this.setAmtAcctDr(this.getAmtAcctDr().subtract(deltaAmount));
            } else {
                this.setAmtAcctDr(this.getAmtAcctDr().subtract(deltaAmount));
            }
        } else if (negative) {
            this.setAmtAcctCr(this.getAmtAcctCr().add(deltaAmount));
        } else {
            this.setAmtAcctCr(this.getAmtAcctCr().add(deltaAmount));
        }
        this.log.fine("New-AcctDr=" + this.getAmtAcctDr() + ",AcctCr=" + this.getAmtAcctCr());
    }

    public boolean convert() {
        if (this.getC_Currency_ID() == -2) {
            this.setC_Currency_ID(this.m_acctSchema.getC_Currency_ID());
        }
        if (this.m_acctSchema.getC_Currency_ID() == this.getC_Currency_ID()) {
            this.setAmtAcctDr(this.getAmtSourceDr());
            this.setAmtAcctCr(this.getAmtSourceCr());
            return true;
        }
        int C_ConversionType_ID = 0;
        int AD_Org_ID = 0;
        if (this.m_docLine != null) {
            C_ConversionType_ID = this.m_docLine.getC_ConversionType_ID();
            AD_Org_ID = this.m_docLine.getAD_Org_ID();
        }
        if (C_ConversionType_ID == 0) {
            if (this.m_doc == null) {
                this.log.severe("No Document VO");
                return false;
            }
            C_ConversionType_ID = this.m_doc.getC_ConversionType_ID();
            if (AD_Org_ID == 0) {
                AD_Org_ID = this.m_doc.getAD_Org_ID();
            }
        }
        this.setAmtAcctDr(MConversionRate.convert(this.getCtx(), this.getAmtSourceDr(), this.getC_Currency_ID(), this.m_acctSchema.getC_Currency_ID(), this.getDateAcct(), C_ConversionType_ID, this.m_doc.getAD_Client_ID(), AD_Org_ID));
        if (this.getAmtAcctDr() == null) {
            return false;
        }
        this.setAmtAcctCr(MConversionRate.convert(this.getCtx(), this.getAmtSourceCr(), this.getC_Currency_ID(), this.m_acctSchema.getC_Currency_ID(), this.getDateAcct(), C_ConversionType_ID, this.m_doc.getAD_Client_ID(), AD_Org_ID));
        return true;
    }

    public MAccount getAccount() {
        return this.m_acct;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("FactLine=[");
        sb.append(this.getAD_Table_ID()).append(":").append(this.getRecord_ID()).append(",").append(this.m_acct).append(",Cur=").append(this.getC_Currency_ID()).append(", DR=").append(this.getAmtSourceDr()).append("|").append(this.getAmtAcctDr()).append(", CR=").append(this.getAmtSourceCr()).append("|").append(this.getAmtAcctCr()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAD_Org_ID() {
        if (super.getAD_Org_ID() != 0) {
            return super.getAD_Org_ID();
        }
        if (this.getM_Locator_ID() != 0) {
            String sql = "SELECT AD_Org_ID FROM M_Locator WHERE M_Locator_ID=? AND AD_Client_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getM_Locator_ID());
                pstmt.setInt(2, this.getAD_Client_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.setAD_Org_ID(rs.getInt(1));
                    this.log.finer("AD_Org_ID=" + super.getAD_Org_ID() + " (1 from M_Locator_ID=" + this.getM_Locator_ID() + ")");
                } else {
                    this.log.log(Level.SEVERE, "AD_Org_ID - Did not find M_Locator_ID=" + this.getM_Locator_ID());
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        if (this.m_docLine != null && super.getAD_Org_ID() == 0) {
            this.setAD_Org_ID(this.m_docLine.getAD_Org_ID());
            this.log.finer("AD_Org_ID=" + super.getAD_Org_ID() + " (2 from DocumentLine)");
        }
        if (this.m_doc != null && super.getAD_Org_ID() == 0) {
            if ("GLJ".equals(this.m_doc.getDocumentType())) {
                this.setAD_Org_ID(this.m_acct.getAD_Org_ID());
                this.log.finer("AD_Org_ID=" + super.getAD_Org_ID() + " (3 from Acct)");
            } else {
                this.setAD_Org_ID(this.m_doc.getAD_Org_ID());
                this.log.finer("AD_Org_ID=" + super.getAD_Org_ID() + " (3 from Document)");
            }
        }
        if (this.m_doc != null && super.getAD_Org_ID() == 0) {
            if ("GLJ".equals(this.m_doc.getDocumentType())) {
                this.setAD_Org_ID(this.m_doc.getAD_Org_ID());
                this.log.finer("AD_Org_ID=" + super.getAD_Org_ID() + " (4 from Document)");
            } else {
                this.setAD_Org_ID(this.m_acct.getAD_Org_ID());
                this.log.finer("AD_Org_ID=" + super.getAD_Org_ID() + " (4 from Acct)");
            }
        }
        return super.getAD_Org_ID();
    }

    @Override
    public int getC_SalesRegion_ID() {
        if (super.getC_SalesRegion_ID() != 0) {
            return super.getC_SalesRegion_ID();
        }
        if (this.m_docLine != null) {
            this.setC_SalesRegion_ID(this.m_docLine.getC_SalesRegion_ID());
        }
        if (this.m_doc != null) {
            if (super.getC_SalesRegion_ID() == 0) {
                this.setC_SalesRegion_ID(this.m_doc.getC_SalesRegion_ID());
            }
            if (super.getC_SalesRegion_ID() == 0 && this.m_doc.getBP_C_SalesRegion_ID() > 0) {
                this.setC_SalesRegion_ID(this.m_doc.getBP_C_SalesRegion_ID());
            }
            if (super.getC_SalesRegion_ID() == 0 && this.m_doc.getC_BPartner_Location_ID() != 0 && this.m_doc.getBP_C_SalesRegion_ID() == -1) {
                String sql = "SELECT COALESCE(C_SalesRegion_ID,0) FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?";
                this.setC_SalesRegion_ID(DB.getSQLValue(null, sql, this.m_doc.getC_BPartner_Location_ID()));
                if (super.getC_SalesRegion_ID() != 0) {
                    this.m_doc.setBP_C_SalesRegion_ID(super.getC_SalesRegion_ID());
                    this.log.fine("C_SalesRegion_ID=" + super.getC_SalesRegion_ID() + " (from BPL)");
                } else {
                    sql = "SELECT COALESCE(MAX(C_SalesRegion_ID),0) FROM C_SalesRegion WHERE SalesRep_ID=?";
                    this.setC_SalesRegion_ID(DB.getSQLValue(null, sql, this.m_doc.getSalesRep_ID()));
                    if (super.getC_SalesRegion_ID() != 0) {
                        this.m_doc.setBP_C_SalesRegion_ID(super.getC_SalesRegion_ID());
                        this.log.fine("C_SalesRegion_ID=" + super.getC_SalesRegion_ID() + " (from SR)");
                    } else {
                        this.m_doc.setBP_C_SalesRegion_ID(-2);
                    }
                }
            }
            if (this.m_acct != null && super.getC_SalesRegion_ID() == 0) {
                this.setC_SalesRegion_ID(this.m_acct.getC_SalesRegion_ID());
            }
        }
        return super.getC_SalesRegion_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            this.log.fine(this.toString());
            this.getAD_Org_ID();
            this.getC_SalesRegion_ID();
            if (this.getM_Product_ID() == 0) {
                this.setM_Product_ID(this.m_acct.getM_Product_ID());
            }
            if (this.getC_LocFrom_ID() == 0) {
                this.setC_LocFrom_ID(this.m_acct.getC_LocFrom_ID());
            }
            if (this.getC_LocTo_ID() == 0) {
                this.setC_LocTo_ID(this.m_acct.getC_LocTo_ID());
            }
            if (this.getC_BPartner_ID() == 0) {
                this.setC_BPartner_ID(this.m_acct.getC_BPartner_ID());
            }
            if (this.getAD_OrgTrx_ID() == 0) {
                this.setAD_OrgTrx_ID(this.m_acct.getAD_OrgTrx_ID());
            }
            if (this.getC_Project_ID() == 0) {
                this.setC_Project_ID(this.m_acct.getC_Project_ID());
            }
            if (this.getC_Campaign_ID() == 0) {
                this.setC_Campaign_ID(this.m_acct.getC_Campaign_ID());
            }
            if (this.getC_Activity_ID() == 0) {
                this.setC_Activity_ID(this.m_acct.getC_Activity_ID());
            }
            if (this.getUser1_ID() == 0) {
                this.setUser1_ID(this.m_acct.getUser1_ID());
            }
            if (this.getUser2_ID() == 0) {
                this.setUser2_ID(this.m_acct.getUser2_ID());
            }
            if (this.getUser3_ID() == 0) {
                this.setUser3_ID(this.m_acct.getUser3_ID());
            }
            if (this.getUser4_ID() == 0) {
                this.setUser4_ID(this.m_acct.getUser4_ID());
            }
            if (this.m_doc.getDocumentType().equals("ARI") && this.m_docLine != null && this.m_docLine.getC_RevenueRecognition_ID() != 0) {
                int AD_User_ID = 0;
                this.setAccount_ID(this.createRevenueRecognition(this.m_docLine.getC_RevenueRecognition_ID(), this.m_docLine.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), AD_User_ID, this.getAccount_ID(), this.getC_SubAcct_ID(), this.getM_Product_ID(), this.getC_BPartner_ID(), this.getAD_OrgTrx_ID(), this.getC_LocFrom_ID(), this.getC_LocTo_ID(), this.getC_SalesRegion_ID(), this.getC_Project_ID(), this.getC_Campaign_ID(), this.getC_Activity_ID(), this.getUser1_ID(), this.getUser2_ID(), this.getUser3_ID(), this.getUser3_ID(), this.getUserElement1_ID(), this.getUserElement2_ID()));
            }
        }
        return true;
    }

    @Deprecated
    private int createRevenueRecognition(int C_RevenueRecognition_ID, int C_InvoiceLine_ID, int AD_Client_ID, int AD_Org_ID, int AD_User_ID, int Account_ID, int C_SubAcct_ID, int M_Product_ID, int C_BPartner_ID, int AD_OrgTrx_ID, int C_LocFrom_ID, int C_LocTo_ID, int C_SRegion_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int User1_ID, int User2_ID, int UserElement1_ID, int UserElement2_ID) {
        return this.createRevenueRecognition(C_RevenueRecognition_ID, C_InvoiceLine_ID, AD_Client_ID, AD_Org_ID, AD_User_ID, Account_ID, C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, 0, 0, UserElement1_ID, UserElement2_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createRevenueRecognition(int C_RevenueRecognition_ID, int C_InvoiceLine_ID, int AD_Client_ID, int AD_Org_ID, int AD_User_ID, int Account_ID, int C_SubAcct_ID, int M_Product_ID, int C_BPartner_ID, int AD_OrgTrx_ID, int C_LocFrom_ID, int C_LocTo_ID, int C_SRegion_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int User1_ID, int User2_ID, int User3_ID, int User4_ID, int UserElement1_ID, int UserElement2_ID) {
        this.log.fine("From Accout_ID=" + Account_ID);
        MAccount revenue = MAccount.get(this.getCtx(), AD_Client_ID, AD_Org_ID, this.getC_AcctSchema_ID(), Account_ID, C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, User3_ID, User4_ID, UserElement1_ID, UserElement2_ID, null);
        if (revenue != null && revenue.get_ID() == 0) {
            revenue.saveEx();
        }
        if (revenue == null || revenue.get_ID() == 0) {
            this.log.severe("Revenue_Acct not found");
            return Account_ID;
        }
        int P_Revenue_Acct = revenue.get_ID();
        int UnearnedRevenue_Acct = 0;
        int new_Account_ID = 0;
        String sql = "SELECT ga.UnearnedRevenue_Acct, vc.Account_ID FROM C_BP_Group_Acct ga, C_BPartner p, C_ValidCombination vc WHERE ga.C_BP_Group_ID=p.C_BP_Group_ID AND ga.UnearnedRevenue_Acct=vc.C_ValidCombination_ID AND ga.C_AcctSchema_ID=? AND p.C_BPartner_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_AcctSchema_ID());
            pstmt.setInt(2, C_BPartner_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                UnearnedRevenue_Acct = rs.getInt(1);
                new_Account_ID = rs.getInt(2);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (new_Account_ID == 0) {
            this.log.severe("UnearnedRevenue_Acct not found");
            return Account_ID;
        }
        MRevenueRecognitionPlan plan = new MRevenueRecognitionPlan(this.getCtx(), 0, null);
        plan.setC_RevenueRecognition_ID(C_RevenueRecognition_ID);
        plan.setC_AcctSchema_ID(this.getC_AcctSchema_ID());
        plan.setC_InvoiceLine_ID(C_InvoiceLine_ID);
        plan.setUnEarnedRevenue_Acct(UnearnedRevenue_Acct);
        plan.setP_Revenue_Acct(P_Revenue_Acct);
        plan.setC_Currency_ID(this.getC_Currency_ID());
        plan.setTotalAmt(this.getAcctBalance());
        if (!plan.save(this.get_TrxName())) {
            this.log.severe("Plan NOT created");
            return Account_ID;
        }
        this.log.fine("From Acctount_ID=" + Account_ID + " to " + new_Account_ID + " - Plan from UnearnedRevenue_Acct=" + UnearnedRevenue_Acct + " to Revenue_Acct=" + P_Revenue_Acct);
        return new_Account_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateReverseLine(int AD_Table_ID, int Record_ID, int Line_ID, BigDecimal quantity, BigDecimal multiplier) {
        boolean success = false;
        Object sql = "SELECT * FROM Fact_Acct WHERE C_AcctSchema_ID=? AND AD_Table_ID=? AND Record_ID=? AND Line_ID=? AND Account_ID=? AND Qty=?";
        if (MMovement.Table_ID == AD_Table_ID) {
            sql = (String)sql + " AND M_Locator_ID=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_AcctSchema_ID());
            pstmt.setInt(2, AD_Table_ID);
            pstmt.setInt(3, Record_ID);
            pstmt.setInt(4, Line_ID);
            pstmt.setInt(5, this.m_acct.getAccount_ID());
            pstmt.setBigDecimal(6, quantity.negate());
            if (MMovement.Table_ID == AD_Table_ID) {
                pstmt.setInt(7, this.getM_Locator_ID());
            }
            if ((rs = pstmt.executeQuery()).next()) {
                MFactAcct fact = new MFactAcct(this.getCtx(), rs, this.get_TrxName());
                BigDecimal dr = fact.getAmtAcctDr();
                BigDecimal cr = fact.getAmtAcctCr();
                if (MMatchInv.Table_ID == this.getAD_Table_ID()) {
                    dr = fact.getAmtAcctCr();
                    cr = fact.getAmtAcctDr();
                }
                this.setAmtAcct(fact.getC_Currency_ID(), dr.multiply(multiplier), cr.multiply(multiplier));
                BigDecimal drSourceAmt = fact.getAmtSourceDr();
                BigDecimal crSourceAmt = fact.getAmtSourceCr();
                if (MMatchInv.Table_ID == this.getAD_Table_ID()) {
                    drSourceAmt = fact.getAmtSourceCr();
                    crSourceAmt = fact.getAmtSourceDr();
                }
                this.setAmtSource(fact.getC_Currency_ID(), drSourceAmt.multiply(multiplier), crSourceAmt.multiply(multiplier));
                success = true;
                this.log.fine(new StringBuffer("(Table=").append(AD_Table_ID).append(",Record_ID=").append(Record_ID).append(",Line=").append(Record_ID).append(", Account=").append(this.m_acct).append(",dr=").append(dr).append(",cr=").append(cr).append(") - DR=").append(this.getAmtSourceDr()).append("|").append(this.getAmtAcctDr()).append(", CR=").append(this.getAmtSourceCr()).append("|").append(this.getAmtAcctCr()).toString());
                this.setAD_OrgTrx_ID(fact.getAD_OrgTrx_ID());
                this.setC_Project_ID(fact.getC_Project_ID());
                this.setC_ProjectPhase_ID(fact.getC_ProjectPhase_ID());
                this.setC_ProjectTask_ID(fact.getC_ProjectTask_ID());
                this.setC_Activity_ID(fact.getC_Activity_ID());
                this.setC_Campaign_ID(fact.getC_Campaign_ID());
                this.setC_SalesRegion_ID(fact.getC_SalesRegion_ID());
                this.setC_LocFrom_ID(fact.getC_LocFrom_ID());
                this.setC_LocTo_ID(fact.getC_LocTo_ID());
                this.setM_Product_ID(fact.getM_Product_ID());
                this.setM_Locator_ID(fact.getM_Locator_ID());
                this.setUser1_ID(fact.getUser1_ID());
                this.setUser2_ID(fact.getUser2_ID());
                this.setUser3_ID(fact.getUser3_ID());
                this.setUser4_ID(fact.getUser4_ID());
                this.setC_UOM_ID(fact.getC_UOM_ID());
                this.setC_Tax_ID(fact.getC_Tax_ID());
                this.setAD_Org_ID(fact.getAD_Org_ID());
            } else {
                this.log.warning(new StringBuffer("Not Found (try later) ").append(",C_AcctSchema_ID=").append(this.getC_AcctSchema_ID()).append(", AD_Table_ID=").append(AD_Table_ID).append(",Record_ID=").append(Record_ID).append(",Line_ID=").append(Line_ID).append(", Account_ID=").append(this.m_acct.getAccount_ID()).toString());
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, (String)sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return success;
    }
}

