/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;

public class SessionPoster {
    private static final boolean NOT_FORCED = false;
    private static final boolean NOT_REPOSTED = false;
    private int tableId = 0;
    private int[] counts;
    private int[] countErrors;
    private int[] documentTableIds = null;
    private String trxName = null;
    private String[] documentTableNames = null;
    private Properties context;
    private MAcctSchema[] accountingSchema = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    private void checkRequirements() {
        this.requireNonNullAndNonEmpty(this.accountingSchema);
    }

    private String createLogSummary() {
        StringBuilder lastSummary = new StringBuilder();
        for (int i2 = 0; i2 < this.getDocumentTableNames().length; ++i2) {
            String tableName = this.getDocumentTableNames()[i2];
            Object tableUpdateLog = "";
            if (this.counts[i2] > 0) {
                tableUpdateLog = tableName + "=" + this.counts[i2];
                if (this.countErrors[i2] > 0) {
                    tableUpdateLog = (String)tableUpdateLog + "(Errors=" + this.countErrors[i2] + ")";
                }
                this.log.finer("SessionPoster: " + (String)tableUpdateLog);
            } else {
                this.log.finer("SessionPoster: " + tableName + " - no work");
            }
            if (((String)tableUpdateLog).length() <= 0) continue;
            if (lastSummary.length() > 0) {
                lastSummary.append("-");
            }
            lastSummary.append((String)tableUpdateLog);
        }
        return lastSummary.toString();
    }

    private String findTableName(int tableIdToFind, int[] ids, String[] names) {
        String matchingName = null;
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (tableIdToFind != ids[i2]) continue;
            matchingName = names[i2];
        }
        String specificTableName = matchingName;
        return specificTableName;
    }

    public SessionPoster withAccountingSchemas(MAcctSchema[] acctSchema) {
        this.accountingSchema = this.requireNonNullAndNonEmpty(acctSchema);
        this.context = this.accountingSchema[0].getCtx();
        return this;
    }

    public SessionPoster withTableId(int tableId) {
        this.tableId = tableId;
        return this;
    }

    public SessionPoster withTransactionName(String trxName) {
        this.trxName = trxName;
        return this;
    }

    public String post() {
        this.checkRequirements();
        this.getSortedListOfUnpostedProcessedOnDates().forEach(this::postDocumentsOnDate);
        return this.createLogSummary();
    }

    Stream<BigDecimal> getSortedListOfUnpostedProcessedOnDates() {
        this.setDocumentNamesAndIds();
        String[] tableNames = this.getDocumentTableNames();
        List<BigDecimal> listProcessedOn = Doc.getListOfUnpostedProcessedOnDates(this.context, tableNames, null, this.trxName);
        Collections.sort(listProcessedOn);
        return listProcessedOn.stream();
    }

    void postDocumentsOnDate(BigDecimal processedOn) {
        int i2 = 0;
        while (i2 < this.getDocumentTableIds().length) {
            int docTableId = this.getDocumentTableIds()[i2];
            String tableName = this.getDocumentTableNames()[i2];
            int countIndex = i2++;
            Doc.streamUnpostedRecordIdsForTableOnDate(this.context, tableName, processedOn, this.trxName).forEach(recordId -> {
                int n = countIndex;
                this.counts[n] = this.counts[n] + 1;
                if (!this.postDocumentInItsOwnTransaction(docTableId, (int)recordId)) {
                    int n2 = countIndex;
                    this.countErrors[n2] = this.countErrors[n2] + 1;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean postDocumentInItsOwnTransaction(int tableId, int recordId) {
        boolean ok = true;
        String errorTrxName = null;
        String perDocTrxName = Trx.createTrxName("CAP");
        Trx innerTrx = Trx.get(perDocTrxName, true);
        String postStatus = "N";
        Doc doc = this.getDoc(tableId, recordId, perDocTrxName);
        if (doc == null) {
            this.log.log(Level.SEVERE, "Unable to find doc with tableId=" + tableId + " and recordId=" + recordId);
            innerTrx.close();
            innerTrx = null;
            return false;
        }
        try {
            String error = this.postDoc(doc);
            ok = error == null;
            postStatus = doc.getPostStatus();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, doc.get_TableName() + " " + doc.toString(), e);
            ok = false;
        }
        finally {
            if (ok) {
                innerTrx.commit();
            } else {
                innerTrx.rollback();
                this.savePostedStatus(doc, postStatus, errorTrxName);
            }
            innerTrx.close();
            innerTrx = null;
        }
        return ok;
    }

    void savePostedStatus(Doc doc, String postStatus, String errorTrxName) {
        Doc.savePostedStatus(doc, postStatus, errorTrxName);
    }

    Doc getDoc(int tableId, int recordId, String trxName) {
        return Doc.get(this.accountingSchema, tableId, recordId, trxName);
    }

    String postDoc(Doc doc) {
        return doc.post(false, false);
    }

    int[] getDocumentTableIds() {
        return this.documentTableIds;
    }

    String[] getDocumentTableNames() {
        return this.documentTableNames;
    }

    void setDocumentNamesAndIds() {
        int specificTableId = this.tableId;
        String specificTableName = null;
        int[] allIds = Doc.getDocumentsTableID();
        String[] allNames = Doc.getDocumentsTableName();
        if (specificTableId > 0) {
            specificTableName = this.findTableName(specificTableId, allIds, allNames);
            if (specificTableName != null) {
                this.documentTableIds = new int[]{specificTableId};
                this.documentTableNames = new String[]{specificTableName};
            } else {
                this.documentTableIds = new int[0];
                this.documentTableNames = new String[0];
            }
        } else {
            this.documentTableIds = allIds;
            this.documentTableNames = allNames;
        }
        this.initializeCounts();
    }

    void initializeCounts() {
        int arraySize = this.getDocumentTableIds().length;
        this.counts = new int[arraySize];
        this.countErrors = new int[arraySize];
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            this.counts[i2] = 0;
            this.countErrors[i2] = 0;
        }
    }

    MAcctSchema[] requireNonNullAndNonEmpty(MAcctSchema[] acctSchema) {
        String errMsg = "The accounting schema array was null or empty. At least one accounting Schema is required";
        MAcctSchema[] as = Objects.requireNonNull(acctSchema, errMsg);
        if (as.length == 0) {
            throw new IllegalArgumentException(errMsg);
        }
        return as;
    }
}

