/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.dbPort.ConvertMap_MariaDB;
import org.compiere.dbPort.Convert_SQL92;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.compiere.util.Util;

public class Convert_MariaDB
extends Convert_SQL92 {
    public static final int REGEX_FLAGS = 34;
    private TreeMap m_map = ConvertMap_MariaDB.getConvertMap();
    private static CLogger log = CLogger.getCLogger(Convert_MariaDB.class);

    @Override
    public boolean isOracle() {
        return false;
    }

    @Override
    protected Map getConvertMap() {
        return this.m_map;
    }

    @Override
    protected ArrayList<String> convertStatement(String sqlStatement) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedHashMap<String, String> retVars = new LinkedHashMap<String, String>();
        int found_next_fuction = ((String)sqlStatement).toUpperCase().indexOf("NEXTIDFUNC(");
        if (found_next_fuction <= 0) {
            found_next_fuction = ((String)sqlStatement).toUpperCase().indexOf("NEXTID(");
        }
        if (found_next_fuction > 0) {
            boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
            boolean adempiereSys = Ini.isPropertyBool("AdempiereSys");
            if (SYSTEM_NATIVE_SEQUENCE && !adempiereSys) {
                String function_before = ((String)sqlStatement).substring(0, found_next_fuction);
                String function_start = ((String)sqlStatement).substring(found_next_fuction);
                String function_after = function_start.substring(function_start.indexOf(")") + 1);
                String sequence = function_start.substring(function_start.indexOf("(") + 1, function_start.indexOf(","));
                int separator = function_start.indexOf("'") + 1;
                String next = function_start.substring(separator);
                String system = next.substring(0, next.indexOf("'"));
                if (system.equals("N")) {
                    String seq_name = DB.getSQLValueString(null, "SELECT Name FROM AD_Sequence WHERE AD_Sequence_ID=" + sequence, new Object[0]);
                    sqlStatement = function_before + " nextval('" + seq_name + "_seq') " + function_after;
                }
            }
        }
        Object statement = this.replaceQuotedStrings((String)sqlStatement, retVars);
        String cmpString = ((String)(statement = this.convertWithConvertMap((String)statement))).toUpperCase();
        boolean isCreate = cmpString.startsWith("CREATE ");
        if (!(isCreate && cmpString.indexOf(" FUNCTION ") != -1 || isCreate && cmpString.indexOf(" TRIGGER ") != -1 || isCreate && cmpString.indexOf(" PROCEDURE ") != -1 || isCreate && cmpString.indexOf(" VIEW ") != -1)) {
            if (isCreate && cmpString.indexOf(" TABLE ") != -1) {
                statement = this.recoverQuotedStrings((String)statement, retVars);
                retVars.clear();
                statement = this.convertDDL(this.convertComplexStatement((String)statement)) + " ENGINE=InnoDB";
            } else if (cmpString.indexOf("ALTER TABLE") != -1) {
                statement = this.recoverQuotedStrings((String)statement, retVars);
                retVars.clear();
                statement = this.convertDDL(this.convertComplexStatement((String)statement));
            } else if (cmpString.indexOf("DELETE ") != -1 && cmpString.indexOf("DELETE FROM") == -1) {
                statement = this.convertDelete((String)statement);
                statement = this.convertComplexStatement(this.convertAlias((String)statement));
            } else {
                statement = cmpString.indexOf("DELETE FROM") != -1 ? this.convertComplexStatement(this.convertAlias((String)statement)) : (cmpString.indexOf("UPDATE ") != -1 ? this.convertComplexStatement(this.convertUpdate(this.convertAlias((String)statement))) : this.convertComplexStatement(this.convertAlias((String)statement)));
            }
        }
        if (retVars.size() > 0) {
            statement = this.recoverQuotedStrings((String)statement, retVars);
        }
        result.add((String)statement);
        return result;
    }

    @Override
    protected String escapeQuotedString(String in) {
        StringBuffer out = new StringBuffer();
        boolean escape = false;
        int size = in.length();
        for (int i2 = 0; i2 < size; ++i2) {
            char c = in.charAt(i2);
            out.append(c);
            if (c != '\\') continue;
            escape = true;
            out.append(c);
        }
        if (escape) {
            return "E" + out.toString();
        }
        return out.toString();
    }

    protected String convertComplexStatement(String sqlStatement) {
        String retValue = sqlStatement;
        int found = retValue.toUpperCase().indexOf("DECODE");
        int fromIndex = 0;
        while (found != -1) {
            retValue = this.convertDecode(retValue, fromIndex);
            fromIndex = found + 6;
            found = retValue.toUpperCase().indexOf("DECODE", fromIndex);
        }
        int index = retValue.toUpperCase().indexOf("SELECT ");
        if (index != -1 && retValue.indexOf("(+)", index) != -1) {
            retValue = this.convertOuterJoin(retValue);
        }
        retValue = this.convertCast(retValue);
        return retValue;
    }

    private String convertCast(String sqlStatement) {
        String PATTERN_String = "'([^']|(''))*'";
        String PATTERN_DataType = "([\\w]+)(\\(\\d+\\))?";
        String pattern = "\\bCAST\\b[\\s]*\\([\\s]*(('([^']|(''))*')|([^\\s]+))[\\s]*AS[\\s]*(([\\w]+)(\\(\\d+\\))?)\\s*\\)";
        boolean gidx_arg1 = true;
        int gidx_arg2 = 7;
        Pattern p2 = Pattern.compile("\\bCAST\\b[\\s]*\\([\\s]*(('([^']|(''))*')|([^\\s]+))[\\s]*AS[\\s]*(([\\w]+)(\\(\\d+\\))?)\\s*\\)", 2);
        Matcher m = p2.matcher(sqlStatement);
        TreeMap convertMap = (TreeMap)this.getConvertMap();
        StringBuffer retValue = new StringBuffer(sqlStatement.length());
        while (m.find()) {
            String arg1 = m.group(1);
            String arg2 = m.group(7);
            String datatype = (String)convertMap.get("\\b" + arg2.toUpperCase() + "\\b");
            if (datatype == null) {
                datatype = arg2;
            }
            m.appendReplacement(retValue, "cast(" + arg1 + " as " + datatype + ")");
        }
        m.appendTail(retValue);
        return retValue.toString();
    }

    private String convertUpdate(String sqlStatement) {
        int charIndex;
        String targetTable = null;
        String targetAlias = null;
        String sqlUpper = sqlStatement.toUpperCase();
        StringBuffer token = new StringBuffer();
        String previousToken = null;
        int sqlLength = sqlUpper.length();
        int cnt = 0;
        boolean isUpdate = false;
        for (charIndex = 0; charIndex < sqlLength; ++charIndex) {
            char c = sqlStatement.charAt(charIndex);
            if (Character.isWhitespace(c)) {
                if (token.length() <= 0) continue;
                if (++cnt == 1) {
                    isUpdate = "UPDATE".equalsIgnoreCase(token.toString());
                } else if (cnt == 2) {
                    targetTable = token.toString();
                } else if (cnt == 3 && "SET".equalsIgnoreCase(targetAlias = token.toString().trim())) {
                    targetAlias = targetTable;
                }
                previousToken = token.toString();
                token = new StringBuffer();
                continue;
            }
            if ("SET".equalsIgnoreCase(previousToken)) break;
            token.append(c);
        }
        if (isUpdate && targetTable != null && sqlUpper.charAt(charIndex) == '(') {
            int updateFieldsBegin = charIndex;
            String updateFields = null;
            String select = "";
            String beforePreviousToken = null;
            previousToken = null;
            token = new StringBuffer();
            while (charIndex < sqlLength) {
                char c = sqlUpper.charAt(charIndex);
                if (Character.isWhitespace(c)) {
                    if (token.length() > 0) {
                        String currentToken = token.toString();
                        if ("(".equals(currentToken) || currentToken != null && currentToken.startsWith("(")) {
                            if ((")".equals(beforePreviousToken) || beforePreviousToken != null && beforePreviousToken.endsWith(")")) && "=".equals(previousToken)) {
                                select = sqlStatement.substring(charIndex - currentToken.length());
                                updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                                updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                                break;
                            }
                            if (")=".equals(previousToken)) {
                                select = sqlStatement.substring(charIndex - currentToken.length());
                                updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                                updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                                break;
                            }
                            if (previousToken != null && previousToken.endsWith(")=")) {
                                select = sqlStatement.substring(charIndex - currentToken.length());
                                updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                                updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                                break;
                            }
                        }
                        if (")=(".equals(currentToken)) {
                            select = sqlStatement.substring(charIndex - 1);
                            updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                            updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                            break;
                        }
                        if (currentToken.endsWith(")=(SELECT")) {
                            select = sqlStatement.substring(charIndex - 7);
                            updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                            updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                            break;
                        }
                        if (("=(".equals(currentToken) || currentToken != null && currentToken.startsWith("=(")) && (")".equals(previousToken) || previousToken != null && previousToken.endsWith(")"))) {
                            select = sqlStatement.substring(charIndex - currentToken.length());
                            updateFields = sqlStatement.substring(updateFieldsBegin, charIndex);
                            updateFields = updateFields.substring(0, updateFields.lastIndexOf(41));
                            break;
                        }
                        beforePreviousToken = previousToken;
                        previousToken = token.toString();
                        token = new StringBuffer();
                    }
                } else {
                    token.append(c);
                }
                ++charIndex;
            }
            if (updateFields != null && updateFields.startsWith("(")) {
                updateFields = updateFields.substring(1);
            }
            int subQueryEnd = 0;
            int subQueryStart = select.indexOf(40);
            String subWhere = null;
            int open = -1;
            for (int i2 = subQueryStart; i2 < select.length(); ++i2) {
                char c = select.charAt(i2);
                if (c == '(') {
                    ++open;
                }
                if (c == ')') {
                    --open;
                }
                if (open != -1) continue;
                subQueryEnd = i2 + 1;
                break;
            }
            Object mainWhere = "";
            String otherUpdateFields = "";
            token = new StringBuffer();
            for (int i3 = subQueryEnd; i3 < select.length(); ++i3) {
                char c = select.charAt(i3);
                if (Character.isWhitespace(c)) {
                    if (token.length() <= 0) continue;
                    if ("WHERE".equalsIgnoreCase(token.toString())) {
                        otherUpdateFields = select.substring(subQueryEnd, i3 - 5).trim();
                        mainWhere = select.substring(i3 + 1);
                        break;
                    }
                    token = new StringBuffer();
                    continue;
                }
                token.append(c);
            }
            String subQuery = select.substring(subQueryStart, subQueryEnd);
            String joinTable = null;
            String joinAlias = null;
            token = new StringBuffer();
            previousToken = null;
            int joinFieldsBegin = 0;
            String joinFields = null;
            String joinFromClause = null;
            int joinFromClauseStart = 0;
            open = -1;
            for (int i4 = 0; i4 < subQuery.length(); ++i4) {
                char c = subQuery.charAt(i4);
                if (Character.isWhitespace(c)) {
                    if (token.length() <= 0 || open >= 0) continue;
                    if ("FROM".equalsIgnoreCase(previousToken)) {
                        joinTable = token.toString();
                    }
                    if ("WHERE".equalsIgnoreCase(token.toString())) {
                        subWhere = subQuery.substring(i4 + 1, subQuery.length() - 1);
                        joinFromClause = subQuery.substring(joinFromClauseStart, i4 - 5).trim();
                        break;
                    }
                    if ("FROM".equalsIgnoreCase(token.toString())) {
                        joinFields = subQuery.substring(joinFieldsBegin, i4 - 4);
                        joinFromClauseStart = i4;
                    }
                    if (previousToken != null && previousToken.equals(joinTable)) {
                        joinAlias = token.toString();
                    }
                    previousToken = token.toString();
                    token = new StringBuffer();
                    continue;
                }
                if (joinFieldsBegin == 0) {
                    if (token.length() == 0 && ("SELECT".equalsIgnoreCase(previousToken) || previousToken != null && previousToken.toUpperCase().endsWith("SELECT"))) {
                        joinFieldsBegin = i4;
                    }
                } else if (c == '(') {
                    ++open;
                } else if (c == ')') {
                    --open;
                }
                token.append(c);
            }
            if (joinFromClause == null) {
                joinFromClause = subQuery.substring(joinFromClauseStart).trim();
            }
            if (joinAlias == null) {
                joinAlias = joinTable;
            }
            StringBuffer Update = new StringBuffer("UPDATE ");
            Update.append(targetTable);
            if (!targetAlias.equals(targetTable)) {
                Update.append(" " + targetAlias);
            }
            Update.append(" SET ");
            int f = updateFields.length();
            int fj = joinFields.length();
            String updateField = null;
            Object joinField = null;
            boolean useSubQuery = false;
            if (this.useAggregateFunction(joinFields)) {
                useSubQuery = true;
            }
            while (f > 0) {
                f = Util.findIndexOf(updateFields, ',');
                if (f < 0) {
                    updateField = updateFields;
                    joinField = joinFields.trim();
                    if (((String)joinField).indexOf(46) < 0 && this.isIdentifier((String)joinField)) {
                        joinField = joinAlias + "." + (String)joinField;
                    }
                    Update.append(updateField.trim());
                    Update.append("=");
                    if (useSubQuery) {
                        Update.append("( SELECT ");
                        Update.append((String)joinField);
                        Update.append(" FROM ");
                        Update.append(joinFromClause);
                        Update.append(" WHERE ");
                        Update.append(subWhere.trim());
                        Update.append(" ) ");
                        Update.append(otherUpdateFields);
                        if (mainWhere != null) {
                            Update.append(" WHERE ");
                            Update.append((String)mainWhere);
                        }
                    } else {
                        Update.append((String)joinField);
                        Update.append(otherUpdateFields);
                        Update.append(" FROM ");
                        Update.append(joinFromClause);
                        Update.append(" WHERE ");
                        subWhere = this.addAliasToIdentifier(subWhere, joinAlias);
                        Update.append(subWhere.trim());
                        mainWhere = mainWhere != null ? " AND " + (String)mainWhere : "";
                        mainWhere = this.addAliasToIdentifier((String)mainWhere, targetAlias);
                        Update.append((String)mainWhere);
                    }
                } else {
                    updateField = updateFields.substring(0, f);
                    fj = Util.findIndexOf(joinFields, ',');
                    Object object = joinField = fj > 0 ? joinFields.substring(0, fj).trim() : joinFields.trim();
                    if (((String)joinField).indexOf(46) < 0 && this.isIdentifier((String)joinField)) {
                        joinField = joinAlias + "." + (String)joinField;
                    }
                    Update.append(updateField.trim());
                    Update.append("=");
                    if (useSubQuery) {
                        Update.append("( SELECT ");
                        Update.append((String)joinField);
                        Update.append(" FROM ");
                        Update.append(joinFromClause);
                        Update.append(" WHERE ");
                        Update.append(subWhere.trim());
                        Update.append(" ) ");
                    } else {
                        Update.append((String)joinField);
                    }
                    Update.append(",");
                    joinFields = joinFields.substring(fj + 1);
                }
                updateFields = updateFields.substring(f + 1);
            }
            return Update.toString();
        }
        return sqlStatement;
    }

    private boolean useAggregateFunction(String fields) {
        String fieldsUpper = fields.toUpperCase();
        int size = fieldsUpper.length();
        StringBuffer buffer = new StringBuffer();
        String token = null;
        for (int i2 = 0; i2 < size; ++i2) {
            char ch = fieldsUpper.charAt(i2);
            if (Character.isWhitespace(ch)) {
                if (buffer.length() <= 0) continue;
                token = buffer.toString();
                buffer = new StringBuffer();
                continue;
            }
            if (this.isOperator(ch)) {
                if (buffer.length() > 0) {
                    token = buffer.toString();
                    buffer = new StringBuffer();
                } else {
                    token = null;
                }
                if (ch != '(' || token == null || !token.equals("SUM") && !token.equals("MAX") && !token.equals("MIN") && !token.equals("COUNT") && !token.equals("AVG")) continue;
                return true;
            }
            buffer.append(ch);
        }
        return false;
    }

    private String addAliasToIdentifier(String where, String alias) {
        String sqlkey = "AND,OR,FROM,WHERE,JOIN,BY,GROUP,IN,INTO,SELECT,NOT,SET,UPDATE,DELETE,HAVING,IS,NULL,EXISTS,BETWEEN,LIKE,INNER,OUTER";
        StringTokenizer st = new StringTokenizer(where);
        Object result = "";
        String token = "";
        int o = -1;
        do {
            String test;
            String string = test = (token = st.nextToken()).startsWith("(") ? token.substring(1) : token;
            if (sqlkey.indexOf(test) == -1) {
                token = token.trim();
                if (o != -1) {
                    result = (String)result + " " + token;
                } else {
                    result = (String)result + " ";
                    StringBuffer t = new StringBuffer();
                    for (int i2 = 0; i2 < token.length(); ++i2) {
                        char c = token.charAt(i2);
                        if (this.isOperator(c)) {
                            if (t.length() > 0) {
                                result = c == '(' ? (String)result + t.toString() : (this.isIdentifier(t.toString()) && t.toString().indexOf(46) == -1 ? (String)result + alias + "." + t.toString() : (String)result + t.toString());
                                t = new StringBuffer();
                            }
                            result = (String)result + c;
                            continue;
                        }
                        t.append(c);
                    }
                    if (t.length() > 0) {
                        if ("SELECT".equalsIgnoreCase(t.toString().toUpperCase())) {
                            o = 0;
                            result = (String)result + t.toString();
                        } else {
                            result = this.isIdentifier(t.toString()) && t.toString().indexOf(46) == -1 ? (String)result + alias + "." + t.toString() : (String)result + t.toString();
                        }
                    }
                }
                if (o == -1) continue;
                for (int i3 = 0; i3 < token.length(); ++i3) {
                    char c = token.charAt(i3);
                    if (c == '(') {
                        ++o;
                    }
                    if (c != ')') continue;
                    --o;
                }
            } else {
                result = (String)result + " " + token;
                if (!"SELECT".equalsIgnoreCase(test)) continue;
                o = 0;
            }
        } while (st.hasMoreElements());
        return result;
    }

    private boolean isIdentifier(String token) {
        int size = token.length();
        for (int i2 = 0; i2 < size; ++i2) {
            char c = token.charAt(i2);
            if (!this.isOperator(c)) continue;
            return false;
        }
        if (token.startsWith("'") && token.endsWith("'")) {
            return false;
        }
        try {
            new BigDecimal(token);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            return !this.isSQLFunctions(token);
        }
    }

    private boolean isSQLFunctions(String token) {
        if (token.equalsIgnoreCase("current_timestamp")) {
            return true;
        }
        if (token.equalsIgnoreCase("current_time")) {
            return true;
        }
        if (token.equalsIgnoreCase("current_date")) {
            return true;
        }
        if (token.equalsIgnoreCase("localtime")) {
            return true;
        }
        return token.equalsIgnoreCase("localtimestamp");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertAlias(String sqlStatement) {
        String[] tokens = sqlStatement.split("\\s");
        String table2 = null;
        String alias = null;
        if ("UPDATE".equalsIgnoreCase(tokens[0])) {
            if ("SET".equalsIgnoreCase(tokens[2])) {
                return sqlStatement;
            }
            table2 = tokens[1];
            alias = tokens[2];
        } else if ("INSERT".equalsIgnoreCase(tokens[0])) {
            if ("VALUES".equalsIgnoreCase(tokens[3])) return sqlStatement;
            if ("SELECT".equalsIgnoreCase(tokens[3])) {
                return sqlStatement;
            }
            if (tokens[2].indexOf(40) > 0) {
                return sqlStatement;
            }
            if (tokens[3].indexOf(40) >= 0) {
                if (tokens[3].indexOf(40) <= 0) return sqlStatement;
            }
            table2 = tokens[2];
            alias = tokens[3];
        } else if ("DELETE".equalsIgnoreCase(tokens[0])) {
            if (tokens.length < 4) {
                return sqlStatement;
            }
            if ("WHERE".equalsIgnoreCase(tokens[3])) {
                return sqlStatement;
            }
            table2 = tokens[2];
            alias = tokens[3];
        }
        if (table2 == null) return sqlStatement;
        if (alias == null) return sqlStatement;
        if (alias.indexOf(40) > 0) {
            alias = alias.substring(0, alias.indexOf(40));
        }
        String converted = sqlStatement.replaceFirst("\\s" + alias + "\\s", " ");
        converted = converted.replaceAll("\\b" + alias + "\\.", table2 + ".");
        converted = converted.replaceAll("[+]" + alias + "\\.", "+" + table2 + ".");
        converted = converted.replaceAll("[-]" + alias + "\\.", "-" + table2 + ".");
        converted = converted.replaceAll("[*]" + alias + "\\.", "*" + table2 + ".");
        converted = converted.replaceAll("[/]" + alias + "\\.", "/" + table2 + ".");
        converted = converted.replaceAll("[%]" + alias + "\\.", "%" + table2 + ".");
        converted = converted.replaceAll("[<]" + alias + "\\.", "<" + table2 + ".");
        converted = converted.replaceAll("[>]" + alias + "\\.", ">" + table2 + ".");
        converted = converted.replaceAll("[=]" + alias + "\\.", "=" + table2 + ".");
        converted = converted.replaceAll("[|]" + alias + "\\.", "|" + table2 + ".");
        converted = converted.replaceAll("[(]" + alias + "\\.", "(" + table2 + ".");
        return converted.replaceAll("[)]" + alias + "\\.", ")" + table2 + ".");
    }

    private String convertDDL(String sqlStatement) {
        if (sqlStatement.toUpperCase().indexOf("ALTER TABLE ") == 0) {
            String action = null;
            int begin_col = -1;
            if (sqlStatement.toUpperCase().indexOf(" MODIFY ") > 0) {
                action = " MODIFY ";
                begin_col = sqlStatement.toUpperCase().indexOf(" MODIFY ") + action.length();
            } else if (sqlStatement.toUpperCase().indexOf(" ADD ") > 0 && sqlStatement.toUpperCase().indexOf(" ADD CONSTRAINT ") < 0 && sqlStatement.toUpperCase().indexOf(" ADD FOREIGN KEY ") < 0) {
                action = " ADD ";
                begin_col = sqlStatement.toUpperCase().indexOf(" ADD ") + action.length();
            }
            if (begin_col < 0) {
                return sqlStatement;
            }
            int end_col = 0;
            int begin_default = -1;
            String column = null;
            String type = null;
            String defaultvalue = null;
            String nullclause = null;
            Object DDL = null;
            if (begin_col != -1) {
                column = sqlStatement.substring(begin_col);
                end_col = begin_col + column.indexOf(32);
                column = sqlStatement.substring(begin_col, end_col);
                String rest = sqlStatement.substring(end_col + 1);
                if (action.equals(" ADD ")) {
                    if (rest.toUpperCase().indexOf(" DEFAULT ") != -1) {
                        String beforeDefault = rest.substring(0, rest.toUpperCase().indexOf(" DEFAULT "));
                        begin_default = rest.toUpperCase().indexOf(" DEFAULT ") + 9;
                        defaultvalue = rest.substring(begin_default);
                        int nextspace = defaultvalue.indexOf(32);
                        if (nextspace > -1) {
                            rest = defaultvalue.substring(nextspace);
                            defaultvalue = defaultvalue.substring(0, defaultvalue.indexOf(32));
                        } else {
                            rest = "";
                        }
                        DDL = defaultvalue.equalsIgnoreCase("NULL") ? sqlStatement.substring(0, begin_col - action.length()) + " ADD COLUMN " + column + " " + beforeDefault.trim() + " DEFAULT " + defaultvalue.trim() + " " + rest.trim() : (defaultvalue.startsWith("'") && defaultvalue.endsWith("'") ? sqlStatement.substring(0, begin_col - action.length()) + " ADD COLUMN " + column + " " + beforeDefault.trim() + " DEFAULT " + defaultvalue.trim() + " " + rest.trim() : sqlStatement.substring(0, begin_col - action.length()) + " ADD COLUMN " + column + " " + beforeDefault.trim() + " DEFAULT '" + defaultvalue.trim() + "' " + rest.trim());
                    } else {
                        DDL = sqlStatement.substring(0, begin_col - action.length()) + action + "COLUMN " + column + " " + rest.trim();
                    }
                } else if (action.equals(" MODIFY ")) {
                    if ((rest = rest.trim()).toUpperCase().startsWith("NOT ") || rest.toUpperCase().startsWith("NULL ") || rest.toUpperCase().equals("NULL") || rest.toUpperCase().equals("NOT NULL")) {
                        type = null;
                    } else {
                        int typeEnd = rest.indexOf(32);
                        type = typeEnd > 0 ? rest.substring(0, typeEnd).trim() : rest;
                        String string = rest = typeEnd > 0 ? rest.substring(typeEnd) : "";
                    }
                    if (rest.toUpperCase().indexOf(" DEFAULT ") != -1) {
                        begin_default = rest.toUpperCase().indexOf(" DEFAULT ") + 9;
                        defaultvalue = rest.substring(begin_default);
                        int nextspace = defaultvalue.indexOf(32);
                        if (nextspace > -1) {
                            rest = defaultvalue.substring(nextspace);
                            defaultvalue = defaultvalue.substring(0, defaultvalue.indexOf(32));
                        } else {
                            rest = "";
                        }
                        defaultvalue = defaultvalue.trim();
                        if (defaultvalue.startsWith("'") && defaultvalue.endsWith("'")) {
                            defaultvalue = defaultvalue.substring(1, defaultvalue.length() - 1);
                        }
                        if (rest != null && rest.toUpperCase().indexOf("NOT NULL") >= 0) {
                            nullclause = "NOT NULL";
                        } else if (rest != null && rest.toUpperCase().indexOf("NULL") >= 0) {
                            nullclause = "NULL";
                        }
                    } else if (rest != null && rest.toUpperCase().indexOf("NOT NULL") >= 0) {
                        nullclause = "NOT NULL";
                    } else if (rest != null && rest.toUpperCase().indexOf("NULL") >= 0) {
                        nullclause = "NULL";
                    }
                    DDL = sqlStatement;
                }
                return DDL;
            }
        }
        return sqlStatement;
    }
}

