/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import io.vavr.CheckedFunction1;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPeriod;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ResultSetIterable;

public class CalloutGLJournal
extends CalloutEngine {
    public String period(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        String colName = gridField.getColumnName();
        if (value == null) {
            return "";
        }
        int clientId = Env.getContextAsInt(ctx, windowNo, "AD_Client_ID");
        Timestamp dateAcct = null;
        dateAcct = colName.equals("DateAcct") ? (Timestamp)value : (Timestamp)gridTab.getValue("DateAcct");
        int periodId = 0;
        if (colName.equals("C_Period_ID")) {
            periodId = (Integer)value;
        }
        if (colName.equals("DateDoc")) {
            gridTab.setValue("DateAcct", value);
        } else if (colName.equals("DateAcct")) {
            String sql = "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive = ? AND PeriodType IN ( ? , ? )";
            DB.runResultSetFunction.apply(null, (Object)"SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive = ? AND PeriodType IN ( ? , ? )", (Object)List.of((Object[])new Object[]{clientId, dateAcct, "Y", "S", "A"}), resultSet -> new ResultSetIterable((ResultSet)resultSet, (CheckedFunction1 & Serializable)row -> {
                int periodIdBasedOnAcctDate = row.getInt("C_Period_ID");
                gridTab.setValue("C_Period_ID", (Object)periodIdBasedOnAcctDate);
                return periodIdBasedOnAcctDate;
            }).toList());
        } else {
            Option maybePeriod = Option.of((Object)MPeriod.get(ctx, periodId));
            Option maybeDateAcct = Option.of((Object)dateAcct);
            maybePeriod.peek(period -> {
                String periodType = period.getPeriodType();
                Timestamp startDate = period.getStartDate();
                Timestamp endDate = period.getEndDate();
                if (periodType.equals("S") || periodType.equals("A")) {
                    maybeDateAcct.peek(finalDateAcct -> {
                        if (finalDateAcct.before(startDate) || finalDateAcct.after(endDate)) {
                            gridTab.setValue("DateAcct", (Object)endDate);
                        }
                    });
                }
            });
        }
        return "";
    }

    @Override
    public String rate(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        if (value == null) {
            return "";
        }
        int currencyId = (Integer)gridTab.getValue("C_Currency_ID");
        int conversionTypeId = (Integer)gridTab.getValue("C_ConversionType_ID");
        Timestamp dateAcct = (Timestamp)gridTab.getValue("DateAcct");
        if (dateAcct == null) {
            dateAcct = new Timestamp(System.currentTimeMillis());
        }
        int acctSchemaId = Env.getContextAsInt(ctx, windowNo, "C_AcctSchema_ID");
        MAcctSchema acctSchema = MAcctSchema.get(ctx, acctSchemaId);
        int clientId = Env.getContextAsInt(ctx, windowNo, "AD_Client_ID");
        int orgId = Env.getContextAsInt(ctx, windowNo, "AD_Org_ID");
        BigDecimal currencyRate = MConversionRate.getRate(currencyId, acctSchema.getC_Currency_ID(), dateAcct, conversionTypeId, clientId, orgId);
        this.log.fine("rate = " + currencyRate);
        if (currencyRate == null) {
            currencyRate = Env.ZERO;
        }
        gridTab.setValue("CurrencyRate", (Object)currencyRate);
        return "";
    }

    public String amt(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        BigDecimal amtSourceCr;
        BigDecimal amtSourceDr;
        String colName = gridField.getColumnName();
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        int acctSchemaId = Env.getContextAsInt(ctx, windowNo, "C_AcctSchema_ID");
        MAcctSchema acctSchema = MAcctSchema.get(ctx, acctSchemaId);
        int precision = acctSchema.getStdPrecision();
        BigDecimal currencyRate = (BigDecimal)gridTab.getValue("CurrencyRate");
        if (currencyRate == null) {
            currencyRate = Env.ONE;
            gridTab.setValue("CurrencyRate", (Object)currencyRate);
        }
        if ((amtSourceDr = (BigDecimal)gridTab.getValue("AmtSourceDr")) == null) {
            amtSourceDr = Env.ZERO;
        }
        if ((amtSourceCr = (BigDecimal)gridTab.getValue("AmtSourceCr")) == null) {
            amtSourceCr = Env.ZERO;
        }
        BigDecimal amtAcctDr = amtSourceDr.multiply(currencyRate);
        amtAcctDr = amtAcctDr.setScale(precision, 4);
        gridTab.setValue("AmtAcctDr", (Object)amtAcctDr);
        BigDecimal amtAcctCr = amtSourceCr.multiply(currencyRate);
        amtAcctCr = amtAcctCr.setScale(precision, 4);
        gridTab.setValue("AmtAcctCr", (Object)amtAcctCr);
        return "";
    }

    public String account(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        String colName = gridField.getColumnName();
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        if (colName.equals("Account_ID") || colName.equals("C_SubAcct_ID") || colName.equals("M_Product_ID") || colName.equals("C_BPartner_ID") || colName.equals("AD_OrgTrx_ID") || colName.equals("AD_Org_ID") || colName.equals("C_LocFrom_ID") || colName.equals("C_LocTo_ID") || colName.equals("C_SalesRegion_ID") || colName.equals("C_Project_ID") || colName.equals("C_Campaign_ID") || colName.equals("C_Activity_ID") || colName.equals("User1_ID") || colName.equals("User2_ID") || colName.equals("User3_ID") || colName.equals("User4_ID") || colName.equals("UserElement1_ID") || colName.equals("UserElement2_ID")) {
            gridTab.setValue("C_ValidCombination_ID", null);
            gridTab.setValue("Alias_ValidCombination_ID", null);
        }
        return "";
    }

    public String alias(Properties ctx, int windowNo, GridTab gridTab, GridField gridField, Object value) {
        String colName = gridField.getColumnName();
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        Integer validCombinationId = (Integer)value;
        if (colName.equals("Alias_ValidCombination_ID")) {
            gridTab.setValue("C_ValidCombination_ID", (Object)validCombinationId);
        }
        if (colName.equals("C_ValidCombination_ID")) {
            gridTab.setValue("Alias_ValidCombination_ID", (Object)validCombinationId);
        }
        if (colName.equals("C_ValidCombination_ID") || colName.equals("Alias_ValidCombination_ID")) {
            MAccount validCombination = new MAccount(ctx, validCombinationId, null);
            gridTab.setValue("Account_ID", validCombination.getAccount_ID() != 0 ? Integer.valueOf(validCombination.getAccount_ID()) : null);
            gridTab.setValue("C_SubAcct_ID", validCombination.getC_SubAcct_ID() != 0 ? Integer.valueOf(validCombination.getC_SubAcct_ID()) : null);
            gridTab.setValue("M_Product_ID", validCombination.getM_Product_ID() != 0 ? Integer.valueOf(validCombination.getM_Product_ID()) : null);
            gridTab.setValue("C_BPartner_ID", validCombination.getC_BPartner_ID() != 0 ? Integer.valueOf(validCombination.getC_BPartner_ID()) : null);
            gridTab.setValue("AD_OrgTrx_ID", validCombination.getAD_OrgTrx_ID() != 0 ? Integer.valueOf(validCombination.getAD_OrgTrx_ID()) : null);
            gridTab.setValue("AD_Org_ID", validCombination.getAD_Org_ID() != 0 ? Integer.valueOf(validCombination.getAD_Org_ID()) : null);
            gridTab.setValue("C_LocFrom_ID", validCombination.getC_LocFrom_ID() != 0 ? Integer.valueOf(validCombination.getC_LocFrom_ID()) : null);
            gridTab.setValue("C_LocTo_ID", validCombination.getC_LocTo_ID() != 0 ? Integer.valueOf(validCombination.getC_LocTo_ID()) : null);
            gridTab.setValue("C_SalesRegion_ID", validCombination.getC_SalesRegion_ID() != 0 ? Integer.valueOf(validCombination.getC_SalesRegion_ID()) : null);
            gridTab.setValue("C_Project_ID", validCombination.getC_Project_ID() != 0 ? Integer.valueOf(validCombination.getC_Project_ID()) : null);
            gridTab.setValue("C_Campaign_ID", validCombination.getC_Campaign_ID() != 0 ? Integer.valueOf(validCombination.getC_Campaign_ID()) : null);
            gridTab.setValue("C_Activity_ID", validCombination.getC_Activity_ID() != 0 ? Integer.valueOf(validCombination.getC_Activity_ID()) : null);
            gridTab.setValue("User1_ID", validCombination.getUser1_ID() != 0 ? Integer.valueOf(validCombination.getUser1_ID()) : null);
            gridTab.setValue("User2_ID", validCombination.getUser2_ID() != 0 ? Integer.valueOf(validCombination.getUser2_ID()) : null);
            gridTab.setValue("User3_ID", validCombination.getUser3_ID() != 0 ? Integer.valueOf(validCombination.getUser3_ID()) : null);
            gridTab.setValue("User4_ID", validCombination.getUser4_ID() != 0 ? Integer.valueOf(validCombination.getUser4_ID()) : null);
            gridTab.setValue("UserElement1_ID", validCombination.getUserElement1_ID() != 0 ? Integer.valueOf(validCombination.getUserElement1_ID()) : null);
            gridTab.setValue("UserElement2_ID", validCombination.getUserElement2_ID() != 0 ? Integer.valueOf(validCombination.getUserElement2_ID()) : null);
        }
        return "";
    }
}

