/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridTabVO;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.spin.util.ASPUtil;

public class GridWindowVO
implements Serializable {
    private static final long serialVersionUID = 6884332743173214735L;
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID = 0;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public String WindowType = "";
    public int AD_Image_ID = 0;
    public int AD_Color_ID = 0;
    public String IsReadWrite = null;
    public int WinWidth = 0;
    public int WinHeight = 0;
    public boolean IsSOTrx = false;
    public ArrayList<GridTabVO> Tabs = null;
    public int AD_Table_ID = 0;
    public static final String WINDOWTYPE_QUERY = "Q";
    public static final String WINDOWTYPE_TRX = "T";
    public static final String WINDOWTYPE_MMAINTAIN = "M";

    public static GridWindowVO create(Properties ctx, int WindowNo, int AD_Window_ID) {
        return GridWindowVO.create(ctx, WindowNo, AD_Window_ID, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridWindowVO create(Properties ctx, int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        String IsReadOnly2;
        ResultSet rs;
        CPreparedStatement pstmt;
        CharSequence sql;
        CLogger.get().config("#" + WindowNo + " - AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        GridWindowVO vo = new GridWindowVO(ctx, WindowNo);
        vo.AD_Window_ID = AD_Window_ID;
        if (vo.AD_Window_ID == 0 && AD_Menu_ID != 0) {
            sql = "SELECT AD_Window_ID, IsSOTrx, IsReadOnly FROM AD_Menu WHERE AD_Menu_ID=? AND Action='W'";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, AD_Menu_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    vo.AD_Window_ID = rs.getInt(1);
                    String IsSOTrx = rs.getString(2);
                    Env.setContext(ctx, WindowNo, "IsSOTrx", IsSOTrx != null && IsSOTrx.equals("Y"));
                    IsReadOnly2 = rs.getString(3);
                    vo.IsReadWrite = IsReadOnly2 != null && IsReadOnly2.equals("Y") ? "Y" : "N";
                }
            }
            catch (SQLException e) {
                GridWindowVO IsReadOnly2;
                try {
                    CLogger.get().log(Level.SEVERE, "Menu", e);
                    IsReadOnly2 = null;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return IsReadOnly2;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            CLogger.get().config("AD_Window_ID=" + vo.AD_Window_ID);
        }
        sql = new StringBuffer("SELECT Name,Description,Help,WindowType, AD_Color_ID,AD_Image_ID,WinHeight,WinWidth, IsSOTrx ");
        if (Env.isBaseLanguage(vo.ctx, "AD_Window")) {
            ((StringBuffer)sql).append("FROM AD_Window w WHERE w.AD_Window_ID=? AND w.IsActive='Y'");
        } else {
            ((StringBuffer)sql).append("FROM AD_Window_vt w WHERE w.AD_Window_ID=?").append(" AND AD_Language='").append(Env.getAD_Language(vo.ctx)).append("'");
        }
        pstmt = null;
        rs = null;
        try {
            pstmt = DB.prepareStatement(((StringBuffer)sql).toString(), null);
            pstmt.setInt(1, vo.AD_Window_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                vo.Name = rs.getString(1);
                vo.Description = rs.getString(2);
                if (vo.Description == null) {
                    vo.Description = "";
                }
                vo.Help = rs.getString(3);
                if (vo.Help == null) {
                    vo.Help = "";
                }
                vo.WindowType = rs.getString(4);
                vo.AD_Color_ID = rs.getInt(5);
                vo.AD_Image_ID = rs.getInt(6);
                vo.WinHeight = rs.getInt(7);
                vo.WinWidth = rs.getInt(8);
                vo.IsSOTrx = "Y".equals(rs.getString(9));
            } else {
                vo = null;
            }
        }
        catch (SQLException ex) {
            CLogger.get().log(Level.SEVERE, ((StringBuffer)sql).toString(), ex);
            IsReadOnly2 = null;
            return IsReadOnly2;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRole role = MRole.getDefault(ctx, false);
        Boolean windowAccess = false;
        if (vo != null) {
            windowAccess = role.getWindowAccess(vo.AD_Window_ID);
        }
        if (vo != null && windowAccess == null) {
            vo = null;
        }
        if (vo != null && windowAccess != null) {
            String string = vo.IsReadWrite = windowAccess != false ? "Y" : "N";
        }
        if (vo == null) {
            CLogger.get().log(Level.SEVERE, "No Window - AD_Window_ID=" + AD_Window_ID + ", AD_Role_ID=" + role + " - " + (StringBuffer)sql);
            CLogger.get().saveError("AccessTableNoView", "(Not found)");
            return null;
        }
        if (vo.IsReadWrite == null) {
            CLogger.get().saveError("AccessTableNoView", "(found)");
            return null;
        }
        GridWindowVO.createTabs(vo);
        if (vo.Tabs == null || vo.Tabs.size() == 0) {
            return null;
        }
        return vo;
    }

    private static boolean createTabs(GridWindowVO mWindowVO) {
        mWindowVO.Tabs = new ArrayList();
        boolean firstTab = true;
        int tabNo = 0;
        for (MTab tab : ASPUtil.getInstance(mWindowVO.ctx).getWindowTabs(mWindowVO.AD_Window_ID)) {
            GridTabVO mTabVO;
            if (!tab.isActive()) continue;
            if (mWindowVO.AD_Table_ID == 0) {
                mWindowVO.AD_Table_ID = tab.getAD_Table_ID();
            }
            if ((mTabVO = GridTabVO.create(mWindowVO, tabNo, tab, mWindowVO.WindowType.equals(WINDOWTYPE_QUERY), mWindowVO.WindowType.equals(WINDOWTYPE_TRX))) == null && firstTab) break;
            if (mTabVO == null) continue;
            if (!mTabVO.IsReadOnly && "N".equals(mWindowVO.IsReadWrite)) {
                mTabVO.IsReadOnly = true;
            }
            mWindowVO.Tabs.add(mTabVO);
            ++tabNo;
            firstTab = false;
        }
        if (tabNo == 0 || mWindowVO.Tabs.size() == 0) {
            CLogger.get().log(Level.SEVERE, "No Tabs - AD_Window_ID = " + mWindowVO.AD_Window_ID);
            return false;
        }
        Env.setContext(mWindowVO.ctx, mWindowVO.WindowNo, "BaseTable_ID", mWindowVO.AD_Table_ID);
        return true;
    }

    private GridWindowVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        for (int i = 0; i < this.Tabs.size(); ++i) {
            GridTabVO tab = this.Tabs.get(i);
            tab.setCtx(newCtx);
        }
    }

    public GridWindowVO clone(int windowNo) {
        GridWindowVO clone = null;
        try {
            clone = new GridWindowVO(this.ctx, windowNo);
            clone.AD_Window_ID = this.AD_Window_ID;
            clone.Name = this.Name;
            clone.Description = this.Description;
            clone.Help = this.Help;
            clone.WindowType = this.WindowType;
            clone.AD_Image_ID = this.AD_Image_ID;
            clone.AD_Color_ID = this.AD_Color_ID;
            clone.IsReadWrite = this.IsReadWrite;
            clone.WinWidth = this.WinWidth;
            clone.WinHeight = this.WinHeight;
            clone.IsSOTrx = this.IsSOTrx;
            Env.setContext(this.ctx, windowNo, "IsSOTrx", clone.IsSOTrx);
            clone.AD_Table_ID = this.AD_Table_ID;
            Env.setContext(this.ctx, windowNo, "BaseTable_ID", clone.AD_Table_ID);
            clone.Tabs = new ArrayList();
            for (int i = 0; i < this.Tabs.size(); ++i) {
                GridTabVO tab = this.Tabs.get(i);
                GridTabVO cloneTab = tab.clone(clone.ctx, windowNo);
                if (cloneTab == null) {
                    return null;
                }
                clone.Tabs.add(cloneTab);
            }
        }
        catch (Exception e) {
            clone = null;
        }
        return clone;
    }
}

