/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.awt.Paint;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_Chart;
import org.compiere.model.MChartDatasource;
import org.compiere.model.MQuery;
import org.compiere.model.Query;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class MChart
extends X_AD_Chart {
    private static final long serialVersionUID = -8851465915516536910L;
    private int windowNo = 0;
    private Dataset dataset;
    private HashMap<String, MQuery> queries;

    public MChart(Properties ctx, int AD_Chart_ID, String trxName) {
        super(ctx, AD_Chart_ID, trxName);
    }

    public MChart(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void loadData() {
        this.queries = new HashMap();
        for (MChartDatasource ds : this.getDatasources()) {
            ds.addData(this);
        }
    }

    public CategoryDataset getCategoryDataset() {
        this.dataset = new DefaultCategoryDataset();
        this.loadData();
        return (CategoryDataset)this.dataset;
    }

    public IntervalXYDataset getXYDataset() {
        this.dataset = new TimeSeriesCollection();
        this.loadData();
        return (IntervalXYDataset)this.dataset;
    }

    public PieDataset getPieDataset() {
        this.dataset = new DefaultPieDataset();
        this.loadData();
        return (PieDataset)this.dataset;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private List<MChartDatasource> getDatasources() {
        return new Query(this.getCtx(), "AD_ChartDatasource", "AD_Chart_ID=?", null).setParameters(this.getAD_Chart_ID()).setOnlyActiveRecords(true).list();
    }

    public HashMap<String, MQuery> getQueries() {
        return this.queries;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public MQuery getQuery(String key) {
        if (this.queries.containsKey(key)) {
            return this.queries.get(key);
        }
        return null;
    }

    public JFreeChart createChart() {
        String type = this.getChartType();
        if ("BC".equals(type)) {
            if (this.isTimeSeries()) {
                return this.createXYBarChart();
            }
            return this.createBarChart();
        }
        if ("B3".equals(type)) {
            return this.create3DBarChart();
        }
        if ("BS".equals(type)) {
            if (this.isTimeSeries()) {
                return this.createXYBarChart();
            }
            return this.createStackedBarChart();
        }
        if ("B4".equals(type)) {
            return this.create3DStackedBarChart();
        }
        if ("P3".equals(type)) {
            return this.create3DPieChart();
        }
        if ("PC".equals(type)) {
            return this.createPieChart();
        }
        if ("L3".equals(type)) {
            return this.create3DLineChart();
        }
        if ("AC".equals(type)) {
            return this.createAreaChart();
        }
        if ("AS".equals(type)) {
            return this.createStackedAreaChart();
        }
        if ("LC".equals(type)) {
            if (this.isTimeSeries()) {
                return this.createTimeSeriesChart();
            }
            return this.createLineChart();
        }
        if ("RC".equals(type)) {
            return this.createRingChart();
        }
        if ("WC".equals(type)) {
            return this.createWaterfallChart();
        }
        throw new IllegalArgumentException("unknown chart type=" + type);
    }

    private JFreeChart createXYBarChart() {
        JFreeChart chart = ChartFactory.createXYBarChart((String)this.getName(), (String)this.getDomainLabel(), (boolean)true, (String)this.getRangeLabel(), (IntervalXYDataset)this.getXYDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createTimeSeriesChart() {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (XYDataset)this.getXYDataset(), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createWaterfallChart() {
        JFreeChart chart = ChartFactory.createWaterfallChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createRingChart() {
        JFreeChart chart = ChartFactory.createRingChart((String)this.getName(), (PieDataset)this.getPieDataset(), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createPieChart() {
        JFreeChart chart = ChartFactory.createPieChart((String)this.getName(), (PieDataset)this.getPieDataset(), (boolean)false, (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart create3DPieChart() {
        JFreeChart chart = ChartFactory.createPieChart3D((String)this.getName(), (PieDataset)this.getPieDataset(), (boolean)false, (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createBarChart() {
        JFreeChart chart = ChartFactory.createBarChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        BarRenderer renderer = new BarRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart create3DBarChart() {
        JFreeChart chart = ChartFactory.createBarChart3D((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createStackedBarChart() {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        BarRenderer renderer = new BarRenderer();
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart create3DStackedBarChart() {
        JFreeChart chart = ChartFactory.createStackedBarChart3D((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createAreaChart() {
        JFreeChart chart = ChartFactory.createAreaChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createStackedAreaChart() {
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createLineChart() {
        JFreeChart chart = ChartFactory.createLineChart((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart create3DLineChart() {
        JFreeChart chart = ChartFactory.createLineChart3D((String)this.getName(), (String)this.getDomainLabel(), (String)this.getRangeLabel(), (CategoryDataset)this.getCategoryDataset(), (PlotOrientation)("H".equals(this.getChartOrientation()) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)this.isDisplayLegend(), (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private void setupCategoryChart(JFreeChart chart) {
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis xAxis = plot.getDomainAxis();
        xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)Color.BLUE);
        renderer.setSeriesPaint(2, (Paint)Color.YELLOW);
        renderer.setSeriesPaint(3, (Paint)Color.GREEN);
        renderer.setSeriesPaint(4, (Paint)Color.ORANGE);
        renderer.setSeriesPaint(5, (Paint)Color.CYAN);
        renderer.setSeriesPaint(6, (Paint)Color.MAGENTA);
        renderer.setSeriesPaint(7, (Paint)Color.GRAY);
        renderer.setSeriesPaint(8, (Paint)Color.PINK);
        plot.setRenderer(renderer);
    }
}

