/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_CostQueue;
import org.adempiere.engine.CostComponent;
import org.adempiere.exceptions.CostInsufficientQtyException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCostQueue
extends X_M_CostQueue {
    private static final long serialVersionUID = -1782836708418500130L;
    private static CLogger s_log = CLogger.getCLogger(MCostQueue.class);

    public static MCostQueue get(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, String trxName) {
        String whereClause = "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?";
        Object[] params = new Object[]{product.getAD_Client_ID(), AD_Org_ID, product.get_ID(), M_AttributeSetInstance_ID, as.getM_CostType_ID(), as.get_ID(), M_CostElement_ID};
        MCostQueue costQ = (MCostQueue)new Query(product.getCtx(), "M_CostQueue", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?", trxName).setParameters(params).first();
        if (costQ == null) {
            costQ = new MCostQueue(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID, trxName);
        }
        return costQ;
    }

    public static MCostQueue getQueueForAdjustment(MCostDetail cd, MCost cost, String trxName) {
        MCostQueue cq;
        MCostElement ce = MCostElement.get(cost.getCtx(), cost.getM_CostElement_ID());
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID=? AND AD_Org_ID=?");
        params.add(cost.getAD_Client_ID());
        params.add(cost.getAD_Org_ID());
        whereClause.append(" AND M_Product_ID=?");
        params.add(cost.getM_Product_ID());
        MAcctSchema as = MAcctSchema.get(cost.getCtx(), cost.getC_AcctSchema_ID());
        whereClause.append(" AND M_CostType_ID=? AND C_AcctSchema_ID=?");
        params.add(as.getM_CostType_ID());
        params.add(as.get_ID());
        whereClause.append(" AND M_CostElement_ID=?");
        params.add(ce.get_ID());
        whereClause.append("AND CurrentCostPrice=?");
        params.add(cd.getPrice());
        whereClause.append("AND DateAcct=?");
        params.add(cd.getDateAcct());
        if (cost.getM_AttributeSetInstance_ID() > 0) {
            whereClause.append(" AND M_AttributeSetInstance_ID=?");
            params.add(cost.getM_AttributeSetInstance_ID());
        }
        if ((cq = (MCostQueue)new Query(cost.getCtx(), "M_CostQueue", whereClause.toString(), trxName).setParameters(params).setOrderBy("M_CostQueue_ID DESC").first()) == null) {
            s_log.warning("Not found cost queue for " + cost);
            MProduct product = MProduct.get(cost.getCtx(), cost.getM_Product_ID());
            cq = new MCostQueue(product, cost.getM_AttributeSetInstance_ID(), as, cost.getAD_Org_ID(), cost.getM_CostElement_ID(), trxName);
            cq.setDateAcct(cd.getDateAcct());
        }
        return cq;
    }

    public static MCostQueue[] getQueue(MCost cost, Timestamp dateAcct, String trxName) {
        MCostType ct = (MCostType)cost.getM_CostType();
        MCostElement ce = MCostElement.get(cost.getCtx(), cost.getM_CostElement_ID());
        String orderByFlag = null;
        if (ct.getCostingMethod() != null) {
            if ("F".equals(ct.getCostingMethod())) {
                orderByFlag = " ASC";
            } else if ("L".equals(ct.getCostingMethod())) {
                orderByFlag = " DESC";
            }
        } else if (ce != null && ct.isFifo()) {
            orderByFlag = " ASC";
        } else if (ce != null && ct.isLifo()) {
            orderByFlag = " DESC";
        }
        if (orderByFlag == null) {
            throw new IllegalArgumentException("Cost element should be FIFO or LIFO - " + ce + ", CostingMethod=" + ct.getCostingMethod());
        }
        String orderBy = "DateAcct" + orderByFlag + ",M_CostQueue_ID" + orderByFlag;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID=? AND AD_Org_ID=?");
        params.add(cost.getAD_Client_ID());
        params.add(cost.getAD_Org_ID());
        whereClause.append(" AND M_Product_ID=?");
        params.add(cost.getM_Product_ID());
        MAcctSchema as = MAcctSchema.get(cost.getCtx(), cost.getC_AcctSchema_ID());
        whereClause.append(" AND M_CostType_ID=? AND C_AcctSchema_ID=?");
        params.add(as.getM_CostType_ID());
        params.add(as.get_ID());
        whereClause.append(" AND M_CostElement_ID=?");
        params.add(ce.get_ID());
        if (cost.getM_AttributeSetInstance_ID() > 0) {
            whereClause.append(" AND M_AttributeSetInstance_ID=?");
            params.add(cost.getM_AttributeSetInstance_ID());
        }
        List<MCostQueue> list = new Query(cost.getCtx(), "M_CostQueue", whereClause.toString(), trxName).setParameters(params).setOrderBy(orderBy).list();
        return list.toArray(new MCostQueue[list.size()]);
    }

    public static MCostQueue[] getQueue(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, MCostElement ce, String trxName) {
        ArrayList<MCostQueue> list = new ArrayList<MCostQueue>();
        Object sql = "SELECT * FROM M_CostQueue WHERE AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?";
        if (M_ASI_ID != 0) {
            sql = (String)sql + " AND M_AttributeSetInstance_ID=?";
        }
        sql = (String)sql + " AND CurrentQty<>0 ORDER BY M_AttributeSetInstance_ID ";
        if (!ce.isFifo()) {
            sql = (String)sql + "DESC";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, trxName);
            pstmt.setInt(1, product.getAD_Client_ID());
            pstmt.setInt(2, Org_ID);
            pstmt.setInt(3, product.getM_Product_ID());
            pstmt.setInt(4, as.getM_CostType_ID());
            pstmt.setInt(5, as.getC_AcctSchema_ID());
            pstmt.setInt(6, ce.getM_CostElement_ID());
            if (M_ASI_ID != 0) {
                pstmt.setInt(7, M_ASI_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCostQueue(product.getCtx(), rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, (String)sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCostQueue[] costQ = new MCostQueue[list.size()];
        list.toArray(costQ);
        return costQ;
    }

    public static BigDecimal adjustQty(MCost cost, BigDecimal Qty, Timestamp dateAcct, String trxName) {
        if (Qty.signum() == 0) {
            return Env.ZERO;
        }
        MCostQueue[] costQ = MCostQueue.getQueue(cost, dateAcct, trxName);
        BigDecimal costAmt = Env.ZERO;
        BigDecimal remainingQty = Qty;
        for (int i2 = 0; i2 < costQ.length; ++i2) {
            MCostQueue queue = costQ[i2];
            if (remainingQty.signum() < 0) {
                BigDecimal oldQty = queue.getCurrentQty();
                BigDecimal newQty = oldQty.subtract(remainingQty);
                queue.setCurrentQty(newQty);
                queue.saveEx();
                s_log.fine("Qty=" + remainingQty + "(!), ASI=" + queue.getM_AttributeSetInstance_ID() + " - " + oldQty + " -> " + newQty);
                BigDecimal lastPrice = queue.getCurrentCostPrice();
                costAmt = costAmt.add(lastPrice.multiply(remainingQty));
                return costAmt;
            }
            if (queue.getCurrentQty().signum() <= 0) continue;
            BigDecimal reduction = remainingQty;
            if (reduction.compareTo(queue.getCurrentQty()) > 0) {
                reduction = queue.getCurrentQty();
            }
            BigDecimal oldQty = queue.getCurrentQty();
            BigDecimal newQty = oldQty.subtract(reduction);
            queue.setCurrentQty(newQty);
            queue.saveEx();
            s_log.fine("Qty=" + reduction + ", ASI=" + queue.getM_AttributeSetInstance_ID() + " - " + oldQty + " -> " + newQty);
            remainingQty = remainingQty.subtract(reduction);
            BigDecimal lastPrice = queue.getCurrentCostPrice();
            costAmt = costAmt.add(reduction.multiply(lastPrice));
            if (remainingQty.signum() != 0) continue;
            return costAmt;
        }
        s_log.fine("RemainingQty=" + remainingQty);
        if (remainingQty.signum() != 0) {
            throw new CostInsufficientQtyException(cost.getM_Product_ID(), cost.getM_AttributeSetInstance_ID(), Qty, remainingQty);
        }
        return null;
    }

    public static BigDecimal getCosts(MCost cost, BigDecimal Qty, Timestamp dateAcct, String trxName) {
        List<CostComponent> list = MCostQueue.getCostLayers(cost, Qty, dateAcct, trxName);
        if (list == null) {
            return null;
        }
        BigDecimal costs = Env.ZERO;
        BigDecimal qtyCalc = Env.ZERO;
        for (CostComponent cc : list) {
            costs = costs.add(cc.getAmount());
            qtyCalc = qtyCalc.add(cc.qty);
        }
        if (qtyCalc.compareTo(Qty) != 0) {
            throw new IllegalStateException("Invalid Qty - Required=" + Qty + ", Calculated=" + qtyCalc);
        }
        return costs;
    }

    public static BigDecimal getCosts(MProduct product, int M_ASI_ID, MAcctSchema as, int Org_ID, int M_Warehouse_ID, MCostElement ce, BigDecimal Qty, String trxName) {
        if (Qty.signum() == 0) {
            return Env.ZERO;
        }
        MCostQueue[] costQ = MCostQueue.getQueue(product, M_ASI_ID, as, Org_ID, ce, trxName);
        BigDecimal cost = Env.ZERO;
        BigDecimal remainingQty = Qty;
        BigDecimal firstPrice = null;
        BigDecimal lastPrice = null;
        for (int i2 = 0; i2 < costQ.length; ++i2) {
            MCostQueue queue = costQ[i2];
            if (remainingQty.signum() <= 0) {
                BigDecimal oldQty = queue.getCurrentQty();
                lastPrice = queue.getCurrentCostPrice();
                BigDecimal costBatch = lastPrice.multiply(remainingQty);
                cost = cost.add(costBatch);
                s_log.config("ASI=" + queue.getM_AttributeSetInstance_ID() + " - Cost=" + lastPrice + " * Qty=" + remainingQty + "(!) = " + costBatch);
                return cost;
            }
            if (queue.getCurrentQty().signum() <= 0) continue;
            BigDecimal reduction = remainingQty;
            if (reduction.compareTo(queue.getCurrentQty()) > 0) {
                reduction = queue.getCurrentQty();
            }
            BigDecimal oldQty = queue.getCurrentQty();
            lastPrice = queue.getCurrentCostPrice();
            BigDecimal costBatch = lastPrice.multiply(reduction);
            cost = cost.add(costBatch);
            s_log.fine("ASI=" + queue.getM_AttributeSetInstance_ID() + " - Cost=" + lastPrice + " * Qty=" + reduction + " = " + costBatch);
            remainingQty = remainingQty.subtract(reduction);
            if (remainingQty.signum() == 0) {
                s_log.config("Cost=" + cost);
                return cost;
            }
            if (firstPrice != null) continue;
            firstPrice = lastPrice;
        }
        if (lastPrice == null) {
            lastPrice = MCost.getSeedCosts(product, M_ASI_ID, as, Org_ID, M_Warehouse_ID, ce.getCostingMethod(), 0);
            if (lastPrice == null) {
                s_log.info("No Price found");
                return null;
            }
            s_log.info("No Cost Queue");
        }
        BigDecimal costBatch = lastPrice.multiply(remainingQty);
        s_log.fine("RemainingQty=" + remainingQty + " * LastPrice=" + lastPrice + " = " + costBatch);
        cost = cost.add(costBatch);
        s_log.config("Cost=" + cost);
        return cost;
    }

    public static List<CostComponent> getCostLayers(MCost cost, BigDecimal Qty, Timestamp dateAcct, String trxName) {
        ArrayList<CostComponent> list = new ArrayList<CostComponent>();
        if (Qty.signum() == 0) {
            return list;
        }
        MCostQueue[] costQ = MCostQueue.getQueue(cost, dateAcct, trxName);
        BigDecimal costAmt = Env.ZERO;
        BigDecimal remainingQty = Qty;
        BigDecimal lastPrice = null;
        for (int i2 = 0; i2 < costQ.length; ++i2) {
            MCostQueue queue = costQ[i2];
            if (queue.getCurrentQty().signum() <= 0) continue;
            BigDecimal reduction = remainingQty;
            if (reduction.negate().compareTo(queue.getCurrentQty()) > 0) {
                reduction = queue.getCurrentQty().negate();
            }
            lastPrice = queue.getCurrentCostPrice();
            BigDecimal costBatch = lastPrice.multiply(reduction);
            list.add(new CostComponent(reduction, lastPrice));
            costAmt = costAmt.add(costBatch);
            s_log.fine("ASI=" + queue.getM_AttributeSetInstance_ID() + " - Cost=" + lastPrice + " * Qty=" + reduction + " = " + costBatch);
            remainingQty = remainingQty.subtract(reduction);
            if (remainingQty.signum() != 0) continue;
            s_log.config("Cost=" + cost);
            return list;
        }
        if (lastPrice == null) {
            lastPrice = MCost.getSeedCosts(MProduct.get(cost.getCtx(), cost.getM_Product_ID()), cost.getM_AttributeSetInstance_ID(), MAcctSchema.get(cost.getCtx(), cost.getC_AcctSchema_ID()), cost.getAD_Org_ID(), cost.getM_Warehouse_ID(), cost.getCostingMethod(), 0);
            if (lastPrice == null) {
                s_log.info("No Price found");
                return null;
            }
            s_log.info("No Cost Queue");
        }
        BigDecimal costBatch = lastPrice.multiply(remainingQty);
        s_log.fine("RemainingQty=" + remainingQty + " * LastPrice=" + lastPrice + " = " + costBatch);
        costAmt = costAmt.add(costBatch);
        list.add(new CostComponent(remainingQty, lastPrice));
        s_log.config("Cost=" + cost);
        return list;
    }

    public MCostQueue(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setCurrentCostPrice(Env.ZERO);
        this.setCurrentQty(Env.ZERO);
    }

    public MCostQueue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCostQueue(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, String trxName) {
        this(product.getCtx(), 0, trxName);
        this.setClientOrg(product.getAD_Client_ID(), AD_Org_ID);
        this.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
        this.setM_CostType_ID(as.getM_CostType_ID());
        this.setM_Product_ID(product.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setM_CostElement_ID(M_CostElement_ID);
    }

    public void setCosts(BigDecimal amt, BigDecimal qty, int precision) {
        BigDecimal oldSum = this.getCurrentCostPrice().multiply(this.getCurrentQty());
        BigDecimal newSum = amt;
        BigDecimal sumAmt = oldSum.add(newSum);
        BigDecimal sumQty = this.getCurrentQty().add(qty);
        if (sumQty.signum() != 0) {
            BigDecimal cost = sumAmt.divide(sumQty, precision, RoundingMode.HALF_UP);
            this.setCurrentCostPrice(cost);
        }
        this.setCurrentQty(this.getCurrentQty().add(qty));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.get_ID() + ", AD_Org_ID=" + this.getAD_Org_ID() + ", M_Product_ID=" + this.getM_Product_ID() + ", M_ASI_ID=" + this.getM_AttributeSetInstance_ID() + ", Price=" + this.getCurrentCostPrice() + ", Qty=" + this.getCurrentQty() + ", DateAcct=" + this.getDateAcct() + "]";
    }

    public static MCostQueue add(MProduct product, int M_AttributeSetInstance_ID, MAcctSchema as, int AD_Org_ID, int M_CostElement_ID, BigDecimal amt, BigDecimal qty, int precision, MCostDetail cd, String trxName) {
        if (CLogMgt.isLevelFine()) {
            s_log.fine("Entering: org=" + AD_Org_ID + ", product=" + product.get_ID() + ", asi=" + M_AttributeSetInstance_ID + ", amt=" + amt + ", qty=" + qty + ", precision=" + precision);
        }
        MCostQueue cq = new MCostQueue(product, M_AttributeSetInstance_ID, as, AD_Org_ID, M_CostElement_ID, trxName);
        cq.setCosts(amt, qty, precision);
        cq.setDateAcct(cd.getDateAcct());
        cq.saveEx();
        if (CLogMgt.isLevelFine()) {
            s_log.fine("Leaving: " + cq);
        }
        return cq;
    }

    public void addCurrentQty(BigDecimal delta) {
        this.setCurrentQty(this.getCurrentQty().add(delta));
    }
}

