/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_Field;
import org.compiere.model.MColumn;
import org.compiere.model.MTab;
import org.compiere.model.M_Element;

public class MField
extends X_AD_Field {
    private static final long serialVersionUID = 7124162742037904113L;

    public MField(Properties ctx, int AD_Field_ID, String trxName) {
        super(ctx, AD_Field_ID, trxName);
        if (AD_Field_ID == 0) {
            this.setEntityType("U");
            this.setIsCentrallyMaintained(true);
            this.setIsDisplayed(true);
            this.setIsEncrypted(false);
            this.setIsFieldOnly(false);
            this.setIsHeading(false);
            this.setIsReadOnly(false);
            this.setIsSameLine(false);
        }
    }

    public MField(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MField(MTab parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Tab_ID(parent.getAD_Tab_ID());
    }

    public MField(MTab parent, MField from) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        MField.copyValues(from, this);
        this.setClientOrg(parent);
        this.setAD_Tab_ID(parent.getAD_Tab_ID());
        this.setEntityType(parent.getEntityType());
    }

    public void setColumn(MColumn column) {
        this.setAD_Column_ID(column.getAD_Column_ID());
        this.setName(column.getName());
        this.setDescription(column.getDescription());
        this.setHelp(column.getHelp());
        this.setDisplayLength(column.getFieldLength());
        this.setEntityType(column.getEntityType());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        M_Element element;
        if ((newRecord || this.is_ValueChanged("AD_Column_ID")) && this.isCentrallyMaintained() && (element = M_Element.getOfColumn(this.getCtx(), this.getAD_Column_ID(), this.get_TrxName())) != null) {
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        if (this.is_ValueChanged("AD_Column_ID")) {
            MColumn column = MColumn.get(this.getCtx(), this.getAD_Column_ID());
            this.setIsAllowCopy(column.isAllowCopy());
        }
        if (this.getAD_Reference_ID() != 0 && this.getAD_Column_ID() != 0 && !this.isDirectLoad()) {
            String columnName = MColumn.getColumnName(this.getCtx(), this.getAD_Column_ID());
            MColumn.validLookup(columnName, this.getAD_Reference_ID(), this.getAD_Reference_Value_ID());
        }
        return true;
    }

    public MField getDuplicated() {
        try {
            return (MField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            this.log.warning("Error " + e.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getAD_Field_ID() + " " + this.getName() + " - isDisplayed: " + this.isDisplayed() + " - isActive: " + this.isActive();
    }
}

