/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.I_PP_Period;
import org.adempiere.core.domains.models.X_M_ForecastLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.WarehouseInvalidForOrgException;
import org.compiere.model.MForecast;
import org.compiere.model.MOrg;
import org.compiere.model.MWarehouse;

public class MForecastLine
extends X_M_ForecastLine {
    private static final long serialVersionUID = -3420900505079279058L;
    private MForecast m_parent = null;

    public MForecastLine(Properties ctx, int M_ForecastLine_ID, String trxName) {
        super(ctx, M_ForecastLine_ID, trxName);
    }

    public MForecastLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MWarehouse wh;
        if ((newRecord || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            throw new WarehouseInvalidForOrgException(wh.getName(), MOrg.get(this.getCtx(), this.getAD_Org_ID()).getName());
        }
        if ((newRecord || this.is_ValueChanged("DatePromised")) && !this.isValid(this.getDatePromised())) {
            throw new AdempiereException("@DatePromised@ @Invalid@");
        }
        return true;
    }

    public boolean isValid(Timestamp DatePromised) {
        I_PP_Period period = this.getPP_Period();
        Timestamp validFrom = period.getStartDate();
        if (period != null && period.getPP_Period_ID() > 0) {
            if (DatePromised.before(period.getStartDate())) {
                return false;
            }
            if (DatePromised.after(period.getEndDate())) {
                return false;
            }
        }
        return true;
    }

    public MForecast getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MForecast(this.getCtx(), this.getM_Forecast_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }
}

