/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_InvoiceLine;
import org.adempiere.core.domains.models.X_C_Tax;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MLandedCost;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRMALine;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.process.DocumentReversalLineEnable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInvoiceLine
extends X_C_InvoiceLine
implements DocumentReversalLineEnable {
    private static final long serialVersionUID = -5113860437274708398L;
    private static CLogger s_log = CLogger.getCLogger(MInvoiceLine.class);
    private MTax m_tax = null;
    private int m_M_PriceList_ID = 0;
    private Timestamp m_DateInvoiced = null;
    private int m_C_BPartner_ID = 0;
    private int m_C_BPartner_Location_ID = 0;
    private boolean m_IsSOTrx = true;
    private boolean m_priceSet = false;
    private MProduct m_product = null;
    private MCharge m_charge = null;
    private String m_name = null;
    private Integer m_precision = null;
    private MProductPricing m_productPricing = null;
    private MInvoice m_parent = null;

    public static MInvoiceLine getOfInOutLine(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        String whereClause = "M_InOutLine_ID=?";
        List list = new Query(sLine.getCtx(), "C_InvoiceLine", "M_InOutLine_ID=?", sLine.get_TrxName()).setParameters(sLine.getM_InOutLine_ID()).list();
        MInvoiceLine retValue = null;
        if (list.size() > 0) {
            retValue = (MInvoiceLine)list.get(0);
            if (list.size() > 1) {
                s_log.warning("More than one C_InvoiceLine of " + sLine);
            }
        }
        return retValue;
    }

    public MInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        super(ctx, C_InvoiceLine_ID, trxName);
        if (C_InvoiceLine_ID == 0) {
            this.setIsDescription(false);
            this.setIsPrinted(true);
            this.setLineNetAmt(Env.ZERO);
            this.setPriceEntered(Env.ZERO);
            this.setPriceActual(Env.ZERO);
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setM_AttributeSetInstance_ID(0);
            this.setTaxAmt(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.setQtyInvoiced(Env.ZERO);
        }
    }

    public MInvoiceLine(MInvoice invoice) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        if (invoice.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setInvoice(invoice);
    }

    public MInvoiceLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setInvoice(MInvoice invoice) {
        this.m_parent = invoice;
        this.m_M_PriceList_ID = invoice.getM_PriceList_ID();
        this.m_DateInvoiced = invoice.getDateInvoiced();
        this.m_C_BPartner_ID = invoice.getC_BPartner_ID();
        this.m_C_BPartner_Location_ID = invoice.getC_BPartner_Location_ID();
        this.m_IsSOTrx = invoice.isSOTrx();
        this.m_precision = invoice.getPrecision();
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setIsDescription(oLine.isDescription());
        this.setDescription(oLine.getDescription());
        if (oLine.getM_Product_ID() == 0) {
            this.setC_Charge_ID(oLine.getC_Charge_ID());
        }
        this.setM_Product_ID(oLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
        this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        this.setPriceEntered(oLine.getPriceEntered());
        this.setPriceActual(oLine.getPriceActual());
        this.setPriceLimit(oLine.getPriceLimit());
        this.setPriceList(oLine.getPriceList());
        this.setC_Tax_ID(oLine.getC_Tax_ID());
        this.setLineNetAmt(oLine.getLineNetAmt());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
        this.setUser3_ID(oLine.getUser3_ID());
        this.setUser4_ID(oLine.getUser4_ID());
        this.setRRAmt(oLine.getRRAmt());
        this.setRRStartDate(oLine.getRRStartDate());
    }

    public void setShipLine(MInOutLine sLine) {
        int C_OrderLine_ID;
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        this.setM_RMALine_ID(sLine.getM_RMALine_ID());
        this.setLine(sLine.getLine());
        this.setIsDescription(sLine.isDescription());
        this.setDescription(sLine.getDescription());
        this.setM_Product_ID(sLine.getM_Product_ID());
        if (sLine.sameOrderLineUOM() || this.getProduct() == null) {
            this.setC_UOM_ID(sLine.getC_UOM_ID());
        } else {
            this.setC_UOM_ID(this.getProduct().getC_UOM_ID());
        }
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        if (this.getM_Product_ID() == 0) {
            this.setC_Charge_ID(sLine.getC_Charge_ID());
        }
        if ((C_OrderLine_ID = sLine.getC_OrderLine_ID()) != 0) {
            MOrderLine oLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.get_TrxName());
            this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
            if (sLine.sameOrderLineUOM()) {
                this.setPriceEntered(oLine.getPriceEntered());
            } else {
                this.setPriceEntered(oLine.getPriceActual());
            }
            this.setPriceActual(oLine.getPriceActual());
            this.setPriceLimit(oLine.getPriceLimit());
            this.setPriceList(oLine.getPriceList());
            this.setC_Tax_ID(oLine.getC_Tax_ID());
            this.setLineNetAmt(oLine.getLineNetAmt());
            this.setC_Project_ID(oLine.getC_Project_ID());
        } else if (sLine.getM_RMALine_ID() != 0) {
            MRMALine rmaLine = new MRMALine(this.getCtx(), sLine.getM_RMALine_ID(), this.get_TrxName());
            this.setPrice();
            this.setPrice(rmaLine.getAmt());
            this.setC_Tax_ID(rmaLine.getC_Tax_ID());
            this.setLineNetAmt(rmaLine.getLineNetAmt());
        } else {
            this.setPrice();
            this.setTax();
        }
        this.setC_Project_ID(sLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(sLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(sLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(sLine.getC_Activity_ID());
        this.setC_Campaign_ID(sLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(sLine.getAD_OrgTrx_ID());
        this.setUser1_ID(sLine.getUser1_ID());
        this.setUser2_ID(sLine.getUser2_ID());
        this.setUser3_ID(sLine.getUser3_ID());
        this.setUser4_ID(sLine.getUser4_ID());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        if (M_AttributeSetInstance_ID == 0) {
            this.set_Value("M_AttributeSetInstance_ID", (Object)0);
        } else {
            super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        }
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            this.setInvoice(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            throw new IllegalStateException("setPrice - PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID, this.m_C_BPartner_ID);
    }

    public void setPrice(int M_PriceList_ID, int C_BPartner_ID) {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        this.m_productPricing = new MProductPricing(this.getM_Product_ID(), C_BPartner_ID, this.getQtyInvoiced(), this.m_IsSOTrx, null);
        this.m_productPricing.setM_PriceList_ID(M_PriceList_ID);
        this.m_productPricing.setPriceDate(this.m_DateInvoiced);
        this.setPriceActual(this.m_productPricing.getPriceStd());
        this.setPriceList(this.m_productPricing.getPriceList());
        this.setPriceLimit(this.m_productPricing.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyInvoiced()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyInvoiced().divide(this.getQtyEntered(), 6, RoundingMode.HALF_UP)));
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPricing.getC_UOM_ID());
        }
        this.m_priceSet = true;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    @Override
    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public boolean setTax() {
        if (this.isDescription()) {
            return true;
        }
        int M_Warehouse_ID = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
        int C_Tax_ID = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.m_DateInvoiced, this.m_DateInvoiced, this.getAD_Org_ID(), M_Warehouse_ID, this.m_C_BPartner_Location_ID, this.m_C_BPartner_Location_ID, this.m_IsSOTrx, this.get_TrxName());
        if (C_Tax_ID == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(C_Tax_ID);
        return true;
    }

    public void setTaxAmt() {
        BigDecimal taxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        MTax tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        if (tax.isDocumentLevel() && this.m_IsSOTrx) {
            this.setLineTotalAmt(this.getLineNetAmt());
            return;
        }
        taxAmt = tax.calculateTax(this.getLineNetAmt(), this.isTaxIncluded(), this.getPrecision());
        if (this.isTaxIncluded()) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(taxAmt));
        }
        super.setTaxAmt(taxAmt);
    }

    public void setLineNetAmt() {
        MProduct product;
        BigDecimal lineNetAmount = null;
        if (this.getM_Product_ID() != 0 && (product = MProduct.get(this.getCtx(), this.getM_Product_ID(), this.get_TrxName())).getC_UOM_ID() != this.getC_UOM_ID() && this.getPriceEntered() != null && !this.getPriceEntered().equals(Env.ZERO) && this.getQtyEntered() != null && !this.getQtyEntered().equals(Env.ZERO)) {
            lineNetAmount = this.getQtyEntered().multiply(this.getPriceEntered());
        }
        if (lineNetAmount == null) {
            lineNetAmount = this.getPriceActual().multiply(this.getQtyInvoiced());
        }
        boolean documentLevel = this.getTax().isDocumentLevel();
        if (this.isTaxIncluded() && !documentLevel) {
            BigDecimal taxStdAmt = Env.ZERO;
            BigDecimal taxThisAmt = Env.ZERO;
            MTax invoiceTax = this.getTax();
            X_C_Tax stdTax = null;
            if (this.getProduct() == null) {
                if (this.getCharge() != null) {
                    stdTax = new MTax(this.getCtx(), ((MTaxCategory)this.getCharge().getC_TaxCategory()).getDefaultTax().getC_Tax_ID(), this.get_TrxName());
                }
            } else {
                stdTax = new MTax(this.getCtx(), ((MTaxCategory)this.getProduct().getC_TaxCategory()).getDefaultTax().getC_Tax_ID(), this.get_TrxName());
            }
            if (stdTax != null) {
                this.log.fine("stdTax rate is " + stdTax.getRate());
                this.log.fine("invoiceTax rate is " + invoiceTax.getRate());
                taxThisAmt = taxThisAmt.add(invoiceTax.calculateTax(lineNetAmount, this.isTaxIncluded(), this.getPrecision()));
                taxStdAmt = taxStdAmt.add(((MTax)stdTax).calculateTax(lineNetAmount, this.isTaxIncluded(), this.getPrecision()));
                lineNetAmount = lineNetAmount.subtract(taxStdAmt).add(taxThisAmt);
                this.log.fine("Price List includes Tax and Tax Changed on Invoice Line: New Tax Amt: " + taxThisAmt + " Standard Tax Amt: " + taxStdAmt + " Line Net Amt: " + lineNetAmount);
            }
        }
        if (lineNetAmount.scale() > this.getPrecision()) {
            lineNetAmount = lineNetAmount.setScale(this.getPrecision(), RoundingMode.HALF_UP);
        }
        super.setLineNetAmt(lineNetAmount);
    }

    public MCharge getCharge() {
        if (this.m_charge == null && this.getC_Charge_ID() != 0) {
            this.m_charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
        }
        return this.m_charge;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public void setQty(int Qty) {
        this.setQty(new BigDecimal(Qty));
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setQtyInvoiced(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyInvoiced(BigDecimal QtyInvoiced) {
        MProduct product = this.getProduct();
        if (QtyInvoiced != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyInvoiced = QtyInvoiced.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyInvoiced(QtyInvoiced);
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoiceLine[").append(this.get_ID()).append(",").append(this.getLine()).append(",QtyInvoiced=").append(this.getQtyInvoiced()).append(",LineNetAmt=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.m_name == null) {
            String sql = "SELECT COALESCE (p.Name, c.Name) FROM C_InvoiceLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge C ON (il.C_Charge_ID=c.C_Charge_ID) WHERE C_InvoiceLine_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_InvoiceLine_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_name = rs.getString(1);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (this.m_name == null) {
                    this.m_name = "??";
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getName", e);
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception exception) {}
                pstmt = null;
            }
        }
        return this.m_name;
    }

    public void setName(String tempName) {
        this.m_name = tempName;
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Invoice x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Invoice_ID=?";
        int i2 = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
        if (i2 < 0) {
            this.log.warning("getPrecision = " + i2 + " - set to 2");
            i2 = 2;
        }
        this.m_precision = i2;
        return this.m_precision;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM C_Invoice WHERE C_Invoice_ID=?", this.getC_Invoice_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int C_UOM_ID;
        this.log.fine("New=" + newRecord);
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_InvoiceLine"));
            return false;
        }
        this.setInvoice(this.getParent());
        if (this.getC_Charge_ID() != 0) {
            if (this.getM_Product_ID() != 0) {
                this.setM_Product_ID(0);
            }
        } else if (!this.m_priceSet && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
            this.setPrice();
        }
        if (this.getC_Tax_ID() == 0) {
            this.setTax();
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_InvoiceLine WHERE C_Invoice_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("QtyInvoiced")) {
            this.setQtyInvoiced(this.getQtyInvoiced());
        }
        this.setLineNetAmt();
        if (this.getTaxAmt().compareTo(Env.ZERO) == 0) {
            this.setTaxAmt();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord || !newRecord && this.is_ValueChanged("C_Tax_ID") && !this.getParent().isProcessed() || !newRecord && this.is_ValueChanged("QtyEntered") && !this.getParent().isProcessed() || !newRecord && this.is_ValueChanged("PriceActual") && !this.getParent().isProcessed() || !newRecord && this.is_ValueChanged("TaxAmt") && !this.getParent().isProcessed()) {
            return this.updateHeaderTax();
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getM_InOutLine_ID() > 0) {
            MInOutLine sLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            sLine.setIsInvoiced(false);
            sLine.saveEx();
        }
        return this.updateHeaderTax();
    }

    private boolean updateHeaderTax() {
        String sql;
        int no;
        if (!this.getParent().isProcessed()) {
            this.getParent().calculateTaxTotal();
        }
        if ((no = DB.executeUpdateEx(sql = "UPDATE C_Invoice i SET TotalLines=(SELECT COALESCE(SUM(LineNetAmt),0) FROM C_InvoiceLine il WHERE i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Invoice_ID=?", new Object[]{this.getC_Invoice_ID()}, this.get_TrxName())) != 1) {
            this.log.warning("(1) #" + no);
        }
        if ((no = DB.executeUpdateEx(sql = this.isTaxIncluded() ? "UPDATE C_Invoice i  SET GrandTotal=TotalLines WHERE C_Invoice_ID=?" : "UPDATE C_Invoice i  SET GrandTotal=TotalLines+(SELECT COALESCE(SUM(TaxAmt),0) FROM C_InvoiceTax it WHERE i.C_Invoice_ID=it.C_Invoice_ID) WHERE C_Invoice_ID=?", new Object[]{this.getC_Invoice_ID()}, this.get_TrxName())) != 1) {
            this.log.warning("(2) #" + no);
        }
        this.m_parent = null;
        return no == 1;
    }

    public int getInOutLineId() {
        int inOutLineId = this.getM_InOutLine_ID();
        if (inOutLineId <= 0) {
            if (this.getParent().isSOTrx()) {
                inOutLineId = DB.getSQLValue(this.get_TrxName(), "SELECT il.M_InOutLine_ID FROM M_InOutLine il WHERE il.C_OrderLine_ID = ? AND EXISTS(SELECT 1 FROM \t\t\t\t\t\tM_InOut i \t\t\t\t\t\tWHERE i.M_InOut_ID = il.M_InOut_ID \t\t\t\t\t\tAND i.DocStatus IN('CO', 'CL'))", this.getC_OrderLine_ID());
            }
            if (inOutLineId == -1) {
                inOutLineId = 0;
            }
        }
        return inOutLineId;
    }

    public String allocateLandedCosts() {
        int i2;
        MInOutLine iol;
        MLandedCost[] lcs;
        String sql;
        int no;
        if (this.getParent().isProcessed()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getParent().getDateAcct(), this.getParent().getC_DocTypeTarget_ID(), this.getAD_Org_ID());
        }
        if (this.getParent().isProcessed()) {
            MFactAcct.deleteEx(MInvoice.Table_ID, this.getParent().get_ID(), this.get_TrxName());
            this.getParent().setPosted(false);
            this.getParent().saveEx();
        }
        if ((no = DB.executeUpdate(sql = "DELETE M_CostDetail WHERE C_landedcostallocation_ID in (select c_landedCostAllocation_ID from c_landedcostAllocation where c_invoiceline_ID=" + this.getC_InvoiceLine_ID() + ")", this.get_TrxName())) != 0) {
            this.log.info("Deleted #" + no);
        }
        if ((no = DB.executeUpdate(sql = "DELETE C_LandedCostAllocation WHERE C_InvoiceLine_ID=" + this.getC_InvoiceLine_ID(), this.get_TrxName())) != 0) {
            this.log.info("Deleted #" + no);
        }
        if ((lcs = MLandedCost.getLandedCosts(this)).length == 0) {
            return "";
        }
        int inserted = 0;
        if (lcs.length == 1) {
            MLandedCost lc = lcs[0];
            if (lc.getM_InOut_ID() != 0 && lc.getM_InOutLine_ID() == 0) {
                MInOutLine iol2;
                int i3;
                ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                for (int i4 = 0; i4 < lines.length; ++i4) {
                    if (lines[i4].isDescription() || lines[i4].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i4].getM_Product_ID()) continue;
                    list.add(lines[i4]);
                }
                if (list.size() == 0) {
                    return "No Matching Lines (with Product) in Shipment";
                }
                BigDecimal total = Env.ZERO;
                for (i3 = 0; i3 < list.size(); ++i3) {
                    iol2 = (MInOutLine)list.get(i3);
                    total = total.add(iol2.getBase(lc.getLandedCostDistribution()));
                }
                if (total.signum() == 0) {
                    return "Total of Base values is 0 - " + lc.getLandedCostDistribution();
                }
                for (i3 = 0; i3 < list.size(); ++i3) {
                    iol2 = (MInOutLine)list.get(i3);
                    MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                    lca.setM_Product_ID(iol2.getM_Product_ID());
                    lca.setM_AttributeSetInstance_ID(iol2.getM_AttributeSetInstance_ID());
                    lca.setM_InOutLine_ID(iol2.getM_InOutLine_ID());
                    lca.setC_LandedCostType_ID(lc.getC_LandedCostType_ID());
                    BigDecimal base = iol2.getBase(lc.getLandedCostDistribution());
                    lca.setBase(base);
                    lca.setQty(iol2.getMovementQty());
                    if (base.signum() != 0) {
                        double result = this.getLineNetAmt().multiply(base).doubleValue();
                        lca.setAmt(result /= total.doubleValue(), this.getPrecision());
                    }
                    if (!lca.save()) {
                        return "Cannot save line Allocation = " + lca;
                    }
                    ++inserted;
                }
                this.log.info("Inserted " + inserted);
                this.allocateLandedCostRounding();
                return "";
            }
            if (lc.getM_InOutLine_ID() != 0) {
                MInOutLine iol3 = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName());
                if (iol3.isDescription() || iol3.getM_Product_ID() == 0) {
                    return "Invalid Receipt Line - " + iol3;
                }
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(iol3.getM_Product_ID());
                lca.setM_InOutLine_ID(lc.getM_InOutLine_ID());
                lca.setM_AttributeSetInstance_ID(iol3.getM_AttributeSetInstance_ID());
                lca.setC_LandedCostType_ID(lc.getC_LandedCostType_ID());
                BigDecimal base = iol3.getBase(lc.getLandedCostDistribution());
                lca.setBase(base);
                lca.setAmt(this.getLineNetAmt());
                lca.setQty(iol3.getMovementQty());
                if (lca.save()) {
                    return "";
                }
                return "Cannot save single line Allocation = " + lc;
            }
            if (lc.getM_Product_ID() != 0) {
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(lc.getM_Product_ID());
                lca.setC_LandedCostType_ID(lc.getC_LandedCostType_ID());
                lca.setAmt(this.getLineNetAmt());
                if (lca.save()) {
                    return "";
                }
                return "Cannot save Product Allocation = " + lc;
            }
            return "No Reference for " + lc;
        }
        String LandedCostDistribution = lcs[0].getLandedCostDistribution();
        int M_CostElement_ID = lcs[0].getM_CostElement_ID();
        for (int i5 = 0; i5 < lcs.length; ++i5) {
            MLandedCost lc = lcs[i5];
            if (!LandedCostDistribution.equals(lc.getLandedCostDistribution())) {
                return "Multiple Landed Cost Rules must have consistent Landed Cost Distribution";
            }
            if (lc.getM_Product_ID() != 0 && lc.getM_InOut_ID() == 0 && lc.getM_InOutLine_ID() == 0) {
                return "Multiple Landed Cost Rules cannot directly allocate to a Product";
            }
            if (M_CostElement_ID == lc.getM_CostElement_ID()) continue;
            return "Multiple Landed Cost Rules cannot different Cost Elements";
        }
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        for (int ii = 0; ii < lcs.length; ++ii) {
            MLandedCost lc = lcs[ii];
            if (lc.getM_InOut_ID() != 0 && lc.getM_InOutLine_ID() == 0) {
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                for (int i6 = 0; i6 < lines.length; ++i6) {
                    if (lines[i6].isDescription() || lines[i6].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i6].getM_Product_ID()) continue;
                    list.add(lines[i6]);
                }
                continue;
            }
            if (lc.getM_InOutLine_ID() == 0 || (iol = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName())).isDescription() || iol.getM_Product_ID() == 0) continue;
            list.add(iol);
        }
        if (list.size() == 0) {
            return "No Matching Lines (with Product)";
        }
        BigDecimal total = Env.ZERO;
        for (i2 = 0; i2 < list.size(); ++i2) {
            iol = (MInOutLine)list.get(i2);
            total = total.add(iol.getBase(LandedCostDistribution));
        }
        if (total.signum() == 0) {
            return "Total of Base values is 0 - " + LandedCostDistribution;
        }
        for (i2 = 0; i2 < list.size(); ++i2) {
            iol = (MInOutLine)list.get(i2);
            MLandedCostAllocation lca = new MLandedCostAllocation(this, lcs[0].getM_CostElement_ID());
            lca.setM_Product_ID(iol.getM_Product_ID());
            lca.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            lca.setC_LandedCostType_ID(lcs[0].getC_LandedCostType_ID());
            lca.setM_InOutLine_ID(iol.getM_InOutLine_ID());
            BigDecimal base = iol.getBase(LandedCostDistribution);
            lca.setBase(base);
            lca.setQty(iol.getMovementQty());
            if (base.signum() != 0) {
                double result = this.getLineNetAmt().multiply(base).doubleValue();
                lca.setAmt(result /= total.doubleValue(), this.getPrecision());
            }
            if (!lca.save()) {
                return "Cannot save line Allocation = " + lca;
            }
            ++inserted;
        }
        this.log.info("Inserted " + inserted);
        this.allocateLandedCostRounding();
        return "";
    }

    private void allocateLandedCostRounding() {
        MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        MLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        for (int i2 = 0; i2 < allocations.length; ++i2) {
            MLandedCostAllocation allocation = allocations[i2];
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
        }
        BigDecimal difference = this.getLineNetAmt().subtract(allocationAmt);
        if (difference.signum() != 0) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.saveEx();
            this.log.config("Difference=" + difference + ", C_LandedCostAllocation_ID=" + largestAmtAllocation.getC_LandedCostAllocation_ID() + ", Amt" + largestAmtAllocation.getAmt());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MLandedCost[] getLandedCost(String whereClause) {
        ArrayList<MLandedCost> list = new ArrayList<MLandedCost>();
        Object sql = "SELECT * FROM C_LandedCost WHERE C_InvoiceLine_ID=? ";
        if (whereClause != null) {
            sql = (String)sql + whereClause;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_InvoiceLine_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MLandedCost lc = new MLandedCost(this.getCtx(), rs, this.get_TrxName());
                list.add(lc);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLandedCost", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MLandedCost[] landedCost = new MLandedCost[list.size()];
        list.toArray(landedCost);
        return landedCost;
    }

    public int copyLandedCostFrom(MInvoiceLine otherInvoiceLine) {
        if (otherInvoiceLine == null) {
            return 0;
        }
        MLandedCost[] fromLandedCosts = otherInvoiceLine.getLandedCost(null);
        int count = 0;
        for (int i2 = 0; i2 < fromLandedCosts.length; ++i2) {
            MLandedCost landedCost = new MLandedCost(this.getCtx(), 0, this.get_TrxName());
            MLandedCost fromLandedCost = fromLandedCosts[i2];
            PO.copyValues(fromLandedCost, landedCost, fromLandedCost.getAD_Client_ID(), fromLandedCost.getAD_Org_ID());
            landedCost.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
            landedCost.set_ValueNoCheck("C_LandedCost_ID", I_ZERO);
            if (!landedCost.save(this.get_TrxName())) continue;
            ++count;
        }
        if (fromLandedCosts.length != count) {
            this.log.log(Level.SEVERE, "LandedCost difference - From=" + fromLandedCosts.length + " <> Saved=" + count);
        }
        return count;
    }

    public void setRMALine(MRMALine rmaLine) {
        if (!this.getParent().isCreditMemo()) {
            throw new AdempiereException("InvoiceNotCreditMemo");
        }
        this.setAD_Org_ID(rmaLine.getAD_Org_ID());
        this.setM_RMALine_ID(rmaLine.getM_RMALine_ID());
        this.setDescription(rmaLine.getDescription());
        this.setLine(rmaLine.getLine());
        this.setC_Charge_ID(rmaLine.getC_Charge_ID());
        this.setM_Product_ID(rmaLine.getM_Product_ID());
        this.setC_UOM_ID(rmaLine.getC_UOM_ID());
        this.setC_Tax_ID(rmaLine.getC_Tax_ID());
        this.setPrice(rmaLine.getAmt());
        BigDecimal qty = rmaLine.getQty();
        if (rmaLine.getQtyInvoiced() != null) {
            qty = qty.subtract(rmaLine.getQtyInvoiced());
        }
        this.setQty(qty);
        this.setLineNetAmt();
        this.setTaxAmt();
        this.setLineTotalAmt(rmaLine.getLineNetAmt());
        this.setC_Project_ID(rmaLine.getC_Project_ID());
        this.setC_Activity_ID(rmaLine.getC_Activity_ID());
        this.setC_Campaign_ID(rmaLine.getC_Campaign_ID());
    }
}

