/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_GL_JournalLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MCurrency;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.process.DocumentReversalLineEnable;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MJournalLine
extends X_GL_JournalLine
implements DocumentReversalLineEnable {
    private static final long serialVersionUID = -7008806797777773843L;
    private MJournal parentJournal = null;
    private int currencyPrecision = 2;
    private MAccount account = null;
    private MElementValue accountElement = null;

    public MJournalLine(Properties ctx, int journalLineId, String trxName) {
        super(ctx, journalLineId, trxName);
        if (journalLineId == 0) {
            this.setLine(0);
            this.setAmtAcctCr(Env.ZERO);
            this.setAmtAcctDr(Env.ZERO);
            this.setAmtSourceCr(Env.ZERO);
            this.setAmtSourceDr(Env.ZERO);
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setIsGenerated(true);
        }
    }

    public MJournalLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournalLine(MJournal parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setGL_Journal_ID(parent.getGL_Journal_ID());
        this.setC_Currency_ID(parent.getC_Currency_ID());
        this.setC_ConversionType_ID(parent.getC_ConversionType_ID());
        this.setDateAcct(parent.getDateAcct());
    }

    public MJournal getParent() {
        if (this.parentJournal == null) {
            this.parentJournal = new MJournal(this.getCtx(), this.getGL_Journal_ID(), this.get_TrxName());
        }
        return this.parentJournal;
    }

    public void setCurrency(int currencyId, int conversionTypeId, BigDecimal currencyRate) {
        this.setC_Currency_ID(currencyId);
        if (conversionTypeId != 0) {
            this.setC_ConversionType_ID(conversionTypeId);
        }
        if (currencyRate != null && currencyRate.signum() == 0) {
            this.setCurrencyRate(currencyRate);
        }
    }

    @Override
    public void setC_Currency_ID(int currencyId) {
        if (currencyId == 0) {
            return;
        }
        super.setC_Currency_ID(currencyId);
        this.currencyPrecision = MCurrency.getStdPrecision(this.getCtx(), currencyId);
    }

    public int getPrecision() {
        return this.currencyPrecision;
    }

    @Override
    public void setCurrencyRate(BigDecimal currencyRate) {
        if (currencyRate == null) {
            this.log.warning("was NULL - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else if (currencyRate.signum() < 0) {
            this.log.warning("negative - " + currencyRate + " - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else {
            super.setCurrencyRate(currencyRate);
        }
    }

    public void setAmtAcct(BigDecimal amountAccountDebit, BigDecimal amountAccountCredit) {
        double rateDebit = 0.0;
        if (amountAccountDebit != null && amountAccountDebit.signum() != 0) {
            rateDebit = amountAccountDebit.doubleValue() / this.getAmtSourceDr().doubleValue();
            super.setAmtAcctDr(amountAccountDebit);
        }
        double rateCredit = 0.0;
        if (amountAccountCredit != null && amountAccountCredit.signum() != 0) {
            rateCredit = amountAccountCredit.doubleValue() / this.getAmtSourceCr().doubleValue();
            super.setAmtAcctCr(amountAccountCredit);
        }
        if (rateDebit != 0.0 && rateCredit != 0.0 && rateDebit != rateCredit) {
            this.log.warning("Rates Different DR=" + rateDebit + "(used) <> CR=" + rateCredit + "(ignored)");
            rateCredit = 0.0;
        }
        if (rateDebit < 0.0 || Double.isInfinite(rateDebit) || Double.isNaN(rateDebit)) {
            this.log.warning("DR Rate ignored - " + rateDebit);
            return;
        }
        if (rateCredit < 0.0 || Double.isInfinite(rateCredit) || Double.isNaN(rateCredit)) {
            this.log.warning("CR Rate ignored - " + rateCredit);
            return;
        }
        if (rateDebit != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateDebit));
        }
        if (rateCredit != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateCredit));
        }
    }

    @Override
    public void setC_ValidCombination_ID(int validCombinationId) {
        super.setC_ValidCombination_ID(validCombinationId);
        this.account = null;
        this.accountElement = null;
    }

    public void setC_ValidCombination_ID(MAccount account) {
        if (account == null) {
            throw new IllegalArgumentException("Account is null");
        }
        super.setC_ValidCombination_ID(account.getC_ValidCombination_ID());
        this.account = account;
        this.accountElement = null;
    }

    public MAccount getAccount_Combi() {
        if (this.account == null && this.getC_ValidCombination_ID() != 0) {
            this.account = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
        }
        return this.account;
    }

    public MElementValue getAccountElementValue() {
        MAccount account;
        if (this.accountElement == null && (account = this.getAccount_Combi()) != null && account.getAccount_ID() != 0) {
            this.accountElement = new MElementValue(this.getCtx(), account.getAccount_ID(), this.get_TrxName());
        }
        return this.accountElement;
    }

    public boolean isDocControlled() {
        MElementValue accountElementValue = this.getAccountElementValue();
        if (accountElementValue == null) {
            this.log.warning("Account not found for C_ValidCombination_ID=" + this.getC_ValidCombination_ID());
            return false;
        }
        return accountElementValue.isDocControlled();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "GL_JournalLine"));
            return false;
        }
        if (!this.getOrCreateCombination()) {
            return false;
        }
        if (this.getC_ValidCombination_ID() <= 0) {
            this.log.saveError("SaveError", Msg.parseTranslation(this.getCtx(), "@FillMandatory@@C_ValidCombination_ID@"));
            return false;
        }
        this.fillDimensionsFromCombination();
        BigDecimal currencyRate = this.getCurrencyRate();
        BigDecimal amountDebit = currencyRate.multiply(this.getAmtSourceDr());
        if (amountDebit.scale() > this.getPrecision()) {
            amountDebit = amountDebit.setScale(this.getPrecision(), RoundingMode.HALF_UP);
        }
        this.setAmtAcctDr(amountDebit);
        amountDebit = currencyRate.multiply(this.getAmtSourceCr());
        if (amountDebit.scale() > this.getPrecision()) {
            amountDebit = amountDebit.setScale(this.getPrecision(), RoundingMode.HALF_UP);
        }
        this.setAmtAcctCr(amountDebit);
        if (this.getAD_Org_ID() <= 0) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    private boolean updateJournalTotal() {
        StringBuilder sql2;
        int GL_JournalBatch_ID;
        String sql = "UPDATE GL_Journal j SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0) FROM GL_JournalLine jl WHERE jl.IsActive='Y' AND j.GL_Journal_ID=jl.GL_Journal_ID) WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("afterSave - Update Journal #" + no);
        }
        if ((GL_JournalBatch_ID = DB.getSQLValue(this.get_TrxName(), "SELECT GL_JournalBatch_ID FROM GL_Journal WHERE GL_Journal_ID=?", this.getGL_Journal_ID())) != 0 && (no = DB.executeUpdate((sql2 = new StringBuilder("UPDATE GL_JournalBatch jb").append(" SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(TotalDr),0), COALESCE(SUM(TotalCr),0)").append(" FROM GL_Journal j WHERE jb.GL_JournalBatch_ID=j.GL_JournalBatch_ID) ").append("WHERE GL_JournalBatch_ID=").append("(SELECT DISTINCT GL_JournalBatch_ID FROM GL_Journal WHERE GL_Journal_ID=").append(this.getGL_Journal_ID()).append(")")).toString(), this.get_TrxName())) != 1) {
            this.log.warning("Update Batch #" + no);
        }
        return no == 1;
    }

    private boolean getOrCreateCombination() {
        if (this.getC_ValidCombination_ID() == 0 || !this.is_new() && (this.is_ValueChanged("Account_ID") || this.is_ValueChanged("C_SubAcct_ID") || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("AD_OrgTrx_ID") || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_LocFrom_ID") || this.is_ValueChanged("C_LocTo_ID") || this.is_ValueChanged("C_SalesRegion_ID") || this.is_ValueChanged("C_Project_ID") || this.is_ValueChanged("C_Campaign_ID") || this.is_ValueChanged("C_Activity_ID") || this.is_ValueChanged("User1_ID") || this.is_ValueChanged("User2_ID") || this.is_ValueChanged("User3_ID") || this.is_ValueChanged("User4_ID")) || this.is_ValueChanged("UserElement1_ID") || this.is_ValueChanged("UserElement2_ID")) {
            MJournal gl = new MJournal(this.getCtx(), this.getGL_Journal_ID(), this.get_TrxName());
            MAcctSchema as = (MAcctSchema)this.getParent().getC_AcctSchema();
            Object errorFields = "";
            for (MAcctSchemaElement elem : MAcctSchemaElement.getAcctSchemaElements(as)) {
                if (!elem.isMandatory()) continue;
                String et = elem.getElementType();
                if ("AC".equals(et) && this.getAccount_ID() == 0) {
                    errorFields = (String)errorFields + "@Account_ID@, ";
                }
                if ("AY".equals(et) && this.getC_Activity_ID() == 0) {
                    errorFields = (String)errorFields + "@C_Activity_ID@, ";
                }
                if ("BP".equals(et) && this.getC_BPartner_ID() == 0) {
                    errorFields = (String)errorFields + "@C_BPartner_ID@, ";
                }
                if ("MC".equals(et) && this.getC_Campaign_ID() == 0) {
                    errorFields = (String)errorFields + "@C_Campaign_ID@, ";
                }
                if ("OO".equals(et) && this.getAD_Org_ID() == 0) {
                    errorFields = (String)errorFields + "@AD_Org_ID@, ";
                }
                if ("OT".equals(et) && this.getAD_OrgTrx_ID() == 0) {
                    errorFields = (String)errorFields + "@AD_OrgTrx_ID@, ";
                }
                if ("PR".equals(et) && this.getM_Product_ID() == 0) {
                    errorFields = (String)errorFields + "@M_Product_ID@, ";
                }
                if ("PJ".equals(et) && this.getC_Project_ID() == 0) {
                    errorFields = (String)errorFields + "@C_Project_ID@, ";
                }
                if ("SR".equals(et) && this.getC_SalesRegion_ID() == 0) {
                    errorFields = (String)errorFields + "@C_SalesRegion_ID@, ";
                }
                if ("U1".equals(et) && this.getUser1_ID() == 0) {
                    errorFields = (String)errorFields + "@User1_ID@, ";
                }
                if ("U2".equals(et) && this.getUser2_ID() == 0) {
                    errorFields = (String)errorFields + "@User2_ID@, ";
                }
                if ("U3".equals(et) && this.getUser3_ID() == 0) {
                    errorFields = (String)errorFields + "@User3_ID@, ";
                }
                if ("U4".equals(et) && this.getUser4_ID() == 0) {
                    errorFields = (String)errorFields + "@User4_ID@, ";
                }
                if ("X1".equals(et) && this.getUserElement1_ID() == 0) {
                    errorFields = (String)errorFields + "@UserElement1_ID@, ";
                }
                if (!"X2".equals(et) || this.getUserElement2_ID() != 0) continue;
                errorFields = (String)errorFields + "@UserElement2_ID@, ";
            }
            if (((String)errorFields).length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@IsMandatory@: " + ((String)errorFields).substring(0, ((String)errorFields).length() - 2)));
                return false;
            }
            MAccount account = MAccount.get(this.getCtx(), this.getAD_Client_ID(), this.getAD_Org_ID(), gl.getC_AcctSchema_ID(), this.getAccount_ID(), this.getC_SubAcct_ID(), this.getM_Product_ID(), this.getC_BPartner_ID(), this.getAD_OrgTrx_ID(), this.getC_LocFrom_ID(), this.getC_LocTo_ID(), this.getC_SalesRegion_ID(), this.getC_Project_ID(), this.getC_Campaign_ID(), this.getC_Activity_ID(), this.getUser1_ID(), this.getUser2_ID(), this.getUser3_ID(), this.getUser4_ID(), this.getUserElement1_ID(), this.getUserElement2_ID(), this.get_TrxName());
            if (account != null) {
                account.saveEx(this.get_TrxName());
                this.setC_ValidCombination_ID(account.get_ID());
                if (account.getAlias() != null && account.getAlias().length() > 0) {
                    this.setAlias_ValidCombination_ID(account.get_ID());
                } else {
                    this.setAlias_ValidCombination_ID(-1);
                }
            }
        }
        return true;
    }

    private void fillDimensionsFromCombination() {
        if (this.getC_ValidCombination_ID() > 0) {
            MAccount account = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
            this.setAD_Org_ID(account.getAD_Org_ID());
            this.setAccount_ID(account.getAccount_ID());
            this.setC_SubAcct_ID(account.getC_SubAcct_ID());
            this.setM_Product_ID(account.getM_Product_ID());
            this.setC_BPartner_ID(account.getC_BPartner_ID());
            this.setAD_OrgTrx_ID(account.getAD_OrgTrx_ID());
            this.setC_LocFrom_ID(account.getC_LocFrom_ID());
            this.setC_LocTo_ID(account.getC_LocTo_ID());
            this.setC_SalesRegion_ID(account.getC_SalesRegion_ID());
            this.setC_Project_ID(account.getC_Project_ID());
            this.setC_Campaign_ID(account.getC_Campaign_ID());
            this.setC_Activity_ID(account.getC_Activity_ID());
            this.setUser1_ID(account.getUser1_ID());
            this.setUser2_ID(account.getUser2_ID());
            this.setUser3_ID(account.getUser3_ID());
            this.setUser4_ID(account.getUser4_ID());
            this.setUserElement1_ID(account.getUserElement1_ID());
            this.setUserElement2_ID(account.getUserElement2_ID());
        }
    }
}

