/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Location;
import org.compiere.model.MAccount;
import org.compiere.model.MCountry;
import org.compiere.model.MRegion;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MLocation
extends X_C_Location
implements Comparator {
    private static final long serialVersionUID = 8332515185354248079L;
    public static String LOCATION_MAPS_URL_PREFIX = MSysConfig.getValue("LOCATION_MAPS_URL_PREFIX");
    public static String LOCATION_MAPS_ROUTE_PREFIX = MSysConfig.getValue("LOCATION_MAPS_ROUTE_PREFIX");
    public static String LOCATION_MAPS_SOURCE_ADDRESS = MSysConfig.getValue("LOCATION_MAPS_SOURCE_ADDRESS");
    public static String LOCATION_MAPS_DESTINATION_ADDRESS = MSysConfig.getValue("LOCATION_MAPS_DESTINATION_ADDRESS");
    private static CCache<Integer, MLocation> s_cache = new CCache("C_Location", 100, 30);
    private static CLogger s_log = CLogger.getCLogger(MLocation.class);
    private MCountry m_c = null;
    private MRegion m_r = null;

    public static String getMapUrl(MLocation location) {
        Object locationUrl = "";
        locationUrl = location.getLatitude().signum() != 0 && location.getLongitude().signum() != 0 ? location.getLatitude() + "," + location.getLongitude() : location.getMapsLocation();
        return LOCATION_MAPS_URL_PREFIX + (String)locationUrl;
    }

    public static String getRouteUrl(MLocation from, MLocation to) {
        Object locationTo = "";
        Object locationFrom = "";
        locationFrom = to.getLongitude().signum() != 0 && to.getLatitude().signum() != 0 ? to.getLatitude() + "," + to.getLongitude() : to.getMapsLocation();
        locationTo = from.getLatitude().signum() != 0 && from.getLongitude().signum() != 0 ? from.getLatitude() + "," + from.getLongitude() : from.getMapsLocation();
        return LOCATION_MAPS_ROUTE_PREFIX + LOCATION_MAPS_SOURCE_ADDRESS + (String)locationFrom + LOCATION_MAPS_DESTINATION_ADDRESS + (String)locationTo;
    }

    public static MLocation get(Properties ctx, int C_Location_ID, String trxName) {
        if (C_Location_ID == 0) {
            return new MLocation(ctx, C_Location_ID, trxName);
        }
        Integer key = C_Location_ID;
        MLocation retValue = null;
        if (trxName == null) {
            retValue = s_cache.get(key);
        }
        if (retValue != null) {
            return retValue;
        }
        retValue = new MLocation(ctx, C_Location_ID, trxName);
        if (retValue.get_ID() != 0) {
            if (trxName == null) {
                s_cache.put(key, retValue);
            }
            return retValue;
        }
        return null;
    }

    public static MLocation getBPLocation(Properties ctx, int C_BPartner_Location_ID, String trxName) {
        if (C_BPartner_Location_ID == 0) {
            return null;
        }
        MLocation loc = null;
        String sql = "SELECT * FROM C_Location l WHERE C_Location_ID IN (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?)";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_BPartner_Location_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                loc = new MLocation(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql + " - " + C_BPartner_Location_ID, e);
            loc = null;
        }
        return loc;
    }

    public MLocation(Properties ctx, int C_Location_ID, String trxName) {
        super(ctx, C_Location_ID, trxName);
        if (C_Location_ID == 0) {
            MCountry defaultCountry = MCountry.getDefault(this.getCtx());
            this.setCountry(defaultCountry);
            MRegion defaultRegion = MRegion.getDefault(this.getCtx());
            if (defaultRegion != null && defaultRegion.getC_Country_ID() == defaultCountry.getC_Country_ID()) {
                this.setRegion(defaultRegion);
            }
        }
    }

    public MLocation(MCountry country, MRegion region) {
        super(country.getCtx(), 0, country.get_TrxName());
        this.setCountry(country);
        this.setRegion(region);
    }

    public MLocation(Properties ctx, int C_Country_ID, int C_Region_ID, String city, String trxName) {
        super(ctx, 0, trxName);
        this.setC_Country_ID(C_Country_ID);
        this.setC_Region_ID(C_Region_ID);
        this.setCity(city);
    }

    public MLocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setCountry(MCountry country) {
        this.m_c = country != null ? country : MCountry.getDefault(this.getCtx());
        super.setC_Country_ID(this.m_c.getC_Country_ID());
    }

    @Override
    public void setC_Country_ID(int C_Country_ID) {
        if (this.getC_Country_ID() != C_Country_ID) {
            this.setRegion(null);
        }
        this.setCountry(MCountry.get(this.getCtx(), C_Country_ID));
    }

    public MCountry getCountry() {
        if (this.m_c != null && this.m_c.get_ID() != this.getC_Country_ID()) {
            this.m_c = null;
        }
        if (this.m_c == null) {
            this.m_c = this.getC_Country_ID() != 0 ? MCountry.get(this.getCtx(), this.getC_Country_ID()) : MCountry.getDefault(this.getCtx());
        }
        return this.m_c;
    }

    public String getCountryName() {
        return this.getCountry().getName();
    }

    public String getCountry(boolean local) {
        if (local && this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID()) {
            return null;
        }
        return this.getCountryName();
    }

    public String getCountry(boolean local, String language) {
        if (local && this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID()) {
            return null;
        }
        MCountry mc = this.getCountry();
        return mc.getTrlName(language);
    }

    public void setRegion(MRegion region) {
        this.m_r = region;
        if (region == null) {
            super.setC_Region_ID(0);
        } else {
            super.setC_Region_ID(this.m_r.getC_Region_ID());
            this.setRegionName(this.m_r.getName());
            if (this.m_r.getC_Country_ID() != this.getC_Country_ID()) {
                this.log.info("Region(" + region + ") C_Country_ID=" + region.getC_Country_ID() + " - From  C_Country_ID=" + this.getC_Country_ID());
                this.setC_Country_ID(region.getC_Country_ID());
            }
        }
    }

    @Override
    public void setC_Region_ID(int C_Region_ID) {
        if (C_Region_ID == 0) {
            this.setRegion(null);
        } else if (this.getC_Country_ID() != 0) {
            MCountry cc = this.getCountry();
            if (cc.isValidRegion(C_Region_ID)) {
                super.setC_Region_ID(C_Region_ID);
            } else {
                this.setRegion(null);
            }
        } else {
            this.setRegion(MRegion.get(this.getCtx(), C_Region_ID));
        }
    }

    public MRegion getRegion() {
        if (this.m_r != null && this.m_r.get_ID() != this.getC_Region_ID()) {
            this.m_r = null;
        }
        if (this.m_r == null && this.getC_Region_ID() != 0) {
            this.m_r = MRegion.get(this.getCtx(), this.getC_Region_ID());
        }
        return this.m_r;
    }

    @Override
    public String getRegionName() {
        return this.getRegionName(false);
    }

    public String getRegionName(boolean getFromRegion) {
        if (getFromRegion && this.getCountry().isHasRegion() && this.getRegion() != null) {
            super.setRegionName("");
            return this.getRegion().getName();
        }
        String regionName = super.getRegionName();
        if (regionName == null) {
            regionName = "";
        }
        return regionName;
    }

    public boolean equals(int C_Country_ID, int C_Region_ID, String Postal, String Postal_Add, String City, String Address1, String Address2) {
        if (C_Country_ID != 0 && this.getC_Country_ID() != C_Country_ID) {
            return false;
        }
        if (!this.equalsNull(Postal, this.getPostal())) {
            return false;
        }
        if (!this.equalsNull(Postal_Add, this.getPostal_Add())) {
            return false;
        }
        if (!this.equalsNull(City, this.getCity())) {
            return false;
        }
        if (!this.equalsNull(Address1, this.getAddress1())) {
            return false;
        }
        return this.equalsNull(Address2, this.getAddress2());
    }

    private boolean equalsNull(String c1, String c2) {
        if (c1 == null) {
            c1 = "";
        }
        if (c2 == null) {
            c2 = "";
        }
        return c1.equalsIgnoreCase(c2);
    }

    @Override
    public boolean equals(Object cmp) {
        if (cmp == null) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            return ((PO)cmp).get_ID() == this.get_ID();
        }
        return this.equals(cmp);
    }

    public boolean isAddressLinesReverse() {
        if (this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID()) {
            return this.getCountry().isAddressLinesLocalReverse();
        }
        return this.getCountry().isAddressLinesReverse();
    }

    public String getCityRegionPostal() {
        return this.parseCRP(this.getCountry());
    }

    private String parseCRP(MCountry c) {
        if (c == null) {
            return "CountryNotFound";
        }
        boolean local = this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID();
        String inStr = local ? c.getDisplaySequenceLocal() : c.getDisplaySequence();
        StringBuffer outStr = new StringBuffer();
        int i = inStr.indexOf(64);
        while (i != -1) {
            String token;
            outStr.append(inStr.substring(0, i));
            inStr = inStr.substring(i + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                token = "";
                j = i + 1;
            } else {
                token = inStr.substring(0, j);
            }
            if (token.equals("C")) {
                if (this.getCity() != null) {
                    outStr.append(this.getCity());
                }
            } else if (token.equals("R")) {
                if (this.getRegion() != null) {
                    outStr.append(this.getRegion().getName());
                } else if (super.getRegionName() != null && super.getRegionName().length() > 0) {
                    outStr.append(super.getRegionName());
                }
            } else if (token.equals("P")) {
                if (this.getPostal() != null) {
                    outStr.append(this.getPostal());
                }
            } else if (token.equals("A")) {
                String add = this.getPostal_Add();
                if (add != null && add.length() > 0) {
                    outStr.append("-").append(add);
                }
            } else {
                outStr.append("@").append(token).append("@");
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i = inStr.indexOf(64);
        }
        outStr.append(inStr);
        if (c.getDisplaySequence().indexOf("@R@") == -1 && super.getRegionName() != null && super.getRegionName().length() > 0) {
            outStr.append(" ").append(super.getRegionName());
        }
        String retValue = Util.replace(outStr.toString(), "\\n", "\n");
        this.log.finest("parseCRP - " + c.getDisplaySequence() + " -> " + retValue);
        return retValue;
    }

    @Override
    public String toString() {
        StringBuffer retStr = new StringBuffer();
        if (this.isAddressLinesReverse()) {
            retStr.append(", ").append(this.parseCRP(this.getCountry()));
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append(", ").append(this.getAddress4());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append(", ").append(this.getAddress3());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append(", ").append(this.getAddress2());
            }
            if (this.getAddress1() != null) {
                retStr.append(this.getAddress1());
            }
        } else {
            if (this.getAddress1() != null) {
                retStr.append(this.getAddress1());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append(", ").append(this.getAddress2());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append(", ").append(this.getAddress3());
            }
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append(", ").append(this.getAddress4());
            }
            retStr.append(", ").append(this.parseCRP(this.getCountry()));
        }
        return retStr.toString();
    }

    public String toStringCR() {
        StringBuffer retStr = new StringBuffer();
        if (this.isAddressLinesReverse()) {
            retStr.append(this.parseCRP(this.getCountry()));
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append("\n").append(this.getAddress4());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append("\n").append(this.getAddress3());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append("\n").append(this.getAddress2());
            }
            if (this.getAddress1() != null) {
                retStr.append("\n").append(this.getAddress1());
            }
        } else {
            if (this.getAddress1() != null) {
                retStr.append(this.getAddress1());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append("\n").append(this.getAddress2());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append("\n").append(this.getAddress3());
            }
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append("\n").append(this.getAddress4());
            }
            retStr.append("\n").append(this.parseCRP(this.getCountry()));
        }
        return retStr.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer("MLocation=[");
        sb.append(this.get_ID()).append(",C_Country_ID=").append(this.getC_Country_ID()).append(",C_Region_ID=").append(this.getC_Region_ID()).append(",Postal=").append(this.getPostal()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int city_id;
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (this.getC_Region_ID() != 0 || this.getRegionName() != null) {
            if (this.m_c == null || this.m_c.getC_Country_ID() != this.getC_Country_ID()) {
                this.getCountry();
            }
            if (!this.m_c.isHasRegion()) {
                this.setC_Region_ID(0);
                this.setRegionName(null);
            }
        }
        if (this.getC_City_ID() <= 0 && this.getCity() != null && this.getCity().length() > 0 && (city_id = DB.getSQLValue(this.get_TrxName(), "SELECT C_City_ID FROM C_City WHERE C_Country_ID=? AND COALESCE(C_Region_ID,0)=? AND Name=?", this.getC_Country_ID(), this.getC_Region_ID(), this.getCity())) > 0) {
            this.setC_City_ID(city_id);
        }
        if (this.m_c != null && !this.m_c.isAllowCitiesOutOfList() && this.getC_City_ID() <= 0) {
            this.log.saveError("CityNotFound", Msg.translate(this.getCtx(), "CityNotFound"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && ("Y".equals(Env.getContext(this.getCtx(), "$Element_LF")) || "Y".equals(Env.getContext(this.getCtx(), "$Element_LT"))) && (this.is_ValueChanged("Postal") || this.is_ValueChanged("City"))) {
            MAccount.updateValueDescription(this.getCtx(), "(C_LocFrom_ID=" + this.getC_Location_ID() + " OR C_LocTo_ID=" + this.getC_Location_ID() + ")", this.get_TrxName());
        }
        return success;
    }

    public String getMapsLocation() {
        MRegion region = new MRegion(Env.getCtx(), this.getC_Region_ID(), this.get_TrxName());
        Object address = "";
        address = (String)address + (String)(this.getAddress1() != null ? this.getAddress1() + ", " : "");
        address = (String)address + (String)(this.getAddress2() != null ? this.getAddress2() + ", " : "");
        address = (String)address + (String)(this.getCity() != null ? this.getCity() + ", " : "");
        address = (String)address + (String)(region.getName() != null ? region.getName() + ", " : "");
        address = (String)address + (this.getCountryName() != null ? this.getCountryName() : "");
        return ((String)address).replace(" ", "+");
    }
}

