/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_MatchInv;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMatchInv
extends X_M_MatchInv
implements IDocumentLine {
    private static final long serialVersionUID = 3668871839074170205L;
    private static CLogger s_log = CLogger.getCLogger(MMatchInv.class);

    public static List<MMatchInv> getInOutLine(MInOutLine inOutLine) {
        return new Query(inOutLine.getCtx(), "M_MatchInv", "M_InOutLine_ID=?", inOutLine.get_TrxName()).setParameters(inOutLine.getM_InOutLine_ID()).list();
    }

    public static MMatchInv[] get(Properties ctx, int M_InOutLine_ID, int C_InvoiceLine_ID, String trxName) {
        if (M_InOutLine_ID <= 0 || C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "M_InOutLine_ID=? AND C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "M_InOutLine_ID=? AND C_InvoiceLine_ID=?", trxName).setParameters(M_InOutLine_ID, C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        if (C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", whereClause, trxName).setParameters(C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    @Deprecated
    public static MMatchInv[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)", trxName).setParameters(M_InOut_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static List<MMatchInv> getByInOut(Properties ctx, int inOutId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("Reversal_ID IS NULL AND EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)");
        return new Query(ctx, "M_MatchInv", whereClause.toString(), trxName).setParameters(inOutId).setClient_ID().list();
    }

    public static MMatchInv[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchInv[0];
        }
        String whereClause = " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)", trxName).setParameters(C_Invoice_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static List<MMatchInv> getByInvoiceId(Properties ctx, int invoiceId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("Reversal_ID IS NULL AND EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)");
        return new Query(ctx, "M_MatchInv", whereClause.toString(), trxName).setClient_ID().setParameters(invoiceId).list();
    }

    public MMatchInv(Properties ctx, int M_MatchInv_ID, String trxName) {
        super(ctx, M_MatchInv_ID, trxName);
        if (M_MatchInv_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchInv(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchInv(MInvoiceLine invoiceLine, Timestamp dateTrx, BigDecimal qty) {
        this(invoiceLine.getCtx(), 0, invoiceLine.get_TrxName());
        this.setClientOrg(invoiceLine);
        this.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(invoiceLine.getM_InOutLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
            this.setDateAcct(dateTrx);
        }
        this.setM_Product_ID(invoiceLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(invoiceLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(MDocType.getDocType("MXI", this.getAD_Org_ID()));
        }
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && newRecord) {
            MInOutLine inOutLine = (MInOutLine)this.getM_InOutLine();
            for (MTransaction trx : MTransaction.getByInOutLine(inOutLine)) {
                CostEngineFactory.getCostEngine(this.getAD_Client_ID()).createCostDetail(trx, this);
            }
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
        Timestamp shipDate = DB.getSQLValueTS(this.get_TrxName(), sql, this.getM_InOutLine_ID());
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXI", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(Table_ID, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.deleteMatchInvCostDetail();
            MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            int C_OrderLine_ID = iLine.getC_OrderLine_ID();
            if (C_OrderLine_ID == 0) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                C_OrderLine_ID = ioLine.getC_OrderLine_ID();
            }
            if (C_OrderLine_ID == 0) {
                return success;
            }
            MMatchPO[] mPO = MMatchPO.get(this.getCtx(), C_OrderLine_ID, this.getC_InvoiceLine_ID(), this.get_TrxName());
            for (int i2 = 0; i2 < mPO.length; ++i2) {
                if (mPO[i2].getM_InOutLine_ID() == 0) {
                    mPO[i2].delete(true);
                    continue;
                }
                mPO[i2].setC_InvoiceLine_ID(null);
                mPO[i2].setQty(Env.ZERO);
                mPO[i2].saveEx();
            }
        }
        return success;
    }

    private String deleteMatchInvCostDetail() {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        for (int asn = 0; asn < acctschemas.length; ++asn) {
            MAcctSchema as = acctschemas[asn];
            if (as.isSkipOrg(this.getAD_Org_ID())) continue;
            MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
            String CostingLevel = product.getCostingLevel(as);
            int Org_ID = this.getAD_Org_ID();
            int M_ASI_ID = this.getM_AttributeSetInstance_ID();
            if ("C".equals(CostingLevel)) {
                Org_ID = 0;
                M_ASI_ID = 0;
            } else if ("O".equals(CostingLevel)) {
                M_ASI_ID = 0;
            } else if ("B".equals(CostingLevel)) {
                Org_ID = 0;
            }
            List<MCostElement> ces = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
            List<MCostType> cts = MCostType.get(this.getCtx(), this.get_TrxName());
            for (MCostType ct : cts) {
                if (!ct.isActive()) continue;
                for (MCostElement ce : ces) {
                    String whereClause = "c_invoiceline_id =? and m_costtype_id=? and m_costelement_ID=?";
                    List cds = new Query(this.getCtx(), "M_CostDetail", whereClause, this.get_TrxName()).setParameters(this.getC_InvoiceLine_ID(), ct.getM_CostType_ID(), ce.getM_CostElement_ID()).list();
                    for (MCostDetail cd : cds) {
                        cd.delete(true);
                    }
                }
            }
        }
        return "";
    }

    @Override
    public int getM_Locator_ID() {
        return -1;
    }

    @Override
    public BigDecimal getMovementQty() {
        return this.getQty();
    }

    @Override
    public BigDecimal getPriceActual() {
        MInvoiceLine invoiceLine = (MInvoiceLine)this.getC_InvoiceLine();
        BigDecimal priceActual = MConversionRate.convertBase(this.getCtx(), invoiceLine.getPriceActual(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        if ("APC".equals(invoiceLine.getParent().getC_DocType().getDocBaseType())) {
            return priceActual.negate();
        }
        return priceActual;
    }

    @Override
    public BigDecimal getPriceActualCurrency() {
        MInvoiceLine invoiceLine = (MInvoiceLine)this.getC_InvoiceLine();
        return invoiceLine.getPriceActual();
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT i.C_Currency_ID FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE il.C_InvoiceLine_ID = ? ", this.getC_InvoiceLine_ID());
    }

    @Override
    public int getC_ConversionType_ID() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT i.C_ConversionType_ID FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID) WHERE il.C_InvoiceLine_ID = ? ", this.getC_InvoiceLine_ID());
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public int getReversalLine_ID() {
        return this.getReversal_ID();
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    public MMatchInv reverseIt(Timestamp reversalDate) {
        if (this.isProcessed() && this.getReversal_ID() == 0) {
            int reversalLineId;
            MMatchInv reversal = new MMatchInv(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(this, reversal);
            if (this.getC_InvoiceLine_ID() > 0) {
                reversalLineId = this.getC_InvoiceLine().getReversalLine_ID();
                if (reversalLineId > 0) {
                    reversal.setC_InvoiceLine_ID(reversalLineId);
                } else {
                    reversal.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
                }
            }
            if (this.getM_InOutLine_ID() > 0) {
                reversalLineId = this.getM_InOutLine().getReversalLine_ID();
                if (reversalLineId > 0) {
                    reversal.setM_InOutLine_ID(reversalLineId);
                } else {
                    reversal.setM_InOutLine_ID(this.getM_InOutLine_ID());
                }
            }
            reversal.setAD_Org_ID(this.getAD_Org_ID());
            reversal.setDescription("(->" + this.getDocumentNo() + ")");
            reversal.setQty(this.getQty().negate());
            reversal.setDateAcct(reversalDate);
            reversal.setDateTrx(reversalDate);
            reversal.set_ValueNoCheck("DocumentNo", null);
            reversal.setPosted(false);
            reversal.setReversal_ID(this.getM_MatchInv_ID());
            reversal.saveEx();
            this.setDescription("(" + reversal.getDocumentNo() + "<-)");
            this.setReversal_ID(reversal.getM_MatchInv_ID());
            this.saveEx();
            return reversal;
        }
        return null;
    }

    @Override
    public boolean isReversalParent() {
        return false;
    }
}

