/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_AD_Menu;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MMenu
extends X_AD_Menu {
    private static final long serialVersionUID = -6671861281736697100L;
    private static CCache<Integer, MMenu> cache = new CCache("AD_Menu", 10);
    private static CLogger s_log = CLogger.getCLogger(MMenu.class);

    public static MMenu[] get(Properties ctx, String whereClause) {
        return MMenu.get(ctx, whereClause, null);
    }

    public static MMenu[] get(Properties ctx, String whereClause, String trxName) {
        List<MMenu> list = new Query(ctx, "AD_Menu", whereClause, trxName).list();
        MMenu[] retValue = new MMenu[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMenu(Properties ctx, int AD_Menu_ID, String trxName) {
        super(ctx, AD_Menu_ID, trxName);
        if (AD_Menu_ID == 0) {
            this.setEntityType("U");
            this.setIsReadOnly(false);
            this.setIsSOTrx(false);
            this.setIsSummary(false);
        }
    }

    public MMenu(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String action;
        if (this.isSummary()) {
            if (this.getAction() != null) {
                this.setAction(null);
            }
            this.setIsCentrallyMaintained(false);
        }
        if ((action = this.getAction()) == null) {
            action = "";
        }
        if (this.getAD_Window_ID() != 0 && !action.equals("W")) {
            this.setAD_Window_ID(0);
        }
        if (this.getAD_Form_ID() != 0 && !action.equals("X")) {
            this.setAD_Form_ID(0);
        }
        if (this.getAD_Browse_ID() != 0 && !action.equals("S")) {
            this.setAD_Browse_ID(0);
        }
        if (this.getAD_Workflow_ID() != 0 && !action.equals("F")) {
            this.setAD_Workflow_ID(0);
        }
        if (this.getAD_Workbench_ID() != 0 && !action.equals("B")) {
            this.setAD_Workbench_ID(0);
        }
        if (this.getAD_Task_ID() != 0 && !action.equals("T")) {
            this.setAD_Task_ID(0);
        }
        if (this.getAD_Process_ID() != 0 && !action.equals("P") && !action.equals("R")) {
            this.setAD_Process_ID(0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMenu_ID(String menuName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        int retValue;
        block4: {
            retValue = 0;
            String SQL = "SELECT AD_Menu_ID FROM AD_Menu WHERE Name = ?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(SQL, null);
                pstmt.setString(1, menuName);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                retValue = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        DB.close(rs, pstmt);
        return retValue;
    }

    public static MMenu getFromId(Properties ctx, int menuId) {
        MMenu menuItem = cache.get(menuId);
        if (menuItem == null) {
            menuItem = (MMenu)new Query(ctx, "AD_Menu", "AD_Menu_ID = " + menuId, null).first();
            if (menuItem == null) {
                return null;
            }
            cache.put(menuId, menuItem);
        }
        return menuItem;
    }

    public int getOptionId() {
        if (this.getAction() == null) {
            return 0;
        }
        if (this.getAction().equals("W")) {
            return this.getAD_Window_ID();
        }
        if (this.getAction().equals("P") || this.getAction().equals("R")) {
            return this.getAD_Process_ID();
        }
        if (this.getAction().equals("B")) {
            return this.getAD_Workbench_ID();
        }
        if (this.getAction().equals("F")) {
            return this.getAD_Workflow_ID();
        }
        if (this.getAction().equals("T")) {
            return this.getAD_Task_ID();
        }
        if (this.getAction().equals("X")) {
            return this.getAD_Form_ID();
        }
        if (this.getAction().equals("S")) {
            return this.getAD_Browse_ID();
        }
        return 0;
    }
}

