/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_M_ProductPrice;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MProductPrice
extends X_M_ProductPrice {
    private static final long serialVersionUID = 9187555438223385521L;
    private static CLogger s_log = CLogger.getCLogger(MProductPrice.class);

    public static MProductPrice get(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, String trxName) {
        String whereClause = "M_PriceList_Version_ID=? AND M_Product_ID=?";
        MProductPrice retValue = (MProductPrice)new Query(ctx, "M_ProductPrice", "M_PriceList_Version_ID=? AND M_Product_ID=?", trxName).setParameters(M_PriceList_Version_ID, M_Product_ID).first();
        return retValue;
    }

    public MProductPrice(Properties ctx, int productPriceId, String trxName) {
        super(ctx, productPriceId, trxName);
        if (productPriceId <= 0) {
            this.setPriceLimit(Env.ZERO);
            this.setPriceList(Env.ZERO);
            this.setPriceStd(Env.ZERO);
        }
    }

    public MProductPrice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductPrice(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.setM_Product_ID(M_Product_ID);
    }

    public MProductPrice(Properties ctx, int M_PriceList_Version_ID, int M_Product_ID, BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit, String trxName) {
        this(ctx, M_PriceList_Version_ID, M_Product_ID, trxName);
        this.setPrices(PriceList, PriceStd, PriceLimit);
    }

    public MProductPrice(MPriceListVersion plv, int M_Product_ID, BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit) {
        this(plv.getCtx(), 0, plv.get_TrxName());
        this.setClientOrg(plv);
        this.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setPrices(PriceList, PriceStd, PriceLimit);
    }

    public void setPrices(BigDecimal PriceList, BigDecimal PriceStd, BigDecimal PriceLimit) {
        this.setPriceLimit(PriceLimit.setScale(this.getM_PriceList_Version().getM_PriceList().getPricePrecision(), RoundingMode.HALF_UP));
        this.setPriceList(PriceList.setScale(this.getM_PriceList_Version().getM_PriceList().getPricePrecision(), RoundingMode.HALF_UP));
        this.setPriceStd(PriceStd.setScale(this.getM_PriceList_Version().getM_PriceList().getPricePrecision(), RoundingMode.HALF_UP));
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProductPrice[");
        sb.append(this.getM_PriceList_Version_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",PriceList=").append(this.getPriceList()).append("]");
        return sb.toString();
    }
}

